/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.ping.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dmillerw.ping.client.PingHandler;
import dmillerw.ping.client.gui.PingSelectGui;
import dmillerw.ping.data.PingType;
import dmillerw.ping.util.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ping", value={Dist.CLIENT})
public class RenderHandler {
    public static final int ITEM_PADDING = 10;
    public static final int ITEM_SIZE = 32;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.m_91087_();
            if ((mc.f_91073_ == null || mc.m_91104_()) && PingSelectGui.active) {
                PingSelectGui.deactivate();
            }
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGameOverlayEvent event) {
        if (!(event instanceof RenderGameOverlayEvent.Post) || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && !mc.f_91066_.f_92062_ && !mc.m_91104_() && PingSelectGui.active) {
            RenderHandler.renderGui(event.getMatrixStack());
            RenderHandler.renderText(event.getMatrixStack());
        }
    }

    private static void renderGui(PoseStack poseStack) {
        int numOfItems = PingType.values().length - 1;
        Minecraft mc = Minecraft.m_91087_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        if (((Boolean)Config.VISUAL.menuBackground.get()).booleanValue()) {
            poseStack.m_85836_();
            RenderSystem.m_69472_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            int halfWidth = 32 * numOfItems - 10 * numOfItems;
            int halfHeight = 21;
            int backgroundX = mc.m_91268_().m_85445_() / 2 - halfWidth;
            int backgroundY = mc.m_91268_().m_85446_() / 4 - halfHeight;
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            bufferBuilder.m_5483_((double)backgroundX, (double)(backgroundY + 15 + halfHeight * 2), 0.0).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
            bufferBuilder.m_5483_((double)(backgroundX + halfWidth * 2), (double)(backgroundY + 15 + halfHeight * 2), 0.0).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
            bufferBuilder.m_5483_((double)(backgroundX + halfWidth * 2), (double)backgroundY, 0.0).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
            bufferBuilder.m_5483_((double)backgroundX, (double)backgroundY, 0.0).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
            tessellator.m_85914_();
            RenderSystem.m_69461_();
            RenderSystem.m_69493_();
            poseStack.m_85849_();
        }
        poseStack.m_85836_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)PingHandler.TEXTURE);
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        double mouseX = mc.f_91067_.m_91589_() * ((double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85443_());
        double mouseY = mc.f_91067_.m_91594_() * ((double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85444_());
        int half = numOfItems / 2;
        for (int i = 0; i < numOfItems; ++i) {
            PingType type = PingType.values()[i + 1];
            int drawX = mc.m_91268_().m_85445_() / 2 - 32 * half - 10 * half;
            int drawY = mc.m_91268_().m_85446_() / 4;
            boolean mouseIn = mouseX >= (double)(drawX += 21 + 10 * i + 32 * i) - 16.0 && mouseX <= (double)drawX + 16.0 && mouseY >= (double)drawY - 16.0 && mouseY <= (double)drawY + 16.0;
            float min = -16.0f;
            float max = 16.0f;
            int r = 255;
            int g = 255;
            int b = 255;
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            if (mouseIn) {
                r = (Integer)Config.VISUAL.pingR.get();
                g = (Integer)Config.VISUAL.pingG.get();
                b = (Integer)Config.VISUAL.pingB.get();
            }
            bufferBuilder.m_5483_((double)((float)drawX + min), (double)((float)drawY + max), 0.0).m_7421_(PingType.BACKGROUND.getMinU(), PingType.BACKGROUND.getMaxV()).m_6122_(r, g, b, 255).m_5752_();
            bufferBuilder.m_5483_((double)((float)drawX + max), (double)((float)drawY + max), 0.0).m_7421_(PingType.BACKGROUND.getMaxU(), PingType.BACKGROUND.getMaxV()).m_6122_(r, g, b, 255).m_5752_();
            bufferBuilder.m_5483_((double)((float)drawX + max), (double)((float)drawY + min), 0.0).m_7421_(PingType.BACKGROUND.getMaxU(), PingType.BACKGROUND.getMinV()).m_6122_(r, g, b, 255).m_5752_();
            bufferBuilder.m_5483_((double)((float)drawX + min), (double)((float)drawY + min), 0.0).m_7421_(PingType.BACKGROUND.getMinU(), PingType.BACKGROUND.getMinV()).m_6122_(r, g, b, 255).m_5752_();
            tessellator.m_85914_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferBuilder.m_5483_((double)((float)drawX + min), (double)((float)drawY + max), 0.0).m_7421_(type.getMinU(), type.getMaxV()).m_6122_(255, 255, 255, 255).m_5752_();
            bufferBuilder.m_5483_((double)((float)drawX + max), (double)((float)drawY + max), 0.0).m_7421_(type.getMaxU(), type.getMaxV()).m_6122_(255, 255, 255, 255).m_5752_();
            bufferBuilder.m_5483_((double)((float)drawX + max), (double)((float)drawY + min), 0.0).m_7421_(type.getMaxU(), type.getMinV()).m_6122_(255, 255, 255, 255).m_5752_();
            bufferBuilder.m_5483_((double)((float)drawX + min), (double)((float)drawY + min), 0.0).m_7421_(type.getMinU(), type.getMinV()).m_6122_(255, 255, 255, 255).m_5752_();
            tessellator.m_85914_();
        }
        poseStack.m_85849_();
    }

    private static void renderText(PoseStack poseStack) {
        Minecraft mc = Minecraft.m_91087_();
        int numOfItems = PingType.values().length - 1;
        double mouseX = mc.f_91067_.m_91589_() * ((double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85443_());
        double mouseY = mc.f_91067_.m_91594_() * ((double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85444_());
        int halfHeight = 21;
        int backgroundY = mc.m_91268_().m_85446_() / 4 - halfHeight;
        int half = numOfItems / 2;
        for (int i = 0; i < numOfItems; ++i) {
            boolean mouseIn;
            PingType type = PingType.values()[i + 1];
            int drawX = mc.m_91268_().m_85445_() / 2 - 32 * half - 10 * half;
            int drawY = mc.m_91268_().m_85446_() / 4;
            boolean bl = mouseIn = mouseX >= (double)(drawX += 21 + 10 * i + 32 * i) - 16.0 && mouseX <= (double)drawX + 16.0 && mouseY >= (double)drawY - 16.0 && mouseY <= (double)drawY + 16.0;
            if (!mouseIn) continue;
            poseStack.m_85836_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.f_91062_.m_92750_(poseStack, type.toString(), (float)mc.m_91268_().m_85445_() / 2.0f - (float)mc.f_91062_.m_92895_(type.toString()) / 2.0f, (float)(backgroundY + halfHeight * 2), 0xFFFFFF);
            poseStack.m_85849_();
        }
    }
}

