/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.ping.util;

import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static final Visual VISUAL = new Visual(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();

    public static class General {
        public ForgeConfigSpec.DoubleValue pingAcceptDistance;
        public ForgeConfigSpec.IntValue pingDuration;
        public ForgeConfigSpec.BooleanValue sound;

        General(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.pingAcceptDistance = builder.comment("Maximum distance a Ping can be from you and still be received").translation("ping.configgui.pingAcceptDistance").defineInRange("pingAcceptDistance", 64.0, 0.0, 255.0);
            this.pingDuration = builder.comment("How many ticks a Ping should remain active before disappearing").translation("ping.configgui.pingDuration").defineInRange("pingDuration", 125, 0, 0x7FFFFFFE);
            this.sound = builder.comment("Whether to play a sound when a Ping is received").translation("ping.configgui.sound").define("sound", true);
            builder.pop();
        }
    }

    public static class Visual {
        public ForgeConfigSpec.IntValue pingR;
        public ForgeConfigSpec.IntValue pingG;
        public ForgeConfigSpec.IntValue pingB;
        public ForgeConfigSpec.BooleanValue blockOverlay;
        public ForgeConfigSpec.BooleanValue menuBackground;

        Visual(ForgeConfigSpec.Builder builder) {
            builder.push("visual");
            this.blockOverlay = builder.comment("Whether to render a colored overlay on the Pinged block").translation("ping.configgui.blockOverlay").define("blockOverlay", true);
            this.menuBackground = builder.comment("Whether to render the Ping Menu background").translation("ping.configgui.menuBackground").define("menuBackground", true);
            builder.push("pingColor");
            this.pingR = builder.translation("ping.configgui.pingRed").defineInRange("red", 255, 0, 255);
            this.pingG = builder.translation("ping.configgui.pingGreen").defineInRange("green", 0, 0, 255);
            this.pingB = builder.translation("ping.configgui.pingBlue").defineInRange("blue", 0, 0, 255);
            builder.pop();
        }
    }
}

