/*
 * Decompiled with CFR 0.152.
 */
package eutros.framedcompactdrawers.block;

import com.google.common.collect.ImmutableList;
import com.jaquadro.minecraft.storagedrawers.client.renderer.TileEntityDrawersRenderer;
import eutros.framedcompactdrawers.FramedCompactDrawers;
import eutros.framedcompactdrawers.block.BlockCompDrawersCustom;
import eutros.framedcompactdrawers.block.BlockControllerCustom;
import eutros.framedcompactdrawers.block.BlockDrawersStandardCustom;
import eutros.framedcompactdrawers.block.BlockSlaveCustom;
import eutros.framedcompactdrawers.block.BlockTrimCustom;
import eutros.framedcompactdrawers.block.tile.TileCompDrawersCustom;
import eutros.framedcompactdrawers.block.tile.TileControllerCustom;
import eutros.framedcompactdrawers.block.tile.TileDrawersStandardCustom;
import eutros.framedcompactdrawers.block.tile.TileSlaveCustom;
import eutros.framedcompactdrawers.block.tile.TileTrimCustom;
import eutros.framedcompactdrawers.item.ItemDrawersCustom;
import eutros.framedcompactdrawers.item.ItemOtherCustom;
import eutros.framedcompactdrawers.render.RenderHelper;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBlocks {
    public static BlockCompDrawersCustom framedCompactDrawer;
    public static BlockControllerCustom framedDrawerController;
    public static BlockSlaveCustom framedSlave;
    public static BlockTrimCustom framedTrim;
    public static BlockDrawersStandardCustom framedFullOne;
    public static BlockDrawersStandardCustom framedFullTwo;
    public static BlockDrawersStandardCustom framedFullFour;
    public static BlockDrawersStandardCustom framedHalfOne;
    public static BlockDrawersStandardCustom framedHalfTwo;
    public static BlockDrawersStandardCustom framedHalfFour;

    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry r = event.getRegistry();
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(3.0f, 5.0f).m_60918_(SoundType.f_56736_).m_60960_((_1, _2, _3) -> false).m_60924_((_1, _2, _3) -> false).m_60955_();
        framedCompactDrawer = new BlockCompDrawersCustom(properties);
        r.register((IForgeRegistryEntry)((Block)framedCompactDrawer.setRegistryName("framedcompactdrawers", "framed_compact_drawer")));
        framedDrawerController = new BlockControllerCustom(properties);
        r.register((IForgeRegistryEntry)((Block)framedDrawerController.setRegistryName("framedcompactdrawers", "framed_drawer_controller")));
        framedSlave = new BlockSlaveCustom(properties);
        r.register((IForgeRegistryEntry)((Block)framedSlave.setRegistryName("framedcompactdrawers", "framed_slave")));
        framedTrim = new BlockTrimCustom(properties);
        r.register((IForgeRegistryEntry)((Block)framedTrim.setRegistryName("framedcompactdrawers", "framed_trim")));
        framedFullOne = new BlockDrawersStandardCustom(1, false, properties);
        r.register((IForgeRegistryEntry)((Block)framedFullOne.setRegistryName("framedcompactdrawers", "framed_full_one")));
        framedFullTwo = new BlockDrawersStandardCustom(2, false, properties);
        r.register((IForgeRegistryEntry)((Block)framedFullTwo.setRegistryName("framedcompactdrawers", "framed_full_two")));
        framedFullFour = new BlockDrawersStandardCustom(4, false, properties);
        r.register((IForgeRegistryEntry)((Block)framedFullFour.setRegistryName("framedcompactdrawers", "framed_full_four")));
        framedHalfOne = new BlockDrawersStandardCustom(1, true, properties);
        r.register((IForgeRegistryEntry)((Block)framedHalfOne.setRegistryName("framedcompactdrawers", "framed_half_one")));
        framedHalfTwo = new BlockDrawersStandardCustom(2, true, properties);
        r.register((IForgeRegistryEntry)((Block)framedHalfTwo.setRegistryName("framedcompactdrawers", "framed_half_two")));
        framedHalfFour = new BlockDrawersStandardCustom(4, true, properties);
        r.register((IForgeRegistryEntry)((Block)framedHalfFour.setRegistryName("framedcompactdrawers", "framed_half_four")));
    }

    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        Item.Properties properties = new Item.Properties().m_41491_(FramedCompactDrawers.CREATIVE_TAB);
        r.register((IForgeRegistryEntry)((Item)new ItemDrawersCustom((Block)framedCompactDrawer, properties).setRegistryName(Objects.requireNonNull(framedCompactDrawer.getRegistryName()))));
        r.register((IForgeRegistryEntry)((Item)new ItemOtherCustom((Block)framedDrawerController, properties).setRegistryName(Objects.requireNonNull(framedDrawerController.getRegistryName()))));
        r.register((IForgeRegistryEntry)((Item)new ItemOtherCustom((Block)framedSlave, properties).setRegistryName(Objects.requireNonNull(framedSlave.getRegistryName()))));
        r.register((IForgeRegistryEntry)((Item)new ItemOtherCustom((Block)framedTrim, properties).setRegistryName(Objects.requireNonNull(framedTrim.getRegistryName()))));
        r.register((IForgeRegistryEntry)((Item)new ItemDrawersCustom((Block)framedFullOne, properties).setRegistryName(Objects.requireNonNull(framedFullOne.getRegistryName()))));
        r.register((IForgeRegistryEntry)((Item)new ItemDrawersCustom((Block)framedFullTwo, properties).setRegistryName(Objects.requireNonNull(framedFullTwo.getRegistryName()))));
        r.register((IForgeRegistryEntry)((Item)new ItemDrawersCustom((Block)framedFullFour, properties).setRegistryName(Objects.requireNonNull(framedFullFour.getRegistryName()))));
        r.register((IForgeRegistryEntry)((Item)new ItemDrawersCustom((Block)framedHalfOne, properties).setRegistryName(Objects.requireNonNull(framedHalfOne.getRegistryName()))));
        r.register((IForgeRegistryEntry)((Item)new ItemDrawersCustom((Block)framedHalfTwo, properties).setRegistryName(Objects.requireNonNull(framedHalfTwo.getRegistryName()))));
        r.register((IForgeRegistryEntry)((Item)new ItemDrawersCustom((Block)framedHalfFour, properties).setRegistryName(Objects.requireNonNull(framedHalfFour.getRegistryName()))));
    }

    public static void setRenderLayers() {
        Predicate<RenderType> crf = RenderHelper::canRenderFrameable;
        for (Block block : new Block[]{framedCompactDrawer, framedDrawerController, framedSlave, framedTrim, framedFullOne, framedFullTwo, framedFullFour, framedHalfOne, framedHalfTwo, framedHalfFour}) {
            ItemBlockRenderTypes.setRenderLayer((Block)block, crf);
        }
        framedCompactDrawer.setGeometryData();
        for (BlockDrawersStandardCustom blockDrawersStandardCustom : new BlockDrawersStandardCustom[]{framedFullOne, framedFullTwo, framedFullFour, framedHalfOne, framedHalfTwo, framedHalfFour}) {
            blockDrawersStandardCustom.setGeometryData();
        }
    }

    public static void fill(NonNullList<ItemStack> items) {
        for (Block block : new Block[]{framedCompactDrawer, framedDrawerController, framedSlave, framedTrim, framedFullOne, framedFullTwo, framedFullFour, framedHalfOne, framedHalfTwo, framedHalfFour}) {
            items.add((Object)new ItemStack((ItemLike)block));
        }
    }

    public static class Tile {
        public static BlockEntityType<TileCompDrawersCustom.Slot3> fractionalDrawers3;
        public static BlockEntityType<TileControllerCustom> controllerCustom;
        public static BlockEntityType<TileSlaveCustom> slaveCustom;
        public static BlockEntityType<TileTrimCustom> trimCustom;
        public static BlockEntityType<TileDrawersStandardCustom.Slot1> standardDrawers1;
        public static BlockEntityType<TileDrawersStandardCustom.Slot2> standardDrawers2;
        public static BlockEntityType<TileDrawersStandardCustom.Slot4> standardDrawers4;

        @SubscribeEvent
        public void registerTiles(RegistryEvent.Register<BlockEntityType<?>> evt) {
            IForgeRegistry r = evt.getRegistry();
            fractionalDrawers3 = this.registerTile(r, TileCompDrawersCustom.Slot3::new, new Block[]{framedCompactDrawer});
            controllerCustom = this.registerTile(r, TileControllerCustom::new, new Block[]{framedDrawerController});
            slaveCustom = this.registerTile(r, TileSlaveCustom::new, new Block[]{framedSlave});
            trimCustom = this.registerTile(r, TileTrimCustom::new, new Block[]{framedTrim});
            standardDrawers1 = this.registerTile(r, TileDrawersStandardCustom.Slot1::new, new Block[]{framedFullOne, framedHalfOne});
            standardDrawers2 = this.registerTile(r, TileDrawersStandardCustom.Slot2::new, new Block[]{framedFullTwo, framedHalfTwo});
            standardDrawers4 = this.registerTile(r, TileDrawersStandardCustom.Slot4::new, new Block[]{framedFullFour, framedHalfFour});
        }

        private <T extends BlockEntity> BlockEntityType<T> registerTile(IForgeRegistry<BlockEntityType<?>> registry, BlockEntityType.BlockEntitySupplier<T> supplier, Block ... blocks) {
            BlockEntityType type = BlockEntityType.Builder.m_155273_(supplier, (Block[])blocks).m_58966_(null);
            type.setRegistryName(Objects.requireNonNull(blocks[0].getRegistryName()));
            registry.register((IForgeRegistryEntry)type);
            return type;
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void registerTERs(EntityRenderersEvent.RegisterRenderers evt) {
            for (BlockEntityType drawer : ImmutableList.of(fractionalDrawers3, standardDrawers1, standardDrawers2, standardDrawers4)) {
                evt.registerBlockEntityRenderer(drawer, TileEntityDrawersRenderer::new);
            }
        }
    }
}

