/*
 * Decompiled with CFR 0.152.
 */
package eutros.framedcompactdrawers.render.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FrameableModel
implements IModelGeometry<FrameableModel> {
    public static final Logger LOGGER = LogManager.getLogger();
    public Multimap<MaterialSide, FramingCandidate> materials;
    public List<ResourceLocation> inherits = Collections.emptyList();

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.materials.values().stream().map(FramingCandidate::getRaw).map(arg_0 -> ((IModelConfiguration)owner).resolveTexture(arg_0)).collect(Collectors.toList());
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        ResourceLocation parentLoc;
        BakedModel parent = null;
        UnbakedModel ownerModel = owner.getOwnerModel();
        if (ownerModel instanceof BlockModel && (parentLoc = ((BlockModel)ownerModel).getParentLocation()) != null) {
            parent = bakery.bake(parentLoc, modelTransform, spriteGetter);
        }
        HashMultimap bakedSides = this.materials.entries().stream().collect(Collector.of(HashMultimap::create, (map, entry) -> map.put((Object)((MaterialSide)((Object)((Object)entry.getKey()))), (Object)((FramingCandidate)entry.getValue()).baked(owner, modelTransform, modelLocation)), (first, second) -> {
            first.putAll((Multimap)second);
            return first;
        }, Collector.Characteristics.UNORDERED));
        for (ResourceLocation rl : this.inherits) {
            BakedModel baked = bakery.bake(rl, modelTransform, spriteGetter);
            if (baked instanceof Baked) {
                for (Map.Entry entry2 : ((Baked)baked).bakedSides.entries()) {
                    bakedSides.put((Object)((MaterialSide)((Object)entry2.getKey())), (Object)((FramingCandidate.Baked)entry2.getValue()));
                }
                continue;
            }
            LOGGER.warn("Inherited model must be a frameable model! Got: " + (Serializable)(baked == null ? "null" : baked.getClass()));
        }
        return new Baked(parent, (Multimap<MaterialSide, FramingCandidate.Baked>)bakedSides);
    }

    private static class Baked
    implements IDynamicBakedModel {
        final Multimap<MaterialSide, FramingCandidate.Baked> bakedSides;
        @Nullable
        private final BakedModel parent;
        private final ItemOverrides overrides;

        public Baked(final @Nullable BakedModel parent, final Multimap<MaterialSide, FramingCandidate.Baked> bakedSides) {
            this.bakedSides = bakedSides;
            this.parent = parent;
            this.overrides = new ItemOverrides(){

                @Nonnull
                @ParametersAreNonnullByDefault
                public BakedModel m_173464_(BakedModel model, final ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int idkMan) {
                    return new Baked(parent, bakedSides){

                        @Override
                        @Nonnull
                        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
                            if (stack.m_41782_()) {
                                CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
                                ModelDataMap.Builder builder = new ModelDataMap.Builder();
                                for (MaterialSide material : MaterialSide.values()) {
                                    String key = material.getKey();
                                    if (key == null || !tag.m_128441_(key)) continue;
                                    builder.withInitial(material.property, (Object)ItemStack.m_41712_((CompoundTag)tag.m_128469_(key)));
                                }
                                extraData = builder.build();
                            }
                            return super.getQuads(state, side, rand, extraData);
                        }

                        @Override
                        @Nonnull
                        public ItemOverrides m_7343_() {
                            return ItemOverrides.f_111734_;
                        }
                    };
                }
            };
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            RenderType layer = MinecraftForgeClient.getRenderType();
            for (MaterialSide material : MaterialSide.values()) {
                if (layer != null && material.type != layer) continue;
                for (FramingCandidate.Baked baked : this.bakedSides.get((Object)material)) {
                    if (baked.getEnclosing().face.f_111354_ != side || !baked.getEnclosing().condition.test(extraData)) continue;
                    quads.add(baked.getQuad(this.resolve(extraData, material)));
                }
            }
            return quads;
        }

        private ItemStack resolve(IModelData data, MaterialSide material) {
            if (material == MaterialSide.OVERLAY) {
                return null;
            }
            ItemStack stack = (ItemStack)data.getData(material.property);
            if (material != MaterialSide.SIDE && (stack == null || stack.m_41619_())) {
                return this.resolve(data, MaterialSide.SIDE);
            }
            return stack;
        }

        public boolean m_7541_() {
            return this.parent != null && this.parent.m_7541_();
        }

        public boolean m_7539_() {
            return this.parent != null && this.parent.m_7539_();
        }

        public boolean m_7547_() {
            return this.parent != null && this.parent.m_7547_();
        }

        public boolean m_7521_() {
            return false;
        }

        @Nonnull
        public TextureAtlasSprite m_6160_() {
            return this.bakedSides.get((Object)MaterialSide.SIDE).stream().findFirst().map(mat -> mat.rawMaterial.m_119204_()).orElseGet(() -> this.parent == null ? (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(MissingTextureAtlasSprite.m_118071_()) : this.parent.getParticleIcon((IModelData)EmptyModelData.INSTANCE));
        }

        @Nonnull
        public ItemOverrides m_7343_() {
            return this.overrides;
        }

        public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack mat) {
            if (this.parent != null) {
                this.parent.handlePerspective(cameraTransformType, mat);
            }
            return this;
        }
    }

    public static enum MaterialSide {
        SIDE(RenderType.m_110463_()),
        FRONT(RenderType.m_110463_()),
        TRIM(RenderType.m_110463_()),
        OVERLAY(RenderType.m_110466_());

        public final ModelProperty<ItemStack> property = new ModelProperty();
        private final RenderType type;

        private MaterialSide(RenderType type) {
            this.type = type;
        }

        @Nullable
        public String getKey() {
            if (this != OVERLAY) {
                return "Mat" + this.name().charAt(0);
            }
            return null;
        }
    }

    public static class FramingCandidate {
        public static final FaceBakery FACE_BAKERY = new FaceBakery();
        public Vector3f start;
        public Vector3f end;
        public Direction direction;
        public BlockElementFace face;
        public Condition condition = Condition.ALWAYS;

        public String getRaw() {
            return this.face.f_111356_;
        }

        public Baked baked(IModelConfiguration owner, ModelState transform, ResourceLocation modelLocation) {
            return new Baked(owner, transform, modelLocation);
        }

        public static enum Condition implements Predicate<IModelData>
        {
            LOCKED(data -> {
                IDrawerAttributes attr = (IDrawerAttributes)data.getData(TileEntityDrawers.ATTRIBUTES);
                return attr != null && (attr.isItemLocked(LockAttribute.LOCK_EMPTY) || attr.isItemLocked(LockAttribute.LOCK_POPULATED));
            }),
            ALWAYS(data -> true);

            private final Predicate<IModelData> predicate;

            private Condition(Predicate<IModelData> predicate) {
                this.predicate = predicate;
            }

            @Override
            public boolean test(IModelData data) {
                return this.predicate.test(data);
            }
        }

        public class Baked {
            private final Function<TextureAtlasSprite, BakedQuad> quadSupplier;
            private final Cache<TextureAtlasSprite, BakedQuad> quadCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build();
            public Material rawMaterial;

            public FramingCandidate getEnclosing() {
                return FramingCandidate.this;
            }

            private Baked(IModelConfiguration owner, ModelState transform, ResourceLocation modelLocation) {
                this.rawMaterial = owner.resolveTexture(FramingCandidate.this.face.f_111356_);
                FramingCandidate.this.face.f_111357_.m_111394_(this.getFaceUvs(FramingCandidate.this.direction));
                this.quadSupplier = sprite -> FACE_BAKERY.m_111600_(FramingCandidate.this.start, FramingCandidate.this.end, FramingCandidate.this.face, sprite, FramingCandidate.this.direction, transform, null, true, modelLocation);
            }

            public float[] getFaceUvs(Direction facing) {
                float[] fArray;
                switch (facing) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case DOWN: {
                        float[] fArray2 = new float[4];
                        fArray2[0] = FramingCandidate.this.start.m_122239_();
                        fArray2[1] = 16.0f - FramingCandidate.this.end.m_122269_();
                        fArray2[2] = FramingCandidate.this.end.m_122239_();
                        fArray = fArray2;
                        fArray2[3] = 16.0f - FramingCandidate.this.start.m_122269_();
                        break;
                    }
                    case UP: {
                        float[] fArray3 = new float[4];
                        fArray3[0] = FramingCandidate.this.start.m_122239_();
                        fArray3[1] = FramingCandidate.this.start.m_122269_();
                        fArray3[2] = FramingCandidate.this.end.m_122239_();
                        fArray = fArray3;
                        fArray3[3] = FramingCandidate.this.end.m_122269_();
                        break;
                    }
                    case NORTH: {
                        float[] fArray4 = new float[4];
                        fArray4[0] = 16.0f - FramingCandidate.this.end.m_122239_();
                        fArray4[1] = 16.0f - FramingCandidate.this.end.m_122260_();
                        fArray4[2] = 16.0f - FramingCandidate.this.start.m_122239_();
                        fArray = fArray4;
                        fArray4[3] = 16.0f - FramingCandidate.this.start.m_122260_();
                        break;
                    }
                    case SOUTH: {
                        float[] fArray5 = new float[4];
                        fArray5[0] = FramingCandidate.this.start.m_122239_();
                        fArray5[1] = 16.0f - FramingCandidate.this.end.m_122260_();
                        fArray5[2] = FramingCandidate.this.end.m_122239_();
                        fArray = fArray5;
                        fArray5[3] = 16.0f - FramingCandidate.this.start.m_122260_();
                        break;
                    }
                    case WEST: {
                        float[] fArray6 = new float[4];
                        fArray6[0] = FramingCandidate.this.start.m_122269_();
                        fArray6[1] = 16.0f - FramingCandidate.this.end.m_122260_();
                        fArray6[2] = FramingCandidate.this.end.m_122269_();
                        fArray = fArray6;
                        fArray6[3] = 16.0f - FramingCandidate.this.start.m_122260_();
                        break;
                    }
                    case EAST: {
                        float[] fArray7 = new float[4];
                        fArray7[0] = 16.0f - FramingCandidate.this.end.m_122269_();
                        fArray7[1] = 16.0f - FramingCandidate.this.end.m_122260_();
                        fArray7[2] = 16.0f - FramingCandidate.this.start.m_122269_();
                        fArray = fArray7;
                        fArray7[3] = 16.0f - FramingCandidate.this.start.m_122260_();
                    }
                }
                return fArray;
            }

            public BakedQuad getQuad(ItemStack stack) {
                TextureAtlasSprite sprite = stack == null || stack.m_41619_() ? this.rawMaterial.m_119204_() : this.getSprite(stack);
                try {
                    return (BakedQuad)this.quadCache.get((Object)sprite, () -> this.quadSupplier.apply(sprite));
                }
                catch (ExecutionException e) {
                    return this.quadSupplier.apply(sprite);
                }
            }

            private TextureAtlasSprite getSprite(ItemStack stack) {
                return Minecraft.m_91087_().m_91291_().m_174264_(stack, null, null, 0).getParticleIcon((IModelData)EmptyModelData.INSTANCE);
            }
        }
    }
}

