/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class LadderBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic != null) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
            return this.getMimicQuads(state, side, rand, extraData, model);
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData, BakedModel model) {
        if (side != null) {
            return Collections.emptyList();
        }
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        int tex = (Integer)extraData.getData(FrameBlockTile.TEXTURE);
        if (mimic != null && state != null) {
            int overlayIndex;
            List<TextureAtlasSprite> textureList = TextureHelper.getTextureFromModel(model, extraData, rand);
            ArrayList<TextureAtlasSprite> designTextureList = new ArrayList<TextureAtlasSprite>();
            if (textureList.size() == 0) {
                if (Minecraft.m_91087_().f_91074_ != null) {
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent("message.blockcarpentry.block_not_available"), true);
                }
                return Collections.emptyList();
            }
            designTextureList.add(textureList.get(0));
            designTextureList.addAll(TextureHelper.getMetalTextures());
            if (textureList.size() <= tex) {
                extraData.setData(FrameBlockTile.TEXTURE, (Object)0);
                tex = 0;
            }
            TextureAtlasSprite texture = textureList.get(tex);
            int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
            int design = (Integer)extraData.getData(FrameBlockTile.DESIGN);
            int desTex = (Integer)extraData.getData(FrameBlockTile.DESIGN_TEXTURE);
            TextureAtlasSprite designTexture = (TextureAtlasSprite)designTextureList.get(desTex);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            if (design == 5) {
                switch ((Direction)state.m_61143_((Property)LadderBlock.f_54337_)) {
                    case WEST: {
                        return new ArrayList<BakedQuad>(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, texture, tintIndex));
                    }
                    case SOUTH: {
                        return new ArrayList<BakedQuad>(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.1875f, texture, tintIndex));
                    }
                    case NORTH: {
                        return new ArrayList<BakedQuad>(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.8125f, 1.0f, texture, tintIndex));
                    }
                    case EAST: {
                        return new ArrayList<BakedQuad>(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 1.0f, 0.0f, 1.0f, texture, tintIndex));
                    }
                }
            }
            if (design == 0 || design == 1 || design == 2) {
                switch ((Direction)state.m_61143_((Property)LadderBlock.f_54337_)) {
                    case WEST: {
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0625f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 1.0f, 0.9375f, 1.0f, texture, tintIndex));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.0f, 1.0f, 0.0f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.0f, 1.0f, 0.0f, 0.1875f, texture, tintIndex));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.0f, 1.0f, 0.8125f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.0f, 1.0f, 0.8125f, 1.0f, texture, tintIndex));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 1.0f, 0.0f, 0.0625f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 1.0f, 0.9375f, 1.0f, texture, tintIndex));
                    }
                }
            }
            if (design == 0 || design == 1) {
                switch ((Direction)state.m_61143_((Property)LadderBlock.f_54337_)) {
                    case WEST: {
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.125f, 0.1875f, 0.0625f, 0.9375f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.375f, 0.4375f, 0.0625f, 0.9375f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.625f, 0.6875f, 0.0625f, 0.9375f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.875f, 0.9375f, 0.0625f, 0.9375f, texture, tintIndex));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.125f, 0.1875f, 0.0f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.375f, 0.4375f, 0.0f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.625f, 0.6875f, 0.0f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.875f, 0.9375f, 0.0f, 0.1875f, texture, tintIndex));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.125f, 0.1875f, 0.8125f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.375f, 0.4375f, 0.8125f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.625f, 0.6875f, 0.8125f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.875f, 0.9375f, 0.8125f, 1.0f, texture, tintIndex));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.125f, 0.1875f, 0.0625f, 0.9375f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.375f, 0.4375f, 0.0625f, 0.9375f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.625f, 0.6875f, 0.0625f, 0.9375f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.875f, 0.9375f, 0.0625f, 0.9375f, texture, tintIndex));
                    }
                }
            }
            if (design == 1) {
                switch ((Direction)state.m_61143_((Property)LadderBlock.f_54337_)) {
                    case WEST: {
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 0.0625f, 0.0625f, 0.9375f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.25f, 0.3125f, 0.0625f, 0.9375f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.5f, 0.5625f, 0.0625f, 0.9375f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.75f, 0.8125f, 0.0625f, 0.9375f, texture, tintIndex));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0f, 0.0625f, 0.0f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.25f, 0.3125f, 0.0f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.5f, 0.5625f, 0.0f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.75f, 0.8125f, 0.0f, 0.1875f, texture, tintIndex));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0f, 0.0625f, 0.8125f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.25f, 0.3125f, 0.8125f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.5f, 0.5625f, 0.8125f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.75f, 0.8125f, 0.8125f, 1.0f, texture, tintIndex));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 0.0625f, 0.0625f, 0.9375f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.25f, 0.3125f, 0.0625f, 0.9375f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.5f, 0.5625f, 0.0625f, 0.9375f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.75f, 0.8125f, 0.0625f, 0.9375f, texture, tintIndex));
                    }
                }
            }
            if (design == 2) {
                switch ((Direction)state.m_61143_((Property)LadderBlock.f_54337_)) {
                    case WEST: {
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0625f, 0.1875f, 0.0625f, 0.9375f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.3125f, 0.4375f, 0.0625f, 0.9375f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.5625f, 0.6875f, 0.0625f, 0.9375f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.8125f, 0.9375f, 0.0625f, 0.9375f, texture, tintIndex));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0625f, 0.1875f, 0.0f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.4375f, 0.0f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.5625f, 0.6875f, 0.0f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.8125f, 0.9375f, 0.0f, 0.1875f, texture, tintIndex));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0625f, 0.1875f, 0.8125f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.4375f, 0.8125f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.5625f, 0.6875f, 0.8125f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.8125f, 0.9375f, 0.8125f, 1.0f, texture, tintIndex));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0625f, 0.1875f, 0.0625f, 0.9375f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.3125f, 0.4375f, 0.0625f, 0.9375f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.5625f, 0.6875f, 0.0625f, 0.9375f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.8125f, 0.9375f, 0.0625f, 0.9375f, texture, tintIndex));
                    }
                }
            }
            if (design == 3) {
                switch ((Direction)state.m_61143_((Property)LadderBlock.f_54337_)) {
                    case WEST: {
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0625f, 0.1875f, 0.0f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.3125f, 0.4375f, 0.0f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.5625f, 0.6875f, 0.0f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.8125f, 0.9375f, 0.0f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 1.0f, 0.125f, 0.25f, designTexture, -1));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 1.0f, 0.75f, 0.875f, designTexture, -1));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0625f, 0.1875f, 0.0f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.4375f, 0.0f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.5625f, 0.6875f, 0.0f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.8125f, 0.9375f, 0.0f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.25f, 0.0f, 1.0f, 0.0f, 0.125f, designTexture, -1));
                        quads.addAll(ModelHelper.createCuboid(0.75f, 0.875f, 0.0f, 1.0f, 0.0f, 0.125f, designTexture, -1));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0625f, 0.1875f, 0.8125f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.4375f, 0.8125f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.5625f, 0.6875f, 0.8125f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.8125f, 0.9375f, 0.8125f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.25f, 0.0f, 1.0f, 0.875f, 1.0f, designTexture, -1));
                        quads.addAll(ModelHelper.createCuboid(0.75f, 0.875f, 0.0f, 1.0f, 0.875f, 1.0f, designTexture, -1));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0625f, 0.1875f, 0.0f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.3125f, 0.4375f, 0.0f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.5625f, 0.6875f, 0.0f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.8125f, 0.9375f, 0.0f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 1.0f, 0.125f, 0.25f, designTexture, -1));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 1.0f, 0.75f, 0.875f, designTexture, -1));
                    }
                }
            }
            if (design == 4) {
                switch ((Direction)state.m_61143_((Property)LadderBlock.f_54337_)) {
                    case WEST: {
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 0.875f, 0.0625f, 0.1875f, 0.0f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 0.875f, 0.3125f, 0.4375f, 0.0f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 0.875f, 0.5625f, 0.6875f, 0.0f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 0.875f, 0.8125f, 0.9375f, 0.0f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 1.0f, 0.125f, 0.25f, designTexture, -1));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 1.0f, 0.75f, 0.875f, designTexture, -1));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0625f, 0.1875f, 0.125f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.4375f, 0.125f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.5625f, 0.6875f, 0.125f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.8125f, 0.9375f, 0.125f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.25f, 0.0f, 1.0f, 0.0f, 0.125f, designTexture, -1));
                        quads.addAll(ModelHelper.createCuboid(0.75f, 0.875f, 0.0f, 1.0f, 0.0f, 0.125f, designTexture, -1));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0625f, 0.1875f, 0.8125f, 0.875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.4375f, 0.8125f, 0.875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.5625f, 0.6875f, 0.8125f, 0.875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.8125f, 0.9375f, 0.8125f, 0.875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.25f, 0.0f, 1.0f, 0.875f, 1.0f, designTexture, -1));
                        quads.addAll(ModelHelper.createCuboid(0.75f, 0.875f, 0.0f, 1.0f, 0.875f, 1.0f, designTexture, -1));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.1875f, 0.0625f, 0.1875f, 0.0f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.1875f, 0.3125f, 0.4375f, 0.0f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.1875f, 0.5625f, 0.6875f, 0.0f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.1875f, 0.8125f, 0.9375f, 0.0f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 1.0f, 0.125f, 0.25f, designTexture, -1));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 1.0f, 0.75f, 0.875f, designTexture, -1));
                    }
                }
            }
            if ((overlayIndex = ((Integer)extraData.getData(FrameBlockTile.OVERLAY)).intValue()) != 0) {
                switch ((Direction)state.m_61143_((Property)LadderBlock.f_54337_)) {
                    case NORTH: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.8125f, 1.0f, overlayIndex));
                        break;
                    }
                    case WEST: {
                        quads.addAll(ModelHelper.createOverlay(0.8125f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 0.1875f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.1875f, overlayIndex));
                    }
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.getTexture();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

