/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.initialinventory;

import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.natives.entity.type.player.ExpandPlayer;
import com.blamejared.initialinventory.items.RespawnItem;
import com.blamejared.initialinventory.items.StartingItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;

public class InitialInventoryCommon {
    public static final Map<String, List<StartingItem>> STARTING_ITEMS = new HashMap<String, List<StartingItem>>();
    public static final List<RespawnItem> RESPAWN_ITEMS = new ArrayList<RespawnItem>();

    public static void playerRespawn(Player player) {
        RESPAWN_ITEMS.forEach(item -> {
            IItemStack givenIStack = item.onGiven().apply(item.stack().copy(), player).copy();
            if (item.index() <= -1) {
                ExpandPlayer.give((Player)player, (IItemStack)givenIStack, (int)-1);
            } else if (!player.m_150109_().m_8020_(item.index()).m_41619_()) {
                ExpandPlayer.give((Player)player, (IItemStack)givenIStack, (int)-1);
            } else {
                ExpandPlayer.give((Player)player, (IItemStack)givenIStack, (int)item.index());
            }
        });
    }

    public static void playerLogin(Player player, Supplier<CompoundTag> persistentData, Consumer<CompoundTag> setPersistentData) {
        CompoundTag tag = persistentData.get();
        STARTING_ITEMS.forEach((key, inventoryItems) -> {
            String nbtKey = "initialinventory_given_" + key;
            if (tag.m_128471_(nbtKey)) {
                return;
            }
            inventoryItems.forEach(item -> {
                IItemStack givenIStack = item.onGiven().apply(item.stack().copy(), player).copy();
                if (item.index() <= -1) {
                    ExpandPlayer.give((Player)player, (IItemStack)givenIStack, (int)-1);
                } else if (!player.m_150109_().m_8020_(item.index()).m_41619_()) {
                    ExpandPlayer.give((Player)player, (IItemStack)givenIStack, (int)-1);
                } else {
                    ExpandPlayer.give((Player)player, (IItemStack)givenIStack, (int)item.index());
                }
            });
            tag.m_128379_(nbtKey, true);
        });
        setPersistentData.accept(tag);
    }
}

