/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.enercell.block.entity;

import com.codetaylor.mc.enercell.container.EnercellContainer;
import com.codetaylor.mc.enercell.init.ModBlocks;
import com.codetaylor.mc.enercell.init.ModConfigs;
import com.codetaylor.mc.enercell.init.ModNetwork;
import com.codetaylor.mc.enercell.network.ClientboundEnercellChargeModeMessage;
import com.codetaylor.mc.enercell.network.ClientboundEnercellEnergyUpdateMessage;
import com.codetaylor.mc.enercell.network.ClientboundEnercellRollingAverageUpdateMessage;
import com.codetaylor.mc.enercell.util.RollingAverage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnercellBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final int UPDATE_TICK_THRESHOLD = 10;
    private static final int ROLLING_AVERAGE_SAMPLE_SIZE = 4;
    private final AccessibleEnergyStorage energyStorage;
    private final EnergyItemStackHandler stackHandler;
    private final RollingAverage averageCharge = new RollingAverage(4);
    private final RollingAverage averageInput = new RollingAverage(4);
    private final RollingAverage averageOutput = new RollingAverage(4);
    private ChargeMode chargeMode;
    private int previousUpdateEnergyTotal;
    private int updateTickCounter;
    private double clientAverageCharge;
    private double clientAverageInput;
    private double clientAverageOutput;
    public static final String TAG_STACK_HANDLER = "StackHandler";
    public static final String TAG_ENERGY_STORAGE = "EnergyStorage";
    public static final String TAG_CHARGE_MODE = "ChargeMode";

    public EnercellBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(ModBlocks.ENERCELL_BLOCK_ENTITY, blockPos, blockState);
        this.energyStorage = new AccessibleEnergyStorage(this, ModConfigs.ENERCELL.getEnergyCapacity(), this.averageInput, this.averageOutput);
        this.stackHandler = new EnergyItemStackHandler(this, 9);
        this.chargeMode = ChargeMode.Charge;
    }

    public ItemStackHandler getStackHandler() {
        return this.stackHandler;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setClientAverages(double clientAverageCharge, double clientAverageInput, double clientAverageOutput) {
        this.clientAverageCharge = clientAverageCharge;
        this.clientAverageInput = clientAverageInput;
        this.clientAverageOutput = clientAverageOutput;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setClientEnergy(int energy) {
        this.energyStorage.setEnergy(energy);
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getClientAverageCharge() {
        return this.clientAverageCharge;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getClientAverageInput() {
        return this.clientAverageInput;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getClientAverageOutput() {
        return this.clientAverageOutput;
    }

    public ChargeMode getChargeMode() {
        return this.chargeMode;
    }

    public void setChargeMode(ChargeMode chargeMode) {
        this.chargeMode = chargeMode;
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            ModNetwork.CHANNEL.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), 64.0, this.f_58857_.m_46472_())), (Object)new ClientboundEnercellChargeModeMessage(this.m_58899_(), this.chargeMode));
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this.energyStorage).cast();
        }
        return super.getCapability(capability, side);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, EnercellBlockEntity enercellBlockEntity) {
        ++enercellBlockEntity.updateTickCounter;
        if (enercellBlockEntity.updateTickCounter < 10) {
            return;
        }
        enercellBlockEntity.updateTickCounter = 0;
        int totalEnergyTransferred = 0;
        if (enercellBlockEntity.chargeMode == ChargeMode.Charge && enercellBlockEntity.energyStorage.getEnergyStored() > 0) {
            totalEnergyTransferred = EnercellBlockEntity.chargeItems(enercellBlockEntity);
        } else if (enercellBlockEntity.chargeMode == ChargeMode.Drain && enercellBlockEntity.energyStorage.getEnergyStored() < enercellBlockEntity.energyStorage.getMaxEnergyStored()) {
            totalEnergyTransferred = EnercellBlockEntity.drainItems(enercellBlockEntity);
        }
        if (enercellBlockEntity.previousUpdateEnergyTotal != enercellBlockEntity.energyStorage.getEnergyStored()) {
            enercellBlockEntity.previousUpdateEnergyTotal = enercellBlockEntity.energyStorage.getEnergyStored();
            ModNetwork.CHANNEL.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 64.0, level.m_46472_())), (Object)new ClientboundEnercellEnergyUpdateMessage(blockPos, enercellBlockEntity.energyStorage.getEnergyStored()));
        }
        double averageScalar = 2.0;
        enercellBlockEntity.averageCharge.addValue(totalEnergyTransferred);
        enercellBlockEntity.energyStorage.updateAverages();
        ModNetwork.CHANNEL.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 64.0, level.m_46472_())), (Object)new ClientboundEnercellRollingAverageUpdateMessage(blockPos, enercellBlockEntity.averageCharge.getAverage() * averageScalar, enercellBlockEntity.averageInput.getAverage() * averageScalar, enercellBlockEntity.averageOutput.getAverage() * averageScalar));
    }

    private static int chargeItems(EnercellBlockEntity enercellBlockEntity) {
        ArrayList itemEnergyStorageList = new ArrayList(9);
        for (int i = 0; i < enercellBlockEntity.stackHandler.getSlots(); ++i) {
            ItemStack stackInSlot = enercellBlockEntity.stackHandler.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            stackInSlot.getCapability(CapabilityEnergy.ENERGY).filter(es -> es.canReceive() && es.getEnergyStored() < es.getMaxEnergyStored()).ifPresent(itemEnergyStorageList::add);
        }
        if (itemEnergyStorageList.isEmpty()) {
            return 0;
        }
        float maxEnergyPerUpdate = 0.5f * ModConfigs.ENERCELL.getEnergyItemTransferPerSecond();
        float maxEnergyPerItem = Math.min((float)enercellBlockEntity.energyStorage.getEnergyStored(), maxEnergyPerUpdate) / (float)itemEnergyStorageList.size();
        int totalEnergyTransferred = 0;
        for (IEnergyStorage itemEnergyStorage : itemEnergyStorageList) {
            int maxReceive = (int)Mth.m_14036_((float)maxEnergyPerItem, (float)1.0f, (float)enercellBlockEntity.energyStorage.getEnergyStored());
            int energyTransferred = itemEnergyStorage.receiveEnergy(maxReceive, false);
            enercellBlockEntity.energyStorage.extractEnergyForItemCharging(energyTransferred, false);
            totalEnergyTransferred += energyTransferred;
            if (enercellBlockEntity.energyStorage.getEnergyStored() != 0) continue;
            break;
        }
        return totalEnergyTransferred;
    }

    private static int drainItems(EnercellBlockEntity enercellBlockEntity) {
        ArrayList itemEnergyStorageList = new ArrayList(9);
        for (int i = 0; i < enercellBlockEntity.stackHandler.getSlots(); ++i) {
            ItemStack stackInSlot = enercellBlockEntity.stackHandler.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            stackInSlot.getCapability(CapabilityEnergy.ENERGY).filter(es -> es.canExtract() && es.getEnergyStored() > 0).ifPresent(itemEnergyStorageList::add);
        }
        if (itemEnergyStorageList.isEmpty()) {
            return 0;
        }
        float maxEnergyPerUpdate = 0.5f * ModConfigs.ENERCELL.getEnergyItemTransferPerSecond();
        float maxEnergyPerItem = maxEnergyPerUpdate / (float)itemEnergyStorageList.size();
        int maxAllowedDrain = enercellBlockEntity.energyStorage.getMaxEnergyStored() - enercellBlockEntity.energyStorage.getEnergyStored();
        int totalEnergyTransferred = 0;
        for (IEnergyStorage itemEnergyStorage : itemEnergyStorageList) {
            int maxDrain = (int)Math.min(maxEnergyPerItem, (float)Math.min(maxAllowedDrain, itemEnergyStorage.getEnergyStored()));
            int energyTransferred = itemEnergyStorage.extractEnergy(maxDrain, false);
            enercellBlockEntity.energyStorage.receiveEnergyForItemCharging(energyTransferred, false);
            totalEnergyTransferred += energyTransferred;
            if (enercellBlockEntity.energyStorage.getEnergyStored() != enercellBlockEntity.energyStorage.getMaxEnergyStored()) continue;
            break;
        }
        return totalEnergyTransferred;
    }

    @Nonnull
    public Component m_5446_() {
        return new TranslatableComponent("block.enercell.enercell");
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return new EnercellContainer(id, this.m_58904_(), this.m_58899_(), inventory);
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(TAG_STACK_HANDLER, (Tag)this.stackHandler.serializeNBT());
        tag.m_128365_(TAG_ENERGY_STORAGE, this.energyStorage.serializeNBT());
        tag.m_128344_(TAG_CHARGE_MODE, this.chargeMode.serializationId);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.stackHandler.deserializeNBT(tag.m_128469_(TAG_STACK_HANDLER));
        this.energyStorage.deserializeNBT(tag.m_128423_(TAG_ENERGY_STORAGE));
        this.chargeMode = ChargeMode.from(tag.m_128445_(TAG_CHARGE_MODE));
    }

    public static class AccessibleEnergyStorage
    extends EnergyStorage {
        private final EnercellBlockEntity enercellBlockEntity;
        private final RollingAverage averageInput;
        private final RollingAverage averageOutput;
        private int input;
        private int output;

        public AccessibleEnergyStorage(EnercellBlockEntity enercellBlockEntity, int capacity, RollingAverage averageInput, RollingAverage averageOutput) {
            super(capacity);
            this.enercellBlockEntity = enercellBlockEntity;
            this.averageInput = averageInput;
            this.averageOutput = averageOutput;
        }

        public void updateAverages() {
            this.averageInput.addValue(this.input);
            this.averageOutput.addValue(this.output);
            this.input = 0;
            this.output = 0;
        }

        public void setEnergy(int energy) {
            this.energy = Math.min(this.capacity, energy);
        }

        public void extractEnergyForItemCharging(int maxExtract, boolean simulate) {
            super.extractEnergy(maxExtract, simulate);
            this.enercellBlockEntity.m_6596_();
        }

        public void receiveEnergyForItemCharging(int maxReceive, boolean simulate) {
            super.receiveEnergy(maxReceive, simulate);
            this.enercellBlockEntity.m_6596_();
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int result = super.extractEnergy(maxExtract, simulate);
            if (!simulate) {
                this.output += result;
                this.enercellBlockEntity.m_6596_();
            }
            return result;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int result = super.receiveEnergy(maxReceive, simulate);
            if (!simulate) {
                this.input += result;
                this.enercellBlockEntity.m_6596_();
            }
            return result;
        }
    }

    public static class EnergyItemStackHandler
    extends ItemStackHandler {
        private final EnercellBlockEntity enercellBlockEntity;

        public EnergyItemStackHandler(EnercellBlockEntity enercellBlockEntity, int size) {
            super(size);
            this.enercellBlockEntity = enercellBlockEntity;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            this.enercellBlockEntity.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack itemStack) {
            return itemStack.getCapability(CapabilityEnergy.ENERGY).isPresent();
        }
    }

    public static enum ChargeMode {
        Charge(0),
        Drain(1);

        private static final Map<Byte, ChargeMode> MAP;
        private final byte serializationId;

        private ChargeMode(byte serializationId) {
            this.serializationId = serializationId;
        }

        public byte getSerializationId() {
            return this.serializationId;
        }

        public static ChargeMode from(byte serializationId) {
            return MAP.get(serializationId);
        }

        static {
            MAP = Arrays.stream(ChargeMode.values()).collect(Collectors.toMap(ChargeMode::getSerializationId, mode -> mode));
        }
    }
}

