/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.enercell.container;

import com.codetaylor.mc.enercell.block.entity.EnercellBlockEntity;
import com.codetaylor.mc.enercell.init.ModContainers;
import com.codetaylor.mc.enercell.init.ModSlotIcons;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class EnercellContainer
extends AbstractContainerMenu {
    private static final Pair<ResourceLocation, ResourceLocation>[] EMPTY_SLOT_TEXTURES = new Pair[]{Pair.of((Object)InventoryMenu.f_39692_, (Object)ModSlotIcons.ENERGY_SLOT_NO_ITEM)};
    private final BlockPos blockPos;
    private final EnercellBlockEntity blockEntity;

    public EnercellContainer(int id, Level level, BlockPos blockPos, Inventory inventory) {
        super(ModContainers.ENERCELL, id);
        this.blockPos = blockPos;
        this.blockEntity = (EnercellBlockEntity)level.m_7702_(blockPos);
        this.initSlots((IItemHandler)this.blockEntity.getStackHandler(), inventory);
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public int getEnergy() {
        return this.blockEntity.getEnergyStorage().getEnergyStored();
    }

    public int getEnergyCapacity() {
        return this.blockEntity.getEnergyStorage().getMaxEnergyStored();
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getClientAverageCharge() {
        return this.blockEntity.getClientAverageCharge();
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getClientAverageInput() {
        return this.blockEntity.getClientAverageInput();
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getClientAverageOutput() {
        return this.blockEntity.getClientAverageOutput();
    }

    public EnercellBlockEntity.ChargeMode getChargeMode() {
        return this.blockEntity.getChargeMode();
    }

    public void cycleChargeMode() {
        this.blockEntity.setChargeMode(EnercellBlockEntity.ChargeMode.values()[(this.blockEntity.getChargeMode().ordinal() + 1) % EnercellBlockEntity.ChargeMode.values().length]);
    }

    public boolean m_6875_(Player player) {
        Level world = player.m_20193_();
        if (!(world.m_7702_(this.blockPos) instanceof EnercellBlockEntity)) {
            return false;
        }
        return player.m_20275_((double)this.blockPos.m_123341_() + 0.5, (double)this.blockPos.m_123342_() + 0.5, (double)this.blockPos.m_123343_() + 0.5) <= 64.0;
    }

    private void initSlots(IItemHandler stackHandler, Inventory playerInventory) {
        int row;
        for (row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)playerInventory, column + row * 9 + 9, 8 + column * 18, 84 + row * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new Slot((Container)playerInventory, hotbarSlot, 8 + hotbarSlot * 18, 142));
        }
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.m_38897_((Slot)new ChargeSlot(stackHandler, col + row * 3, 106 + 18 * col, 17 + row * 18, EMPTY_SLOT_TEXTURES[0]));
            }
        }
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && this.m_38903_(slotStack, 36, 45, false)) {
                return itemstack;
            }
            if (index >= 0 && index < 27 ? !this.m_38903_(slotStack, 27, 36, false) : (index >= 27 && index < 36 ? !this.m_38903_(slotStack, 0, 27, false) : !this.m_38903_(slotStack, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return itemstack;
    }

    private static class ChargeSlot
    extends SlotItemHandler {
        private final Pair<ResourceLocation, ResourceLocation> emptyIconLocation;

        public ChargeSlot(IItemHandler itemHandler, int pIndex, int pX, int pY, Pair<ResourceLocation, ResourceLocation> emptyIconLocation) {
            super(itemHandler, pIndex, pX, pY);
            this.emptyIconLocation = emptyIconLocation;
        }

        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
            return this.emptyIconLocation;
        }
    }
}

