/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.enercell.network;

import com.codetaylor.mc.enercell.block.entity.EnercellBlockEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundEnercellEnergyUpdateMessage {
    public final BlockPos blockPos;
    public final int energy;

    public ClientboundEnercellEnergyUpdateMessage(BlockPos blockPos, int energy) {
        this.blockPos = blockPos;
        this.energy = energy;
    }

    public static void encode(ClientboundEnercellEnergyUpdateMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.blockPos);
        buffer.writeInt(message.energy);
    }

    public static ClientboundEnercellEnergyUpdateMessage decode(FriendlyByteBuf buffer) {
        BlockPos blockPos = buffer.m_130135_();
        int energy = buffer.readInt();
        return new ClientboundEnercellEnergyUpdateMessage(blockPos, energy);
    }

    public static void handle(ClientboundEnercellEnergyUpdateMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ == null) {
                return;
            }
            BlockEntity blockEntity = minecraft.f_91073_.m_7702_(message.blockPos);
            if (!(blockEntity instanceof EnercellBlockEntity)) {
                return;
            }
            EnercellBlockEntity enercellBlockEntity = (EnercellBlockEntity)blockEntity;
            enercellBlockEntity.setClientEnergy(message.energy);
        });
        context.setPacketHandled(true);
    }
}

