/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.element.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.minimap.element.render.MinimapElementReader;
import xaero.common.minimap.element.render.MinimapElementRenderProvider;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;

public abstract class MinimapElementRendererHandler {
    private final List<MinimapElementRenderer<?, ?>> renderers;
    protected final int location;

    protected MinimapElementRendererHandler(List<MinimapElementRenderer<?, ?>> renderers, int location) {
        this.renderers = renderers;
        this.location = location;
    }

    public void add(MinimapElementRenderer<?, ?> renderer) {
        this.renderers.add(renderer);
    }

    protected void render(PoseStack matrixStack, Entity renderEntity, Player player, double renderX, double renderY, double renderZ, double ps, double pc, double zoom, boolean cave, float partialTicks, RenderTarget framebuffer, IXaeroMinimap modMain, MinimapRendererHelper helper, MultiBufferSource.BufferSource renderTypeBuffers, Font font, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        int elementIndex = 0;
        Collections.sort(this.renderers);
        this.beforeRender(matrixStack);
        int indexLimit = this.getIndexLimit();
        for (int i = 0; i < this.renderers.size(); ++i) {
            MinimapElementRenderer<?, ?> renderer = this.renderers.get(i);
            elementIndex = this.renderForRenderer(renderer, matrixStack, renderEntity, player, renderX, renderY, renderZ, ps, pc, zoom, cave, partialTicks, elementIndex, framebuffer, modMain, helper, renderTypeBuffers, font, multiTextureRenderTypeRenderers, indexLimit);
            matrixStack.m_85837_(0.0, 0.0, this.getElementIndexDepth(elementIndex, indexLimit));
            if ((indexLimit -= elementIndex) >= 0) continue;
            indexLimit = 0;
        }
        this.afterRender(matrixStack);
    }

    protected <E, RRC, RR extends MinimapElementRenderer<E, RRC>> int renderForRenderer(RR renderer, PoseStack matrixStack, Entity renderEntity, Player player, double renderX, double renderY, double renderZ, double ps, double pc, double zoom, boolean cave, float partialTicks, int elementIndex, RenderTarget framebuffer, IXaeroMinimap modMain, MinimapRendererHelper helper, MultiBufferSource.BufferSource renderTypeBuffers, Font font, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers, int indexLimit) {
        MinimapElementReader elementReader = renderer.elementReader;
        MinimapElementRenderProvider provider = renderer.provider;
        Object context = renderer.context;
        int location = this.location;
        if (!renderer.shouldRender(location)) {
            return elementIndex;
        }
        renderer.preRender(location, renderEntity, player, renderX, renderY, renderZ, modMain, renderTypeBuffers, multiTextureRenderTypeRenderers);
        provider.begin(location, context);
        while (provider.hasNext(location, context)) {
            double optionalDepth;
            Object element = provider.setupContextAndGetNext(location, context);
            if (element == null || elementReader.isHidden(element, context) || !this.transformAndRenderForRenderer(renderer, matrixStack, renderTypeBuffers, font, framebuffer, helper, renderEntity, player, renderX, renderY, renderZ, ps, pc, zoom, cave, partialTicks, elementIndex, optionalDepth = this.getElementIndexDepth(elementIndex, indexLimit), element, elementReader, context)) continue;
            ++elementIndex;
        }
        provider.end(location, context);
        renderer.postRender(location, renderEntity, player, renderX, renderY, renderZ, modMain, renderTypeBuffers, multiTextureRenderTypeRenderers);
        return elementIndex;
    }

    protected double getElementIndexDepth(int elementIndex, int indexLimit) {
        return (double)(elementIndex >= indexLimit ? indexLimit : elementIndex) * 0.1;
    }

    protected abstract int getIndexLimit();

    protected abstract <E, RRC, RR extends MinimapElementRenderer<E, RRC>> boolean transformAndRenderForRenderer(RR var1, PoseStack var2, MultiBufferSource.BufferSource var3, Font var4, RenderTarget var5, MinimapRendererHelper var6, Entity var7, Player var8, double var9, double var11, double var13, double var15, double var17, double var19, boolean var21, float var22, int var23, double var24, E var26, MinimapElementReader<E, RRC> var27, RRC var28);

    protected abstract void beforeRender(PoseStack var1);

    protected abstract void afterRender(PoseStack var1);

    public static abstract class Builder {
        protected Builder() {
        }

        protected Builder setDefault() {
            return this;
        }

        public MinimapElementRendererHandler build() {
            return this.buildInternally(new ArrayList());
        }

        protected abstract MinimapElementRendererHandler buildInternally(List<MinimapElementRenderer<?, ?>> var1);
    }
}

