/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.mods.pac;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import xaero.common.IXaeroMinimap;
import xaero.common.minimap.element.render.over.MinimapElementOverMapRendererHandler;
import xaero.common.minimap.highlight.HighlighterRegistry;
import xaero.common.mods.pac.ClientClaimChangeListener;
import xaero.common.mods.pac.gui.element.PlayerDynamicInfoMinimapElement;
import xaero.common.mods.pac.gui.element.PlayerDynamicInfoRenderer;
import xaero.common.mods.pac.highlight.ClaimsHighlighter;
import xaero.pac.client.api.OpenPACClientAPI;
import xaero.pac.client.claims.api.IClientClaimsManagerAPI;
import xaero.pac.client.claims.api.IClientDimensionClaimsManagerAPI;
import xaero.pac.client.claims.api.IClientRegionClaimsAPI;
import xaero.pac.client.claims.player.api.IClientPlayerClaimInfoAPI;
import xaero.pac.client.parties.party.api.IClientPartyAPI;
import xaero.pac.client.parties.party.api.IClientPartyMemberDynamicInfoSyncableStorageAPI;
import xaero.pac.client.parties.party.api.IClientPartyStorageAPI;
import xaero.pac.client.player.config.api.IPlayerConfigClientStorageAPI;
import xaero.pac.client.player.config.api.IPlayerConfigClientStorageManagerAPI;
import xaero.pac.client.player.config.api.IPlayerConfigStringableOptionClientStorageAPI;
import xaero.pac.common.claims.player.api.IPlayerChunkClaimAPI;
import xaero.pac.common.claims.player.api.IPlayerClaimPosListAPI;
import xaero.pac.common.claims.player.api.IPlayerDimensionClaimsAPI;
import xaero.pac.common.claims.tracker.api.IClaimsManagerListenerAPI;
import xaero.pac.common.parties.party.ally.api.IPartyAllyAPI;
import xaero.pac.common.parties.party.api.IPartyMemberDynamicInfoSyncableAPI;
import xaero.pac.common.parties.party.api.IPartyPlayerInfoAPI;
import xaero.pac.common.parties.party.member.api.IPartyMemberAPI;

public class SupportOpenPartiesAndClaims {
    private final IXaeroMinimap modMain;
    private final OpenPACClientAPI api;
    private final IClientClaimsManagerAPI<IClientPlayerClaimInfoAPI<IPlayerDimensionClaimsAPI<IPlayerClaimPosListAPI>>, IClientDimensionClaimsManagerAPI<IClientRegionClaimsAPI>> claimsManager;
    private final IClientPartyStorageAPI<IClientPartyAPI<IPartyMemberAPI, IPartyPlayerInfoAPI, IPartyAllyAPI>, IClientPartyMemberDynamicInfoSyncableStorageAPI<IPartyMemberDynamicInfoSyncableAPI>> partyStorage;
    private final IPlayerConfigClientStorageManagerAPI<IPlayerConfigClientStorageAPI<IPlayerConfigStringableOptionClientStorageAPI<?>>> playerConfigs;
    private Map<UUID, PlayerDynamicInfoMinimapElement> playerDynamicInfoMinimapElements;

    public SupportOpenPartiesAndClaims(IXaeroMinimap modMain) {
        this.modMain = modMain;
        this.api = OpenPACClientAPI.get();
        this.claimsManager = this.api.getClaimsManager();
        this.partyStorage = this.api.getClientPartyStorage();
        this.playerConfigs = this.api.getPlayerConfigClientStorageManager();
    }

    public void registerListeners() {
        this.claimsManager.getTracker().register((IClaimsManagerListenerAPI)new ClientClaimChangeListener());
    }

    public IPlayerChunkClaimAPI claimAt(ResourceLocation dimension, int chunkX, int chunkZ) {
        return this.claimsManager.get(dimension, chunkX, chunkZ);
    }

    public void onMapRender(Minecraft mc, PoseStack matrixStack, int scaledMouseX, int scaledMouseY, float partialTicks, ResourceLocation dimension, int highlightChunkX, int highlightChunkZ) {
    }

    public boolean isFromParty(UUID playerId) {
        IClientPartyAPI party = this.partyStorage.getParty();
        if (party == null) {
            return false;
        }
        return this.partyStorage.getParty().getMemberInfo(playerId) != null;
    }

    public void registerHighlighters(HighlighterRegistry highlightRegistry) {
        highlightRegistry.register(new ClaimsHighlighter(this.modMain, this.claimsManager));
    }

    public void updatePlayerDynamicInfoMapElements(Minecraft mc) {
        if (this.playerDynamicInfoMinimapElements == null) {
            this.playerDynamicInfoMinimapElements = new HashMap<UUID, PlayerDynamicInfoMinimapElement>();
        }
        HashMap<UUID, PlayerDynamicInfoMinimapElement> updatedMap = new HashMap<UUID, PlayerDynamicInfoMinimapElement>();
        Stream playerStream = this.api.getClientPartyStorage().getPartyMemberDynamicInfoSyncableStorage().getAllStream();
        boolean hasNewPlayer = false;
        Iterator syncableIterator = playerStream.iterator();
        while (syncableIterator.hasNext()) {
            IPartyMemberDynamicInfoSyncableAPI syncable = (IPartyMemberDynamicInfoSyncableAPI)syncableIterator.next();
            PlayerDynamicInfoMinimapElement element = this.playerDynamicInfoMinimapElements.get(syncable.getPlayerId());
            if (element == null || element.getSyncable() != syncable) {
                element = new PlayerDynamicInfoMinimapElement(syncable);
                hasNewPlayer = true;
            }
            updatedMap.put(element.getPlayerId(), element);
        }
        if (hasNewPlayer || updatedMap.size() != this.playerDynamicInfoMinimapElements.size()) {
            this.playerDynamicInfoMinimapElements = updatedMap;
        }
    }

    public boolean playerExists(UUID id) {
        return this.playerDynamicInfoMinimapElements.containsKey(id);
    }

    public Map<UUID, PlayerDynamicInfoMinimapElement> getPlayerDynamicInfoMinimapElements() {
        return this.playerDynamicInfoMinimapElements;
    }

    public void prePotentialMinimapRender() {
        this.updatePlayerDynamicInfoMapElements(Minecraft.m_91087_());
    }

    public void registerOverMapRenderers(MinimapElementOverMapRendererHandler overMapRendererHandler) {
        overMapRendererHandler.add(PlayerDynamicInfoRenderer.Builder.begin().setPac(this).build());
    }

    public void resetRenderedOnRadarFlags() {
        for (PlayerDynamicInfoMinimapElement dynamicInfo : this.playerDynamicInfoMinimapElements.values()) {
            dynamicInfo.setRenderedOnRadar(false);
        }
    }

    public IXaeroMinimap getModMain() {
        return this.modMain;
    }

    public void confirmPlayerRadarRender(Player p) {
        this.playerDynamicInfoMinimapElements.get(p.m_142081_()).setRenderedOnRadar(true);
    }
}

