/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityShoebill;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.phys.Vec3;

public class ShoebillAIFish
extends Goal {
    private EntityShoebill bird;
    private BlockPos waterPos = null;
    private BlockPos targetPos = null;
    private int executionChance = 0;
    private Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private int idleTime = 0;
    private int navigateTime = 0;

    public ShoebillAIFish(EntityShoebill bird) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.bird = bird;
    }

    public void m_8041_() {
        this.targetPos = null;
        this.waterPos = null;
        this.idleTime = 0;
        this.navigateTime = 0;
        this.bird.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (this.targetPos != null && this.waterPos != null) {
            double dist = this.bird.m_20238_(Vec3.m_82512_((Vec3i)this.waterPos));
            if (dist <= 1.0) {
                this.navigateTime = 0;
                double d0 = (double)this.waterPos.m_123341_() + 0.5 - this.bird.m_20185_();
                double d2 = (double)this.waterPos.m_123343_() + 0.5 - this.bird.m_20189_();
                float yaw = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.bird.m_146922_(yaw);
                this.bird.f_20885_ = yaw;
                this.bird.f_20883_ = yaw;
                this.bird.m_21573_().m_26573_();
                ++this.idleTime;
                if (this.idleTime > 25) {
                    this.bird.setAnimation(EntityShoebill.ANIMATION_FISH);
                }
                if (this.idleTime > 45 && this.bird.getAnimation() == EntityShoebill.ANIMATION_FISH) {
                    this.bird.m_5496_(SoundEvents.f_11917_, 0.7f, 0.5f + this.bird.m_21187_().nextFloat());
                    this.bird.resetFishingCooldown();
                    this.spawnFishingLoot();
                    this.m_8041_();
                }
            } else {
                ++this.navigateTime;
                this.bird.m_21573_().m_26519_((double)this.waterPos.m_123341_(), (double)this.waterPos.m_123342_(), (double)this.waterPos.m_123343_(), 1.2);
            }
            if (this.navigateTime > 3600) {
                this.m_8041_();
            }
        }
    }

    public boolean m_8045_() {
        return this.targetPos != null && this.bird.fishingCooldown == 0 && this.bird.revengeCooldown == 0 && !this.bird.isFlying();
    }

    public void spawnFishingLoot() {
        double luck = 0.0 + (double)((float)this.bird.luckLevel * 0.5f);
        LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.bird.f_19853_);
        lootcontext$builder.m_78963_((float)luck);
        LootContextParamSet.Builder lootparameterset$builder = new LootContextParamSet.Builder();
        List result = this.bird.f_19853_.m_142572_().m_129898_().m_79217_(BuiltInLootTables.f_78720_).m_79129_(lootcontext$builder.m_78975_(lootparameterset$builder.m_81405_()));
        for (ItemStack itemstack : result) {
            ItemEntity item = new ItemEntity(this.bird.f_19853_, this.bird.m_20185_() + 0.5, this.bird.m_20186_(), this.bird.m_20189_(), itemstack);
            if (this.bird.f_19853_.f_46443_) continue;
            this.bird.f_19853_.m_7967_((Entity)item);
        }
    }

    public boolean m_8036_() {
        if (!this.bird.isFlying() && this.bird.fishingCooldown == 0 && this.bird.m_21187_().nextInt(30) == 0) {
            if (this.bird.m_20069_()) {
                this.targetPos = this.waterPos = this.bird.m_142538_();
                return true;
            }
            this.waterPos = this.generateTarget();
            if (this.waterPos != null) {
                this.targetPos = this.getLandPos(this.waterPos);
                return this.targetPos != null;
            }
        }
        return false;
    }

    public BlockPos generateTarget() {
        BlockPos blockpos = null;
        Random random = new Random();
        int range = 32;
        for (int i = 0; i < 15; ++i) {
            BlockPos blockpos1 = this.bird.m_142538_().m_142082_(random.nextInt(range) - range / 2, 3, random.nextInt(range) - range / 2);
            while (this.bird.f_19853_.m_46859_(blockpos1) && blockpos1.m_123342_() > 1) {
                blockpos1 = blockpos1.m_7495_();
            }
            if (!this.isConnectedToLand(blockpos1)) continue;
            blockpos = blockpos1;
        }
        return blockpos;
    }

    public boolean isConnectedToLand(BlockPos pos) {
        if (this.bird.f_19853_.m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
            for (Direction dir : this.HORIZONTALS) {
                BlockPos offsetPos = pos.m_142300_(dir);
                if (!this.bird.f_19853_.m_6425_(offsetPos).m_76178_() || !this.bird.f_19853_.m_6425_(offsetPos.m_7494_()).m_76178_()) continue;
                return true;
            }
        }
        return false;
    }

    public BlockPos getLandPos(BlockPos pos) {
        if (this.bird.f_19853_.m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
            for (Direction dir : this.HORIZONTALS) {
                BlockPos offsetPos = pos.m_142300_(dir);
                if (!this.bird.f_19853_.m_6425_(offsetPos).m_76178_() || !this.bird.f_19853_.m_6425_(offsetPos.m_7494_()).m_76178_()) continue;
                return offsetPos;
            }
        }
        return null;
    }
}

