/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tileentity;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ICommand;
import mcjty.lib.blockcommands.IRunnable;
import mcjty.lib.blockcommands.IRunnableWithList;
import mcjty.lib.blockcommands.IRunnableWithListResult;
import mcjty.lib.blockcommands.IRunnableWithResult;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.AutomationFilterItemHander;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.multipart.PartSlot;
import mcjty.lib.network.PacketRequestDataFromServer;
import mcjty.lib.tileentity.AnnotationHolder;
import mcjty.lib.tileentity.AnnotationTools;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.ValueHolder;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.RedstoneMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.tuple.Pair;

public class GenericTileEntity
extends BlockEntity {
    public static final Key<Integer> VALUE_RSMODE = new Key<Integer>("rsmode", Type.INTEGER);
    private String ownerName = "";
    private UUID ownerUUID = null;
    private int securityChannel = -1;
    protected RedstoneMode rsMode = RedstoneMode.REDSTONE_IGNORED;
    protected int powerLevel = 0;
    private BiFunction<Capability, Direction, LazyOptional> capSetup;
    private final List<LazyOptional> lazyOptsToClean = new ArrayList<LazyOptional>();
    @ServerCommand
    public static final Command<?> COMMAND_SYNC_BINDING = Command.create("generic.syncBinding", (te, playerEntity, params) -> te.syncBinding(params));
    @ServerCommand
    public static final Command<?> CMD_RSMODE = Command.create("mcjtylib.setRsMode", (te, playerEntity, params) -> te.setRSMode(RedstoneMode.values()[params.get(ImageChoiceLabel.PARAM_CHOICE_IDX)]));

    public GenericTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.capSetup = (cap, dir) -> {
            List<Pair<Field, Cap>> list = this.getAnnotationHolder().capabilityList;
            this.capSetup = this.generateCapTests(list, 0);
            return this.capSetup.apply((Capability)cap, (Direction)dir);
        };
        this.getAnnotationHolder();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
    }

    private BiFunction<Capability, Direction, LazyOptional> generateCapTests(List<Pair<Field, Cap>> caps, int index) {
        if (index >= caps.size()) {
            return (x$0, x$1) -> super.getCapability(x$0, x$1);
        }
        try {
            Cap annotation = (Cap)caps.get(index).getRight();
            Object instance = FieldUtils.readField((Field)((Field)caps.get(index).getLeft()), (Object)((Object)this), (boolean)true);
            LazyOptional lazy = instance instanceof LazyOptional ? (LazyOptional)instance : (annotation.type() == CapType.ITEMS_AUTOMATION ? LazyOptional.of(() -> new AutomationFilterItemHander((GenericItemHandler)instance)) : LazyOptional.of(() -> instance));
            this.lazyOptsToClean.add(lazy);
            BiFunction<Capability, Direction, LazyOptional> tail = this.generateCapTests(caps, index + 1);
            Capability desiredCapability = annotation.type().getCapability();
            return (cap, dir) -> {
                if (cap == desiredCapability) {
                    return lazy;
                }
                return (LazyOptional)tail.apply((Capability)cap, (Direction)dir);
            };
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return this.capSetup.apply(cap, side);
    }

    public void markDirtyClient() {
        this.m_6596_();
        if (this.m_58904_() != null) {
            BlockState state = this.m_58904_().m_8055_(this.m_58899_());
            this.m_58904_().m_7260_(this.m_58899_(), state, state, 3);
        }
    }

    public void markDirtyQuick() {
        if (this.m_58904_() != null) {
            this.m_58904_().m_151543_(this.f_58858_);
        }
    }

    public Map<String, ValueHolder<?, ?>> getValueMap() {
        AnnotationHolder holder = this.getAnnotationHolder();
        return holder.valueMap;
    }

    public void onBlockPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
    }

    public void onReplaced(Level world, BlockPos pos, BlockState state, BlockState newstate) {
    }

    public void onPartAdded(PartSlot slot, BlockState state, BlockEntity multipartTile) {
    }

    public InteractionResult onBlockActivated(BlockState state, Player player, InteractionHand hand, BlockHitResult result) {
        return InteractionResult.PASS;
    }

    protected boolean needsRedstoneMode() {
        return false;
    }

    public void checkRedstone(Level world, BlockPos pos) {
        int powered = world.m_46755_(pos);
        this.setPowerInput(powered);
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            this.powerLevel = powered;
            this.m_6596_();
        }
    }

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public RedstoneMode getRSMode() {
        return this.rsMode;
    }

    public void setRSMode(RedstoneMode redstoneMode) {
        this.rsMode = redstoneMode;
        this.markDirtyClient();
    }

    public void setRSModeInt(int i) {
        this.setRSMode(RedstoneMode.values()[i]);
    }

    public int getRSModeInt() {
        return this.rsMode.ordinal();
    }

    public boolean isMachineEnabled() {
        if (this.rsMode != RedstoneMode.REDSTONE_IGNORED) {
            boolean rs;
            boolean bl = rs = this.powerLevel > 0;
            if (this.rsMode == RedstoneMode.REDSTONE_OFFREQUIRED && rs) {
                return false;
            }
            if (this.rsMode == RedstoneMode.REDSTONE_ONREQUIRED && !rs) {
                return false;
            }
        }
        return true;
    }

    public void onSlotChanged(int index, ItemStack stack) {
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbtTag = new CompoundTag();
        this.saveClientDataToNBT(nbtTag);
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, entity -> nbtTag);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet) {
        this.loadClientDataFromNBT(packet.m_131708_());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canPlayerAccess(Player player) {
        if (this.m_58901_()) return false;
        Vec3 vec3 = new Vec3((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_());
        Vec3 vec32 = new Vec3(0.5, 0.5, 0.5);
        if (!(player.m_20238_(vec3.m_82549_(vec32)) <= 64.0)) return false;
        return true;
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        this.saveClientDataToNBT(updateTag);
        return updateTag;
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
    }

    public void m_142466_(CompoundTag tagCompound) {
        this.loadCaps(tagCompound);
        this.loadInfo(tagCompound);
    }

    protected void loadCaps(CompoundTag tagCompound) {
        if (tagCompound.m_128441_("Info")) {
            CompoundTag infoTag = tagCompound.m_128469_("Info");
            this.getCapability(CapabilityInfusable.INFUSABLE_CAPABILITY).ifPresent(h -> h.setInfused(infoTag.m_128451_("infused")));
        }
        this.loadItemHandlerCap(tagCompound);
        this.loadEnergyCap(tagCompound);
    }

    protected void loadItemHandlerCap(CompoundTag tagCompound) {
        this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(h -> h instanceof INBTSerializable).map(h -> (INBTSerializable)h).ifPresent(h -> {
            if (tagCompound.m_128441_("McItems")) {
                h.deserializeNBT((Tag)tagCompound.m_128437_("McItems", 10));
            } else {
                h.deserializeNBT((Tag)tagCompound.m_128437_("Items", 10));
            }
        });
    }

    protected void loadEnergyCap(CompoundTag tagCompound) {
        this.getCapability(CapabilityEnergy.ENERGY).filter(h -> h instanceof INBTSerializable).map(h -> (INBTSerializable)h).ifPresent(h -> {
            if (tagCompound.m_128441_("Energy")) {
                h.deserializeNBT(tagCompound.m_128423_("Energy"));
            }
        });
    }

    protected void loadInfo(CompoundTag tagCompound) {
        if (tagCompound.m_128441_("Info")) {
            CompoundTag infoTag = tagCompound.m_128469_("Info");
            if (infoTag.m_128441_("powered")) {
                this.powerLevel = infoTag.m_128445_("powered");
            }
            this.loadRSMode(infoTag);
            if (infoTag.m_128441_("owner")) {
                this.ownerName = infoTag.m_128461_("owner");
            }
            if (infoTag.m_128403_("ownerId")) {
                this.ownerUUID = infoTag.m_128342_("ownerId");
            }
            if (infoTag.m_128441_("secChannel")) {
                this.securityChannel = infoTag.m_128451_("secChannel");
            }
        }
    }

    protected void loadRSMode(CompoundTag infoTag) {
        if (this.needsRedstoneMode() && infoTag.m_128441_("rsMode")) {
            byte m = infoTag.m_128445_("rsMode");
            this.rsMode = RedstoneMode.values()[m];
        }
    }

    protected CompoundTag getOrCreateInfo(CompoundTag tagCompound) {
        if (tagCompound.m_128441_("Info")) {
            return tagCompound.m_128469_("Info");
        }
        CompoundTag data = new CompoundTag();
        tagCompound.m_128365_("Info", (Tag)data);
        return data;
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        this.saveCaps(tagCompound);
        this.saveInfo(tagCompound);
    }

    protected void saveCaps(CompoundTag tagCompound) {
        CompoundTag infoTag = this.getOrCreateInfo(tagCompound);
        this.getCapability(CapabilityInfusable.INFUSABLE_CAPABILITY).ifPresent(h -> infoTag.m_128405_("infused", h.getInfused()));
        this.saveItemHandlerCap(tagCompound);
        this.saveEnergyCap(tagCompound);
    }

    protected void saveItemHandlerCap(CompoundTag tagCompound) {
        this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(h -> h instanceof INBTSerializable).map(h -> (INBTSerializable)h).ifPresent(h -> tagCompound.m_128365_("Items", h.serializeNBT()));
    }

    protected void saveEnergyCap(CompoundTag tagCompound) {
        this.getCapability(CapabilityEnergy.ENERGY).filter(h -> h instanceof INBTSerializable).map(h -> (INBTSerializable)h).ifPresent(h -> tagCompound.m_128365_("Energy", h.serializeNBT()));
    }

    protected void saveInfo(CompoundTag tagCompound) {
        CompoundTag infoTag = this.getOrCreateInfo(tagCompound);
        infoTag.m_128344_("powered", (byte)this.powerLevel);
        this.saveRSMode(infoTag);
        infoTag.m_128359_("owner", this.ownerName);
        if (this.ownerUUID != null) {
            infoTag.m_128362_("ownerId", this.ownerUUID);
        }
        if (this.securityChannel != -1) {
            infoTag.m_128405_("secChannel", this.securityChannel);
        }
    }

    protected void saveRSMode(CompoundTag infoTag) {
        if (this.needsRedstoneMode()) {
            infoTag.m_128344_("rsMode", (byte)this.rsMode.ordinal());
        }
    }

    public boolean setOwner(Player player) {
        if (!((Boolean)GeneralConfig.manageOwnership.get()).booleanValue()) {
            return false;
        }
        if (this.ownerUUID != null) {
            return false;
        }
        this.ownerUUID = player.m_36316_().getId();
        this.ownerName = player.m_7755_().getString();
        this.markDirtyClient();
        return true;
    }

    public void clearOwner() {
        if (!((Boolean)GeneralConfig.manageOwnership.get()).booleanValue()) {
            return;
        }
        this.ownerUUID = null;
        this.ownerName = "";
        this.securityChannel = -1;
        this.markDirtyClient();
    }

    public void setSecurityChannel(int id) {
        this.securityChannel = id;
        this.markDirtyClient();
    }

    public int getSecurityChannel() {
        return this.securityChannel;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public boolean checkAccess(Player player) {
        return false;
    }

    public int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return -1;
    }

    public void getDrops(NonNullList<ItemStack> drops, BlockGetter world, BlockPos pos, BlockState metadata, int fortune) {
    }

    public void rotateBlock(Rotation axis) {
    }

    public boolean wrenchUse(Level world, BlockPos pos, Direction side, Player player) {
        return false;
    }

    private <T extends GenericTileEntity, V> BiConsumer<T, V> findSetter(Key<V> key) {
        for (Map.Entry<String, ValueHolder<?, ?>> entry : this.getValueMap().entrySet()) {
            ValueHolder<?, ?> value = entry.getValue();
            if (!key.name().equals(value.key().name())) continue;
            return value.setter();
        }
        return null;
    }

    public ResourceKey<Level> getDimension() {
        return this.f_58857_.m_46472_();
    }

    public void requestDataFromServer(SimpleChannel channel, ICommand command, @Nonnull TypedMap params) {
        channel.sendToServer((Object)new PacketRequestDataFromServer(this.getDimension(), this.f_58858_, command.name(), params, false));
    }

    public boolean executeClientCommand(String command, Player player, @Nonnull TypedMap params) {
        AnnotationHolder holder = this.getAnnotationHolder();
        IRunnable<?> clientCommand = holder.clientCommands.get(command);
        if (clientCommand != null) {
            clientCommand.run(this, player, params);
            return true;
        }
        return false;
    }

    public IRunnable<?> findServerCommand(String command) {
        AnnotationHolder holder = this.getAnnotationHolder();
        return holder.serverCommands.get(command);
    }

    public boolean executeServerCommand(String command, Player player, @Nonnull TypedMap params) {
        AnnotationHolder holder = this.getAnnotationHolder();
        IRunnable<?> serverCommand = holder.serverCommands.get(command);
        if (serverCommand != null) {
            serverCommand.run(this, player, params);
            return true;
        }
        return false;
    }

    public <T> List<T> executeServerCommandList(String command, Player player, @Nonnull TypedMap params, @Nonnull Class<T> type) {
        AnnotationHolder holder = this.getAnnotationHolder();
        IRunnableWithListResult<?, ?> cmd = holder.serverCommandsWithListResult.get(command);
        if (cmd != null) {
            return cmd.run(this, player, params);
        }
        return Collections.emptyList();
    }

    public <T> boolean handleListFromServer(String command, Player player, @Nonnull TypedMap params, @Nonnull List<T> list) {
        AnnotationHolder holder = this.getAnnotationHolder();
        IRunnableWithList<?, ?> cmd = holder.clientCommandsWithList.get(command);
        if (cmd != null) {
            cmd.run(this, player, params, list);
            return true;
        }
        return false;
    }

    @Nullable
    public TypedMap executeServerCommandWR(String command, Player player, @Nonnull TypedMap params) {
        AnnotationHolder holder = this.getAnnotationHolder();
        IRunnableWithResult<?> serverCommand = holder.serverCommandsWithResult.get(command);
        if (serverCommand != null) {
            return serverCommand.run(this, player, params);
        }
        return null;
    }

    private AnnotationHolder getAnnotationHolder() {
        AnnotationHolder holder = AnnotationHolder.annotations.get(this.m_58903_());
        if (holder == null) {
            holder = AnnotationTools.createAnnotationHolder(this.m_58903_(), ((Object)((Object)this)).getClass());
        }
        return holder;
    }

    private <T> void syncBindingHelper(TypedMap params, Key<T> bkey) {
        T o = params.get(bkey);
        this.findSetter(bkey).accept(this, (GenericTileEntity)((Object)o));
    }

    private void syncBinding(TypedMap params) {
        for (Key<?> key : params.getKeys()) {
            this.syncBindingHelper(params, key);
        }
        this.markDirtyClient();
    }
}

