/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.server.sync;

import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.event.SlotModifiersUpdatedEvent;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;

public class SPacketSyncOperation {
    private int entityId;
    private String curioId;
    private int operation;
    private int amount;
    private boolean visible;
    private boolean cosmetic;

    public SPacketSyncOperation(int entityId, String curioId, Operation operation) {
        this(entityId, curioId, operation, 0);
    }

    public SPacketSyncOperation(int entityId, String curioId, Operation operation, int amount) {
        this(entityId, curioId, operation, amount, true, false);
    }

    public SPacketSyncOperation(int entityId, String curioId, Operation operation, int amount, boolean visible, boolean cosmetic) {
        this.entityId = entityId;
        this.curioId = curioId;
        this.amount = amount;
        this.operation = operation.ordinal();
        this.visible = visible;
        this.cosmetic = cosmetic;
    }

    public static void encode(SPacketSyncOperation msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.m_130070_(msg.curioId);
        buf.writeInt(msg.operation);
        buf.writeInt(msg.amount);
        buf.writeBoolean(msg.visible);
        buf.writeBoolean(msg.cosmetic);
    }

    public static SPacketSyncOperation decode(FriendlyByteBuf buf) {
        return new SPacketSyncOperation(buf.readInt(), buf.m_130136_(25), Operation.fromValue(buf.readInt()), buf.readInt(), buf.readBoolean(), buf.readBoolean());
    }

    public static void handle(SPacketSyncOperation msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world != null && (entity = world.m_6815_(msg.entityId)) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).ifPresent(handler -> {
                    Operation op = Operation.fromValue(msg.operation);
                    String id = msg.curioId;
                    int amount = msg.amount;
                    switch (op) {
                        case GROW: {
                            handler.growSlotType(id, amount);
                            break;
                        }
                        case SHRINK: {
                            handler.shrinkSlotType(id, amount);
                        }
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new SlotModifiersUpdatedEvent(livingEntity, Set.of(id)));
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (player.f_36096_ instanceof CuriosContainer) {
                            ((CuriosContainer)player.f_36096_).resetSlots();
                        }
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum Operation {
        SHRINK,
        GROW;


        public static Operation fromValue(int value) {
            try {
                return Operation.values()[value];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Unknown operation value: " + value);
            }
        }
    }
}

