/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import iskallia.ispawner.config.adapter.IdentifierAdapter;
import iskallia.ispawner.config.adapter.ItemAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public abstract class Config {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapterFactory(IdentifierAdapter.FACTORY).registerTypeAdapterFactory(ItemAdapter.FACTORY).excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();
    protected String root = "config/ispawner/";
    protected String extension = ".json";

    public void generateConfig() {
        this.reset();
        try {
            this.writeConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getConfigFile() {
        return new File(this.root + this.getName() + this.extension);
    }

    public abstract String getName();

    public <T extends Config> T readConfig() {
        try {
            return (T)((Config)GSON.fromJson((Reader)new FileReader(this.getConfigFile()), this.getClass()));
        }
        catch (FileNotFoundException e) {
            this.generateConfig();
            return (T)this;
        }
    }

    protected abstract void reset();

    public void writeConfig() throws IOException {
        File dir = new File(this.root);
        if (!dir.exists() && !dir.mkdirs()) {
            return;
        }
        if (!this.getConfigFile().exists() && !this.getConfigFile().createNewFile()) {
            return;
        }
        FileWriter writer = new FileWriter(this.getConfigFile());
        GSON.toJson((Object)this, (Appendable)writer);
        writer.flush();
        writer.close();
    }
}

