/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.config;

import com.google.gson.annotations.Expose;
import iskallia.ispawner.config.Config;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.SpawnEggItem;

public class SpawnEggConfig
extends Config {
    @Expose
    public Map<ResourceLocation, EggColor> colors;

    @Override
    public String getName() {
        return "spawn_egg";
    }

    @Override
    protected void reset() {
        this.colors = new LinkedHashMap<ResourceLocation, EggColor>();
        for (EntityType type : Registry.f_122826_) {
            SpawnEggItem egg = SpawnEggItem.m_43213_((EntityType)type);
            if (egg == null) continue;
            this.colors.put(EntityType.m_20613_((EntityType)type), new EggColor(egg.m_43211_(0), egg.m_43211_(1)));
        }
    }

    public int getColor(EntityType<?> type, int tintIndex) {
        EggColor color = this.colors.get(EntityType.m_20613_(type));
        SpawnEggItem egg = SpawnEggItem.m_43213_(type);
        if (color != null) {
            return tintIndex == 0 ? color.primary : color.secondary;
        }
        if (egg != null) {
            return egg.m_43211_(tintIndex);
        }
        return tintIndex == 0 ? 0xFFFFFF : 0;
    }

    private static class EggColor {
        @Expose
        public int primary;
        @Expose
        public int secondary;

        public EggColor(int primary, int secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }
    }
}

