/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.init;

import dev.architectury.networking.NetworkChannel;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import iskallia.ispawner.ISpawner;
import iskallia.ispawner.init.ModRegistries;
import iskallia.ispawner.net.packet.ModPacket;
import iskallia.ispawner.net.packet.UpdateControllerC2SPacket;
import iskallia.ispawner.net.packet.UpdateRedstoneModeC2SPacket;
import iskallia.ispawner.net.packet.UpdateSettingsC2SPacket;
import iskallia.ispawner.net.packet.UpdateSettingsS2CPacket;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;

public class ModNetwork
extends ModRegistries {
    public static final NetworkChannel CHANNEL = NetworkChannel.create((ResourceLocation)ISpawner.id("network"));

    public static void register() {
        if (Platform.getEnvironment() == Env.CLIENT) {
            Client.register();
        } else {
            Server.register();
        }
    }

    public static Function<NetworkManager.PacketContext, ClientPacketListener> getClient() {
        return context -> Minecraft.m_91087_().m_91403_();
    }

    public static Function<NetworkManager.PacketContext, ServerGamePacketListenerImpl> getServer() {
        return context -> ((ServerPlayer)context.getPlayer()).f_8906_;
    }

    public static <R extends PacketListener, T extends ModPacket<R>> void register(Class<T> type, Function<FriendlyByteBuf, T> packetSupplier, Function<NetworkManager.PacketContext, R> contextMapper) {
        CHANNEL.register(type, Packet::m_5779_, packetSupplier, (packet, contextSupplier) -> {
            if (contextMapper != null) {
                packet.m_5797_((PacketListener)contextMapper.apply((NetworkManager.PacketContext)contextSupplier.get()));
            }
        });
    }

    public static class Client {
        public static final Function<NetworkManager.PacketContext, ClientPacketListener> CLIENT_PLAY = context -> Minecraft.m_91087_().m_91403_();
        public static final Function<NetworkManager.PacketContext, ServerGamePacketListenerImpl> SERVER_PLAY = context -> ((ServerPlayer)context.getPlayer()).f_8906_;

        public static void register() {
            ModNetwork.register(UpdateSettingsS2CPacket.class, UpdateSettingsS2CPacket::new, CLIENT_PLAY);
            ModNetwork.register(UpdateControllerC2SPacket.class, UpdateControllerC2SPacket::new, SERVER_PLAY);
            ModNetwork.register(UpdateSettingsC2SPacket.class, UpdateSettingsC2SPacket::new, SERVER_PLAY);
            ModNetwork.register(UpdateRedstoneModeC2SPacket.class, UpdateRedstoneModeC2SPacket::new, SERVER_PLAY);
        }
    }

    public static class Server {
        public static final Function<NetworkManager.PacketContext, ServerGamePacketListenerImpl> SERVER_PLAY = context -> ((ServerPlayer)context.getPlayer()).f_8906_;

        public static void register() {
            ModNetwork.register(UpdateSettingsS2CPacket.class, UpdateSettingsS2CPacket::new, null);
            ModNetwork.register(UpdateControllerC2SPacket.class, UpdateControllerC2SPacket::new, SERVER_PLAY);
            ModNetwork.register(UpdateSettingsC2SPacket.class, UpdateSettingsC2SPacket::new, SERVER_PLAY);
            ModNetwork.register(UpdateRedstoneModeC2SPacket.class, UpdateRedstoneModeC2SPacket::new, SERVER_PLAY);
        }
    }
}

