/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.init;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import iskallia.ispawner.block.entity.SpawnerBlockEntity;
import iskallia.ispawner.block.entity.SurvivalSpawnerBlockEntity;
import iskallia.ispawner.block.render.SpawnerBlockRenderer;
import iskallia.ispawner.init.ModBlocks;
import iskallia.ispawner.init.ModItems;
import iskallia.ispawner.init.ModRegistries;
import iskallia.ispawner.item.GenericSpawnEggItem;
import java.util.Map;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ModRenderers
extends ModRegistries {
    public static <T extends BlockEntity> BlockEntityRendererProvider<T> register(Map<BlockEntityType<?>, BlockEntityRendererProvider<?>> registry, BlockEntityType<? extends T> type, BlockEntityRendererProvider<T> renderer) {
        registry.put(type, renderer);
        return renderer;
    }

    public static void register(Map<Block, RenderType> registry, Block block, RenderType layer) {
        registry.put(block, layer);
    }

    public static class Colors {
        public static void register(ItemColors itemColors, BlockColors blockColors) {
            itemColors.m_92689_(GenericSpawnEggItem::getColor, new ItemLike[]{(ItemLike)ModItems.SPAWN_EGG.get()});
        }
    }

    public static class RenderLayers {
        public static void register(Map<Block, RenderType> registry, boolean fancyGraphicsOrBetter) {
            try {
                ModRenderers.register(registry, (Block)ModBlocks.SPAWNER.get(), RenderType.m_110463_());
                ModRenderers.register(registry, (Block)ModBlocks.SURVIVAL_SPAWNER.get(), RenderType.m_110463_());
            }
            catch (Exception e) {
                ClientLifecycleEvent.CLIENT_SETUP.register(minecraft -> {
                    ModRenderers.register(registry, (Block)ModBlocks.SPAWNER.get(), RenderType.m_110463_());
                    ModRenderers.register(registry, (Block)ModBlocks.SURVIVAL_SPAWNER.get(), RenderType.m_110463_());
                });
            }
        }
    }

    public static class BlockEntities
    extends ModRenderers {
        public static BlockEntityRendererProvider<SpawnerBlockEntity> SPAWNER;
        public static BlockEntityRendererProvider<SurvivalSpawnerBlockEntity> SURVIVAL_SPAWNER;

        public static void register(Map<BlockEntityType<?>, BlockEntityRendererProvider<?>> registry) {
            try {
                BlockEntities.register(registry, (BlockEntityType)ModBlocks.Entities.SPAWNER.get(), SpawnerBlockRenderer::new);
                BlockEntities.register(registry, (BlockEntityType)ModBlocks.Entities.SURVIVAL_SPAWNER.get(), SpawnerBlockRenderer::new);
            }
            catch (Exception e) {
                ClientLifecycleEvent.CLIENT_SETUP.register(minecraft -> {
                    SPAWNER = BlockEntities.register(registry, (BlockEntityType)ModBlocks.Entities.SPAWNER.get(), SpawnerBlockRenderer::new);
                    SURVIVAL_SPAWNER = BlockEntities.register(registry, (BlockEntityType)ModBlocks.Entities.SURVIVAL_SPAWNER.get(), SpawnerBlockRenderer::new);
                });
            }
        }
    }
}

