/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.item;

import iskallia.ispawner.init.ModConfigs;
import iskallia.ispawner.init.ModItems;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class GenericSpawnEggItem
extends Item {
    public GenericSpawnEggItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        EntityType<?> type;
        BlockEntity blockEntity;
        Level world = context.m_43725_();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockState state = world.m_8055_(pos);
        if (state.m_60713_(Blocks.f_50085_) && (blockEntity = world.m_7702_(pos)) instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity;
            type = GenericSpawnEggItem.getType(stack);
            if (type != null) {
                spawner.m_59801_().m_45462_(type);
                spawner.m_6596_();
                world.m_7260_(pos, state, state, 3);
                stack.m_41774_(1);
            }
            return InteractionResult.CONSUME;
        }
        BlockPos offsetPos = state.m_60812_((BlockGetter)world, pos).m_83281_() ? pos : pos.m_142300_(direction);
        type = GenericSpawnEggItem.getType(stack);
        if (type == null || type.m_20592_((ServerLevel)world, stack, context.m_43723_(), offsetPos, MobSpawnType.SPAWN_EGG, true, !Objects.equals(pos, offsetPos) && direction == Direction.UP) != null) {
            stack.m_41774_(1);
            world.m_142346_((Entity)context.m_43723_(), GameEvent.f_157810_, pos);
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.m_21120_(hand);
        BlockHitResult hitResult = SpawnEggItem.m_41435_((Level)world, (Player)user, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!(world instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        BlockPos pos = hitResult.m_82425_();
        if (!(world.m_8055_(pos).m_60734_() instanceof LiquidBlock)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (world.m_7966_(user, pos) && user.m_36204_(pos, hitResult.m_82434_(), stack)) {
            EntityType<?> type = GenericSpawnEggItem.getType(stack);
            if (type == null || type.m_20592_((ServerLevel)world, stack, user, pos, MobSpawnType.SPAWN_EGG, false, false) == null) {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            if (!user.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            user.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            world.m_151552_(GameEvent.f_157810_, (Entity)user);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public Component m_7626_(ItemStack stack) {
        EntityType<?> type = GenericSpawnEggItem.getType(stack);
        if (type != null) {
            return type.m_20676_().m_6879_().m_7220_((Component)new TextComponent(" ")).m_7220_(super.m_7626_(stack));
        }
        return super.m_7626_(stack);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> stacks) {
        if (!this.m_41389_(group)) {
            return;
        }
        for (EntityType type : Registry.f_122826_) {
            stacks.add((Object)GenericSpawnEggItem.of(type));
        }
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        return ModConfigs.SPAWN_EGG.getColor(GenericSpawnEggItem.getType(stack), tintIndex);
    }

    public static EntityType<?> getType(ItemStack stack) {
        ResourceLocation id = GenericSpawnEggItem.getTypeId(stack);
        return id == null ? null : (EntityType)EntityType.m_20632_((String)id.toString()).orElse(null);
    }

    public static ResourceLocation getTypeId(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            return null;
        }
        if ((nbt = nbt.m_128469_("EntityTag")).m_128425_("id", 8)) {
            return ResourceLocation.m_135820_((String)nbt.m_128461_("id"));
        }
        return null;
    }

    public static ItemStack of(EntityType<?> type) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.SPAWN_EGG.get());
        stack.m_41698_("EntityTag").m_128359_("id", EntityType.m_20613_(type).toString());
        return stack;
    }
}

