/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.item.nbt;

import iskallia.ispawner.nbt.INBTSerializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class ItemNBT
implements INBTSerializable<CompoundTag> {
    public static final List<StackOverride> OVERRIDES = new ArrayList<StackOverride>();
    protected final CompoundTag delegate;
    protected final String tagKey;

    public ItemNBT(ItemStack stack, String tagKey) {
        this(stack.m_41783_(), tagKey);
    }

    public ItemNBT(CompoundTag delegate, String tagKey) {
        this.delegate = delegate;
        this.tagKey = tagKey;
        this.readFromNBT(this.getDelegate() != null ? this.getDelegate().m_128469_(this.getTagKey()) : new CompoundTag());
    }

    public CompoundTag getDelegate() {
        return this.delegate;
    }

    public String getTagKey() {
        return this.tagKey;
    }

    protected void update() {
        if (this.delegate == null) {
            return;
        }
        this.delegate.m_128365_(this.getTagKey(), this.writeToNBT());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendTooltip(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
    }

    public static void registerOverride(Predicate<ItemStack> canApply, Function<ItemStack, ItemNBT> nbtSupplier) {
        OVERRIDES.add(new StackOverride(canApply, nbtSupplier));
    }

    public static class StackOverride {
        public Predicate<ItemStack> canApply;
        public Function<ItemStack, ItemNBT> nbtSupplier;

        public StackOverride(Predicate<ItemStack> canApply, Function<ItemStack, ItemNBT> nbtSupplier) {
            this.canApply = canApply;
            this.nbtSupplier = nbtSupplier;
        }

        public Optional<ItemNBT> getIfApplicable(ItemStack stack) {
            return this.canApply.test(stack) ? Optional.of(this.nbtSupplier.apply(stack)) : Optional.empty();
        }
    }
}

