/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.ispawner.init.ModNetwork;
import iskallia.ispawner.net.packet.UpdateSettingsC2SPacket;
import iskallia.ispawner.screen.handler.SpawnerScreenHandler;
import iskallia.ispawner.world.spawner.SpawnerSettings;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntConsumer;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SpawnerScreen
extends AbstractContainerScreen<SpawnerScreenHandler> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/container/generic_54.png");
    protected SpawnerSettings settings;
    private Slider attemptsSlider;
    private EditBox spawnDelayTextField;
    private Button modeButton;
    private Map<MobCategory, Slider> spawnGroupTextFields = new HashMap<MobCategory, Slider>();
    private Slider checkRangeSlider;
    private Slider playerRangeSlider;

    public SpawnerScreen(SpawnerScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.f_96546_ = false;
        this.f_97727_ = 168;
        this.f_97731_ = this.f_97727_ - 94;
    }

    public SpawnerSettings getSettings() {
        return this.settings;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        this.m_7025_(matrices, mouseX, mouseY);
    }

    protected void m_7027_(PoseStack matrices, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(matrices, this.f_96539_, (float)this.f_97728_ + 110.0f, (float)this.f_97729_, 0x404040);
        this.f_96547_.m_92889_(matrices, this.f_169604_, (float)this.f_97730_ + 110.0f, (float)this.f_97731_, 0x404040);
    }

    protected void m_7856_() {
        super.m_7856_();
        int offset = 2;
        this.attemptsSlider = (Slider)this.m_142416_((GuiEventListener)new Slider(40, offset, 160, 20, TextComponent.f_131282_, 0.0, "Attempts: ", 0.0, 32.0, i -> this.settings.setAttempts(i)));
        this.spawnDelayTextField = new EditBox(Minecraft.m_91087_().f_91062_, 40, offset + 25, 160, 20, TextComponent.f_131282_);
        this.spawnDelayTextField.m_94151_(text -> {
            if (this.settings != null && !text.isEmpty()) {
                try {
                    int delay = Integer.parseInt(text.trim());
                    this.settings.setSpawnDelay(delay);
                    this.sendSettings();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.m_142416_((GuiEventListener)this.spawnDelayTextField);
        this.modeButton = (Button)this.m_142416_((GuiEventListener)new Button(40, offset + 50, 160, 20, (Component)new TextComponent(SpawnerSettings.Mode.values()[0].text), button -> {
            if (this.settings != null) {
                SpawnerSettings.Mode[] modes = SpawnerSettings.Mode.values();
                this.settings.setMode(modes[(this.settings.getMode().ordinal() + 1) % modes.length]);
                button.m_93666_((Component)new TextComponent(this.settings.getMode().text));
                this.sendSettings();
            }
        }));
        for (int i2 = 0; i2 < MobCategory.values().length; ++i2) {
            MobCategory spawnGroup = MobCategory.values()[i2];
            CharSequence[] parts = spawnGroup.m_21607_().split(Pattern.quote("_"));
            for (int j2 = 0; j2 < parts.length; ++j2) {
                parts[j2] = Character.toUpperCase(((String)parts[j2]).charAt(0)) + ((String)parts[j2]).substring(1);
            }
            String prefix = String.join((CharSequence)" ", parts);
            Slider spawnField = (Slider)this.m_142416_((GuiEventListener)new Slider(40, offset + 80 + i2 * 20, 160, 20, TextComponent.f_131282_, 0.0, prefix + " Cap: ", 0.0, 32.0, j -> {
                this.settings.getCapRestrictions().get((Object)spawnGroup).limit = j;
            }));
            this.spawnGroupTextFields.put(spawnGroup, spawnField);
        }
        this.checkRangeSlider = (Slider)this.m_142416_((GuiEventListener)new Slider(40, offset + 80 + MobCategory.values().length * 20 + 10, 160, 20, TextComponent.f_131282_, 0.0, "Check Radius: ", 0.0, 128.0, i -> this.settings.setCheckRadius(i)));
        this.playerRangeSlider = (Slider)this.m_142416_((GuiEventListener)new Slider(40, offset + 80 + MobCategory.values().length * 20 + 30, 160, 20, TextComponent.f_131282_, 0.0, "Player Radius: ", 0.0, 128.0, i -> this.settings.setPlayerRadius(i)));
    }

    public void setSettings(SpawnerSettings settings) {
        this.settings = settings;
        this.attemptsSlider.setIntValue(settings.getAttempts());
        if (this.settings.getSpawnDelay() >= 0) {
            this.spawnDelayTextField.m_94144_(String.valueOf(this.settings.getSpawnDelay()));
        }
        this.modeButton.m_93666_((Component)new TextComponent(this.settings.getMode().text));
        this.spawnGroupTextFields.forEach((spawnGroup, textField) -> {
            if (settings.getCapRestrictions().get((Object)spawnGroup).limit > 0) {
                textField.setIntValue(settings.getCapRestrictions().get((Object)spawnGroup).limit);
            }
        });
        this.checkRangeSlider.setIntValue(settings.getCheckRadius());
        this.playerRangeSlider.setIntValue(settings.getPlayerRadius());
    }

    private void sendSettings() {
        if (this.settings != null) {
            ModNetwork.CHANNEL.sendToServer((Object)new UpdateSettingsC2SPacket(this.getSettings()));
        }
    }

    protected void m_7286_(PoseStack matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(matrices, i + 110, j, 0, 0, this.f_97726_, 71);
        this.m_93228_(matrices, i + 110, j + 54 + 17, 0, 126, this.f_97726_, 96);
    }

    public boolean m_7043_() {
        return false;
    }

    public class Slider
    extends AbstractSliderButton {
        private final String prefix;
        private final double min;
        private final double max;
        private final IntConsumer onChanged;

        public Slider(int x, int y, int width, int height, Component text, double value, String prefix, double min, double max, IntConsumer onChanged) {
            super(x, y, width, height, text, value);
            this.prefix = prefix;
            this.min = min;
            this.max = max;
            this.onChanged = onChanged;
            this.m_5695_();
        }

        public int getIntValue() {
            return Mth.m_14107_((double)Mth.m_14085_((double)this.min, (double)this.max, (double)this.f_93577_));
        }

        protected void m_5695_() {
            this.m_93666_((Component)new TextComponent(this.prefix + this.getIntValue()));
        }

        protected void m_5697_() {
            if (SpawnerScreen.this.settings != null) {
                this.onChanged.accept(this.getIntValue());
                SpawnerScreen.this.sendSettings();
            }
        }

        public void setIntValue(int attempts) {
            this.f_93577_ = (double)attempts / (this.max - this.min) + this.min;
            this.m_5695_();
        }
    }
}

