/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.world.spawner;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import iskallia.ispawner.block.entity.SpawnerBlockEntity;
import iskallia.ispawner.block.render.SpawnerBlockRenderer;
import iskallia.ispawner.util.Color;
import iskallia.ispawner.world.spawner.SpawnerAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class SpawnerRenderer {
    protected Set<Face> faces = new HashSet<Face>();

    public void refresh(SpawnerBlockEntity entity) {
        this.faces.clear();
        entity.manager.actions.forEach(entry -> this.faces.add(new Face(SpawnerBlockEntity.mirror(((SpawnerAction)entry.value).getPos().m_7954_(entity.getRotation()), entity.getMirror()), SpawnerBlockEntity.mirror(entity.getRotation().m_55954_(((SpawnerAction)entry.value).getSide()), entity.getMirror()), entry.weight)));
    }

    public void render(PoseStack matrices, VertexConsumer vertexConsumer, SpawnerBlockEntity entity) {
        new ArrayList<Face>(this.faces).stream().sorted(Comparator.comparingInt(o -> o.weight)).forEach(face -> face.render(matrices, vertexConsumer, this.faces, entity.getOffset()));
    }

    public static class Face {
        private final BlockPos pos;
        private final Direction side;
        private final int weight;
        private final Color color;

        public Face(BlockPos pos, Direction side, int weight) {
            this.pos = pos;
            this.side = side;
            this.weight = weight;
            this.color = SpawnerBlockRenderer.getColorFor(this.weight);
        }

        public void render(PoseStack matrices, VertexConsumer vertexConsumer, Collection<Face> neighbors, BlockPos offset) {
            matrices.m_85836_();
            BlockPos p = this.pos.m_141952_((Vec3i)offset);
            if (this.side == Direction.UP) {
                double center = (8.0 + (double)Minecraft.m_91087_().f_91062_.m_92895_(String.valueOf(this.weight)) / 2.0) / 16.0;
                matrices.m_85837_((double)p.m_123341_() + center - 0.03125, (double)p.m_123342_() + 1.01, (double)p.m_123343_() + 0.71875);
                matrices.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), 90.0f, true));
            } else if (this.side == Direction.DOWN) {
                double center = (8.0 + (double)Minecraft.m_91087_().f_91062_.m_92895_(String.valueOf(this.weight)) / 2.0) / 16.0;
                matrices.m_85837_((double)p.m_123341_() + center - 0.03125, (double)p.m_123342_() - 0.01, (double)p.m_123343_() + 0.28125);
                matrices.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), -90.0f, true));
            } else if (this.side == Direction.NORTH) {
                double center = (8.0 + (double)Minecraft.m_91087_().f_91062_.m_92895_(String.valueOf(this.weight)) / 2.0) / 16.0;
                matrices.m_85837_((double)p.m_123341_() + center - 0.03125, (double)p.m_123342_() + 0.71875, (double)p.m_123343_() - 0.01);
                matrices.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 0.0f, true));
            } else if (this.side == Direction.SOUTH) {
                double center = (8.0 - (double)Minecraft.m_91087_().f_91062_.m_92895_(String.valueOf(this.weight)) / 2.0) / 16.0;
                matrices.m_85837_((double)p.m_123341_() + center + 0.03125, (double)p.m_123342_() + 0.71875, (double)p.m_123343_() + 1.01);
                matrices.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 180.0f, true));
            } else if (this.side == Direction.WEST) {
                double center = (8.0 - (double)Minecraft.m_91087_().f_91062_.m_92895_(String.valueOf(this.weight)) / 2.0) / 16.0;
                matrices.m_85837_((double)p.m_123341_() - 0.01, (double)p.m_123342_() + 0.71875, (double)p.m_123343_() + center + 0.03125);
                matrices.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 90.0f, true));
            } else if (this.side == Direction.EAST) {
                double center = (8.0 + (double)Minecraft.m_91087_().f_91062_.m_92895_(String.valueOf(this.weight)) / 2.0) / 16.0;
                matrices.m_85837_((double)p.m_123341_() + 1.01, (double)p.m_123342_() + 0.71875, (double)p.m_123343_() + center - 0.03125);
                matrices.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), -90.0f, true));
            }
            matrices.m_85841_(-0.0625f, -0.0625f, 0.0625f);
            Minecraft.m_91087_().f_91062_.m_92889_(matrices, (Component)new TextComponent(String.valueOf(this.weight)), 0.0f, 0.0f, this.color.getRBG());
            matrices.m_85849_();
            if (this.side == Direction.DOWN) {
                if (!neighbors.contains(new Face(this.pos.m_142127_(), Direction.DOWN, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, offset);
                }
                if (!neighbors.contains(new Face(this.pos.m_142128_(), Direction.DOWN, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, offset);
                }
                if (!neighbors.contains(new Face(this.pos.m_142126_(), Direction.DOWN, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, offset);
                }
                if (!neighbors.contains(new Face(this.pos.m_142125_(), Direction.DOWN, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, offset);
                }
            } else if (this.side == Direction.UP) {
                if (!neighbors.contains(new Face(this.pos.m_142127_(), Direction.UP, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, offset);
                }
                if (!neighbors.contains(new Face(this.pos.m_142128_(), Direction.UP, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, offset);
                }
                if (!neighbors.contains(new Face(this.pos.m_142126_(), Direction.UP, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0, offset);
                }
                if (!neighbors.contains(new Face(this.pos.m_142125_(), Direction.UP, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, offset);
                }
            } else if (this.side == Direction.NORTH) {
                if (!neighbors.contains(new Face(this.pos.m_7495_(), Direction.NORTH, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, offset);
                }
                if (!neighbors.contains(new Face(this.pos.m_7494_(), Direction.NORTH, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, offset);
                }
                if (!neighbors.contains(new Face(this.pos.m_142126_(), Direction.NORTH, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, offset);
                }
                if (!neighbors.contains(new Face(this.pos.m_142125_(), Direction.NORTH, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, offset);
                }
            } else if (this.side == Direction.SOUTH) {
                if (!neighbors.contains(new Face(this.pos.m_7495_(), Direction.SOUTH, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, offset);
                }
                if (!neighbors.contains(new Face(this.pos.m_7494_(), Direction.SOUTH, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, offset);
                }
                if (!neighbors.contains(new Face(this.pos.m_142126_(), Direction.SOUTH, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, offset);
                }
                if (!neighbors.contains(new Face(this.pos.m_142125_(), Direction.SOUTH, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, offset);
                }
            } else if (this.side == Direction.WEST) {
                if (!neighbors.contains(new Face(this.pos.m_7495_(), Direction.WEST, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, offset);
                }
                if (!neighbors.contains(new Face(this.pos.m_7494_(), Direction.WEST, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, offset);
                }
                if (!neighbors.contains(new Face(this.pos.m_142127_(), Direction.WEST, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, offset);
                }
                if (!neighbors.contains(new Face(this.pos.m_142128_(), Direction.WEST, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, offset);
                }
            } else if (this.side == Direction.EAST) {
                if (!neighbors.contains(new Face(this.pos.m_7495_(), Direction.EAST, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, offset);
                }
                if (!neighbors.contains(new Face(this.pos.m_7494_(), Direction.EAST, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0, offset);
                }
                if (!neighbors.contains(new Face(this.pos.m_142127_(), Direction.EAST, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, offset);
                }
                if (!neighbors.contains(new Face(this.pos.m_142128_(), Direction.EAST, this.weight))) {
                    this.drawLine(matrices, vertexConsumer, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, offset);
                }
            }
        }

        public void drawLine(PoseStack matrices, VertexConsumer vertexConsumer, double x1, double y1, double z1, double x2, double y2, double z2, BlockPos offset) {
            Matrix4f posMatrix = matrices.m_85850_().m_85861_();
            Matrix3f normMatrix = matrices.m_85850_().m_85864_();
            BlockPos p = this.pos.m_141952_((Vec3i)offset);
            vertexConsumer.m_85982_(posMatrix, (float)p.m_123341_() + (float)x1, (float)p.m_123342_() + (float)y1, (float)p.m_123343_() + (float)z1).m_85950_(this.color.getFRed(), this.color.getFGreen(), this.color.getFBlue(), 1.0f).m_85977_(normMatrix, 1.0f, 0.0f, 0.0f).m_5752_();
            vertexConsumer.m_85982_(posMatrix, (float)p.m_123341_() + (float)x2, (float)p.m_123342_() + (float)y2, (float)p.m_123343_() + (float)z2).m_85950_(this.color.getFRed(), this.color.getFGreen(), this.color.getFBlue(), 1.0f).m_85977_(normMatrix, 1.0f, 0.0f, 0.0f).m_5752_();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Face)) {
                return false;
            }
            Face face = (Face)other;
            return this.pos.equals((Object)face.pos) && this.side == face.side && this.weight == face.weight;
        }

        public int hashCode() {
            return Objects.hash(this.pos, this.side, this.weight);
        }
    }
}

