/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.world.spawner;

import com.google.gson.annotations.Expose;
import iskallia.ispawner.nbt.INBTSerializable;
import iskallia.ispawner.net.packet.IByteSerializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.MobCategory;

public class SpawnerSettings
implements IByteSerializable<SpawnerSettings>,
INBTSerializable<CompoundTag> {
    @Expose
    protected int attempts = 4;
    @Expose
    protected int spawnDelay = 500;
    @Expose
    protected Mode mode = Mode.REDSTONE_ON;
    @Expose
    protected int checkRadius = 16;
    @Expose
    protected int playerRadius = 16;
    @Expose
    protected Map<MobCategory, CapRestriction> capRestrictions = (Map)Util.m_137469_(new HashMap(), map -> {
        map.put(MobCategory.MONSTER, new CapRestriction(MobCategory.MONSTER, 16));
        map.put(MobCategory.CREATURE, new CapRestriction(MobCategory.CREATURE, -1));
        map.put(MobCategory.AMBIENT, new CapRestriction(MobCategory.AMBIENT, -1));
        map.put(MobCategory.AXOLOTLS, new CapRestriction(MobCategory.AXOLOTLS, -1));
        map.put(MobCategory.UNDERGROUND_WATER_CREATURE, new CapRestriction(MobCategory.UNDERGROUND_WATER_CREATURE, -1));
        map.put(MobCategory.WATER_CREATURE, new CapRestriction(MobCategory.WATER_CREATURE, -1));
        map.put(MobCategory.WATER_AMBIENT, new CapRestriction(MobCategory.WATER_AMBIENT, -1));
        map.put(MobCategory.MISC, new CapRestriction(MobCategory.MISC, -1));
    });

    public int getAttempts() {
        return this.attempts;
    }

    public int getSpawnDelay() {
        return this.spawnDelay;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Map<MobCategory, CapRestriction> getCapRestrictions() {
        return this.capRestrictions;
    }

    public int getCheckRadius() {
        return this.checkRadius;
    }

    public int getPlayerRadius() {
        return this.playerRadius;
    }

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    public void setSpawnDelay(int spawnDelay) {
        this.spawnDelay = spawnDelay;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setMode(int ordinal) {
        this.mode = Mode.values()[ordinal];
    }

    public void setCapRestrictions(Map<MobCategory, CapRestriction> capRestrictions) {
        this.capRestrictions = capRestrictions;
    }

    public void setCheckRadius(int checkRadius) {
        this.checkRadius = checkRadius;
    }

    public void setPlayerRadius(int playerRadius) {
        this.playerRadius = playerRadius;
    }

    @Override
    public SpawnerSettings writeToBuf(FriendlyByteBuf buf) {
        buf.m_130130_(this.getAttempts());
        buf.m_130130_(this.getSpawnDelay());
        buf.m_130130_(this.getMode().ordinal());
        for (MobCategory spawnGroup : MobCategory.values()) {
            buf.m_130130_(this.getCapRestrictions().getOrDefault((Object)spawnGroup, (CapRestriction)new CapRestriction((MobCategory)spawnGroup, (int)-1)).limit);
        }
        buf.m_130130_(this.getCheckRadius());
        buf.m_130130_(this.getPlayerRadius());
        return this;
    }

    @Override
    public SpawnerSettings readFromBuf(FriendlyByteBuf buf) {
        this.setAttempts(buf.m_130242_());
        this.setSpawnDelay(buf.m_130242_());
        this.setMode(buf.m_130242_());
        for (MobCategory spawnGroup : MobCategory.values()) {
            this.getCapRestrictions().put(spawnGroup, new CapRestriction(spawnGroup, buf.m_130242_()));
        }
        this.setCheckRadius(buf.m_130242_());
        this.setPlayerRadius(buf.m_130242_());
        return this;
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("Attempts", this.getAttempts());
        nbt.m_128405_("SpawnDelay", this.getSpawnDelay());
        nbt.m_128405_("Mode", this.getMode().ordinal());
        ListTag capList = new ListTag();
        this.getCapRestrictions().values().forEach(cap -> capList.add((Object)cap.writeToNBT()));
        nbt.m_128365_("CapRestrictions", (Tag)capList);
        nbt.m_128405_("CheckRadius", this.getCheckRadius());
        nbt.m_128405_("PlayerRadius", this.getPlayerRadius());
        return nbt;
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        this.setAttempts(nbt.m_128451_("Attempts"));
        this.setSpawnDelay(nbt.m_128451_("SpawnDelay"));
        this.setMode(nbt.m_128451_("Mode"));
        ListTag capList = nbt.m_128437_("CapRestrictions", 10);
        capList.stream().map(tag -> (CompoundTag)tag).forEach(cap -> {
            CapRestriction capRestriction = new CapRestriction(null, 0);
            capRestriction.readFromNBT((CompoundTag)cap);
            this.getCapRestrictions().put(capRestriction.spawnGroup, capRestriction);
        });
        if (nbt.m_128425_("CheckRadius", 3)) {
            this.checkRadius = nbt.m_128451_("CheckRadius");
        }
        if (nbt.m_128425_("PlayerRadius", 3)) {
            this.playerRadius = nbt.m_128451_("PlayerRadius");
        }
    }

    public SpawnerSettings copy() {
        SpawnerSettings copy = new SpawnerSettings();
        copy.setAttempts(this.getAttempts());
        copy.setSpawnDelay(this.getSpawnDelay());
        copy.setMode(this.getMode());
        copy.setCapRestrictions(this.getCapRestrictions().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, o -> new CapRestriction(((CapRestriction)o.getValue()).spawnGroup, ((CapRestriction)o.getValue()).limit))));
        copy.setCheckRadius(this.getCheckRadius());
        copy.setPlayerRadius(this.getPlayerRadius());
        return copy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpawnerSettings)) {
            return false;
        }
        SpawnerSettings other = (SpawnerSettings)o;
        return this.getAttempts() == other.getAttempts() && this.getSpawnDelay() == other.getSpawnDelay() && this.getCheckRadius() == other.getCheckRadius() && this.getPlayerRadius() == other.getPlayerRadius() && this.getMode() == other.getMode() && Objects.equals(this.getCapRestrictions(), other.getCapRestrictions());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getAttempts(), this.getSpawnDelay(), this.getMode(), this.getCheckRadius(), this.getPlayerRadius(), this.getCapRestrictions()});
    }

    public static enum Mode {
        REDSTONE_PULSE("Redstone Pulse"),
        REDSTONE_ON("Redstone On"),
        ALWAYS_ON("Always On");

        public final String text;

        private Mode(String text) {
            this.text = text;
        }
    }

    public static class CapRestriction
    implements INBTSerializable<CompoundTag> {
        @Expose
        protected MobCategory spawnGroup;
        @Expose
        public int limit;

        public CapRestriction(MobCategory spawnGroup, int limit) {
            this.spawnGroup = spawnGroup;
            this.limit = limit;
        }

        @Override
        public CompoundTag writeToNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("SpawnGroup", this.spawnGroup.ordinal());
            nbt.m_128405_("Limit", this.limit);
            return nbt;
        }

        @Override
        public void readFromNBT(CompoundTag nbt) {
            this.spawnGroup = MobCategory.values()[nbt.m_128451_("SpawnGroup")];
            this.limit = nbt.m_128451_("Limit");
        }
    }
}

