/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.compat.jei;

import com.supermartijn642.trashcans.TrashCanTile;
import com.supermartijn642.trashcans.TrashCans;
import com.supermartijn642.trashcans.compat.Compatibility;
import com.supermartijn642.trashcans.filter.ItemFilter;
import com.supermartijn642.trashcans.filter.LiquidTrashCanFilters;
import com.supermartijn642.trashcans.packet.PacketChangeItemFilter;
import com.supermartijn642.trashcans.packet.PacketChangeLiquidFilter;
import com.supermartijn642.trashcans.screen.ItemTrashCanScreen;
import com.supermartijn642.trashcans.screen.LiquidTrashCanScreen;
import com.supermartijn642.trashcans.screen.TrashCanContainer;
import com.supermartijn642.trashcans.screen.TrashCanScreen;
import com.supermartijn642.trashcans.screen.UltimateTrashCanScreen;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class GhostIngredientHandler
implements IGhostIngredientHandler<TrashCanScreen<?>> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(final TrashCanScreen<?> screen, I ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        for (Slot slot : ((TrashCanContainer)screen.m_6262_()).f_38839_) {
            boolean isFluidFilterSlot;
            final Rect2i bounds = new Rect2i(screen.getGuiLeft() + slot.f_40220_, screen.getGuiTop() + slot.f_40221_, 17, 17);
            boolean isItemFilterSlot = screen instanceof ItemTrashCanScreen && slot.f_40219_ >= 1 && slot.f_40219_ <= 9 || screen instanceof UltimateTrashCanScreen && slot.f_40219_ >= 3 && slot.f_40219_ <= 11;
            boolean bl = isFluidFilterSlot = screen instanceof LiquidTrashCanScreen && slot.f_40219_ >= 1 && slot.f_40219_ <= 9 || screen instanceof UltimateTrashCanScreen && slot.f_40219_ >= 12 && slot.f_40219_ <= 20;
            if (isItemFilterSlot && ingredient instanceof ItemStack) {
                final int filterSlotNum = screen instanceof ItemTrashCanScreen ? slot.f_40219_ - 1 : slot.f_40219_ - 3;
                targets.add(new IGhostIngredientHandler.Target<I>(){

                    public Rect2i getArea() {
                        return bounds;
                    }

                    public void accept(I ingredient) {
                        TrashCanTile tile = ((TrashCanContainer)screen.m_6262_()).getObjectOrClose();
                        if (tile != null) {
                            tile.itemFilter.set(filterSlotNum, (ItemStack)ingredient);
                            TrashCans.CHANNEL.sendToServer((Object)new PacketChangeItemFilter(tile.m_58899_(), filterSlotNum, (ItemStack)ingredient));
                        }
                    }
                });
                continue;
            }
            if (!isFluidFilterSlot) continue;
            ItemStack repitem = ItemStack.f_41583_;
            if (ingredient instanceof ItemStack && this.isValidFluidItem((ItemStack)ingredient)) {
                repitem = (ItemStack)ingredient;
            } else if (ingredient instanceof FluidStack) {
                repitem = new ItemStack((ItemLike)((FluidStack)ingredient).getFluid().m_6859_());
            } else if (Compatibility.MEKANISM.isGasStack(ingredient)) {
                repitem = Compatibility.MEKANISM.getChemicalTankForGasStack(ingredient);
            }
            if (repitem.m_41619_()) continue;
            final ItemStack finalrepitem = repitem;
            final int filterSlotNum = screen instanceof LiquidTrashCanScreen ? slot.f_40219_ - 1 : slot.f_40219_ - 12;
            targets.add(new IGhostIngredientHandler.Target<I>(){

                public Rect2i getArea() {
                    return bounds;
                }

                public void accept(I ingredient) {
                    TrashCanTile tile;
                    ItemFilter filter = LiquidTrashCanFilters.createFilter(finalrepitem);
                    if (filter != null && (tile = ((TrashCanContainer)screen.m_6262_()).getObjectOrClose()) != null) {
                        tile.liquidFilter.set(filterSlotNum, filter);
                        TrashCans.CHANNEL.sendToServer((Object)new PacketChangeLiquidFilter(tile.m_58899_(), filterSlotNum, filter));
                    }
                }
            });
        }
        return targets;
    }

    public void onComplete() {
    }

    private boolean isValidFluidItem(ItemStack stack) {
        if (Compatibility.MEKANISM.doesItemHaveGasStored(stack)) {
            return true;
        }
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
        return fluidHandler != null && fluidHandler.getTanks() == 1 && !fluidHandler.getFluidInTank(0).isEmpty();
    }
}

