/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.trashcans.TrashCanTile;
import com.supermartijn642.trashcans.TrashCans;
import com.supermartijn642.trashcans.packet.PacketChangeEnergyLimit;
import com.supermartijn642.trashcans.packet.PacketToggleEnergyLimit;
import com.supermartijn642.trashcans.screen.ArrowButton;
import com.supermartijn642.trashcans.screen.CheckBox;
import com.supermartijn642.trashcans.screen.EnergyTrashCanContainer;
import com.supermartijn642.trashcans.screen.TrashCanScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class EnergyTrashCanScreen
extends TrashCanScreen<EnergyTrashCanContainer> {
    private CheckBox checkBox;
    private ArrowButton leftArrow;
    private ArrowButton rightArrow;
    private boolean shift;
    private boolean control;

    public EnergyTrashCanScreen(EnergyTrashCanContainer container) {
        super(container, "trashcans.gui.energy_trash_can.title");
    }

    protected void addWidgets(TrashCanTile tile) {
        this.checkBox = (CheckBox)this.addWidget((Widget)new CheckBox(21, 66, () -> TrashCans.CHANNEL.sendToServer((Object)new PacketToggleEnergyLimit(((EnergyTrashCanContainer)this.f_97732_).getTilePos()))));
        this.checkBox.update(tile.useEnergyLimit);
        this.leftArrow = (ArrowButton)this.addWidget((Widget)new ArrowButton(49, 66, true, () -> TrashCans.CHANNEL.sendToServer((Object)new PacketChangeEnergyLimit(((EnergyTrashCanContainer)this.f_97732_).getTilePos(), this.shift ? (this.control ? -1 : -100) : (this.control ? -10000 : -1000)))));
        this.leftArrow.active = tile.useEnergyLimit;
        this.rightArrow = (ArrowButton)this.addWidget((Widget)new ArrowButton(170, 66, false, () -> TrashCans.CHANNEL.sendToServer((Object)new PacketChangeEnergyLimit(((EnergyTrashCanContainer)this.f_97732_).getTilePos(), this.shift ? (this.control ? 1 : 100) : (this.control ? 10000 : 1000)))));
        this.rightArrow.active = tile.useEnergyLimit;
    }

    protected void renderTooltips(PoseStack matrixStack, int mouseX, int mouseY, TrashCanTile tile) {
        if (this.leftArrow.isHovered() && this.leftArrow.active) {
            Object[] objectArray = new Component[4];
            objectArray[0] = new TextComponent("-" + (this.shift ? (this.control ? 1 : 100) : (this.control ? 10000 : 1000)));
            objectArray[1] = new TranslatableComponent("trashcans.gui.energy_trash_can.limit.change1", new Object[]{"-100"}).m_130940_(ChatFormatting.AQUA);
            objectArray[2] = new TranslatableComponent("trashcans.gui.energy_trash_can.limit.change2", new Object[]{"-10000"}).m_130940_(ChatFormatting.AQUA);
            objectArray[3] = new TranslatableComponent("trashcans.gui.energy_trash_can.limit.change3", new Object[]{"-1"}).m_130940_(ChatFormatting.AQUA);
            this.renderToolTip(matrixStack, Lists.newArrayList((Object[])objectArray), mouseX, mouseY);
        }
        if (this.rightArrow.isHovered() && this.rightArrow.active) {
            Object[] objectArray = new Component[4];
            objectArray[0] = new TextComponent("+" + (this.shift ? (this.control ? 1 : 100) : (this.control ? 10000 : 1000)));
            objectArray[1] = new TranslatableComponent("trashcans.gui.energy_trash_can.limit.change1", new Object[]{"+100"}).m_130940_(ChatFormatting.AQUA);
            objectArray[2] = new TranslatableComponent("trashcans.gui.energy_trash_can.limit.change2", new Object[]{"+10000"}).m_130940_(ChatFormatting.AQUA);
            objectArray[3] = new TranslatableComponent("trashcans.gui.energy_trash_can.limit.change3", new Object[]{"+1"}).m_130940_(ChatFormatting.AQUA);
            this.renderToolTip(matrixStack, Lists.newArrayList((Object[])objectArray), mouseX, mouseY);
        }
    }

    protected void containerTick(TrashCanTile tile) {
        this.checkBox.update(tile.useEnergyLimit);
        this.leftArrow.active = tile.useEnergyLimit;
        this.rightArrow.active = tile.useEnergyLimit;
    }

    @Override
    protected String getBackground() {
        return "energy_screen.png";
    }

    @Override
    protected void drawText(PoseStack matrixStack, TrashCanTile tile) {
        ScreenUtils.drawString((PoseStack)matrixStack, (Component)new TranslatableComponent("trashcans.gui.energy_trash_can.limit"), (float)8.0f, (float)52.0f);
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Component)new TextComponent(I18n.m_118938_((String)"trashcans.gui.energy_trash_can.value", (Object[])new Object[0]).replace("$number$", "" + tile.energyLimit)), (float)114.0f, (float)71.0f);
    }

    public boolean keyPressed(int keyCode) {
        if (keyCode == 340) {
            this.shift = true;
        } else if (keyCode == 341) {
            this.control = true;
        }
        return super.keyPressed(keyCode);
    }

    public boolean keyReleased(int keyCode) {
        if (keyCode == 340) {
            this.shift = false;
        } else if (keyCode == 341) {
            this.control = false;
        }
        return super.keyReleased(keyCode);
    }
}

