/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.light.flat;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.data.LightDataAccess;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class FlatLightPipeline
implements LightPipeline {
    private final LightDataAccess lightCache;

    public FlatLightPipeline(LightDataAccess lightCache) {
        this.lightCache = lightCache;
    }

    @Override
    public void calculate(ModelQuadView quad, BlockPos pos, QuadLightData out, Direction cullFace, Direction face, boolean shade) {
        int flags;
        int lightmap = cullFace != null ? this.getOffsetLightmap(pos, cullFace) : (((flags = quad.getFlags()) & 4) != 0 || (flags & 2) != 0 && LightDataAccess.unpackFC(this.lightCache.get(pos)) ? this.getOffsetLightmap(pos, face) : LightDataAccess.unpackLM(this.lightCache.get(pos)));
        Arrays.fill(out.lm, lightmap);
        Arrays.fill(out.br, this.lightCache.getWorld().m_7717_(face, shade));
    }

    private int getOffsetLightmap(BlockPos pos, Direction face) {
        int lightmap = LightDataAccess.unpackLM(this.lightCache.get(pos, face));
        if ((lightmap & 0xF0) != 240) {
            int originLightmap = LightDataAccess.unpackLM(this.lightCache.get(pos));
            lightmap = lightmap & 0xFFFFFF00 | Math.max(lightmap & 0xFF, originLightmap & 0xFF);
        }
        return lightmap;
    }
}

