/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.compat.immersive.ImmersiveEmptyChunkChecker;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkCameraContext;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderList;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkTracker;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkUpdateType;
import me.jellysquid.mods.sodium.client.render.chunk.RegionChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.format.ChunkModelVertexFormats;
import me.jellysquid.mods.sodium.client.render.chunk.graph.ChunkGraphInfo;
import me.jellysquid.mods.sodium.client.render.chunk.graph.ChunkGraphIterationQueue;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPassManager;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegionManager;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderBuildTask;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderEmptyBuildTask;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderRebuildTask;
import me.jellysquid.mods.sodium.client.util.MathUtil;
import me.jellysquid.mods.sodium.client.util.frustum.Frustum;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import me.jellysquid.mods.sodium.common.util.collections.WorkStealingFutureDrain;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.Vec3;

public class RenderSectionManager {
    private static final double NEARBY_CHUNK_DISTANCE = Math.pow(32.0, 2.0);
    private static final float FOG_PLANE_MIN_DISTANCE = (float)Math.pow(8.0, 2.0);
    private static final float FOG_PLANE_OFFSET = 12.0f;
    private final ChunkBuilder builder;
    private final RenderRegionManager regions;
    private final ClonedChunkSectionCache sectionCache;
    private final Long2ReferenceMap<RenderSection> sections = new Long2ReferenceOpenHashMap();
    private final Map<ChunkUpdateType, PriorityQueue<RenderSection>> rebuildQueues = new EnumMap<ChunkUpdateType, PriorityQueue<RenderSection>>(ChunkUpdateType.class);
    private final ChunkRenderList chunkRenderList = new ChunkRenderList();
    private final ChunkGraphIterationQueue iterationQueue = new ChunkGraphIterationQueue();
    private final ObjectList<RenderSection> tickableChunks = new ObjectArrayList();
    private final ObjectList<BlockEntity> visibleBlockEntities = new ObjectArrayList();
    private final RegionChunkRenderer chunkRenderer = new RegionChunkRenderer(RenderDevice.INSTANCE, ChunkModelVertexFormats.DEFAULT);
    private final SodiumWorldRenderer worldRenderer;
    private final ClientLevel world;
    private final int renderDistance;
    private float cameraX;
    private float cameraY;
    private float cameraZ;
    private int centerChunkX;
    private int centerChunkZ;
    private boolean needsUpdate;
    private boolean useFogCulling;
    private boolean useOcclusionCulling;
    private double fogRenderCutoff;
    private Frustum frustum;
    private int currentFrame = 0;
    private boolean alwaysDeferChunkUpdates;
    private final ChunkTracker tracker;

    public RenderSectionManager(SodiumWorldRenderer worldRenderer, BlockRenderPassManager renderPassManager, ClientLevel world, int renderDistance, CommandList commandList) {
        this.worldRenderer = worldRenderer;
        this.world = world;
        this.builder = new ChunkBuilder(ChunkModelVertexFormats.DEFAULT);
        this.builder.init(world, renderPassManager);
        this.needsUpdate = true;
        this.renderDistance = renderDistance;
        this.regions = new RenderRegionManager(commandList);
        this.sectionCache = new ClonedChunkSectionCache((Level)this.world);
        for (ChunkUpdateType type : ChunkUpdateType.values()) {
            this.rebuildQueues.put(type, (PriorityQueue<RenderSection>)new ObjectArrayFIFOQueue());
        }
        this.tracker = this.worldRenderer.getChunkTracker();
    }

    public void reloadChunks(ChunkTracker tracker) {
        tracker.getChunks(1).forEach(pos -> this.onChunkAdded(ChunkPos.m_45592_((long)pos), ChunkPos.m_45602_((long)pos)));
    }

    public void update(Camera camera, Frustum frustum, int frame, boolean spectator) {
        this.resetLists();
        this.regions.updateVisibility(frustum);
        this.setup(camera);
        this.iterateChunks(camera, frustum, frame, spectator);
        this.needsUpdate = false;
    }

    private void setup(Camera camera) {
        Vec3 cameraPos = camera.m_90583_();
        this.cameraX = (float)cameraPos.f_82479_;
        this.cameraY = (float)cameraPos.f_82480_;
        this.cameraZ = (float)cameraPos.f_82481_;
        SodiumGameOptions options = SodiumClientMod.options();
        this.useFogCulling = options.performance.useFogOcclusion;
        this.alwaysDeferChunkUpdates = options.performance.alwaysDeferChunkUpdates;
        if (this.useFogCulling) {
            float dist = RenderSystem.m_157199_() + 12.0f;
            this.fogRenderCutoff = dist == 0.0f ? Double.POSITIVE_INFINITY : (double)Math.max(FOG_PLANE_MIN_DISTANCE, dist * dist);
        }
    }

    private void iterateChunks(Camera camera, Frustum frustum, int frame, boolean spectator) {
        this.initSearch(camera, frustum, frame, spectator);
        ChunkGraphIterationQueue queue = this.iterationQueue;
        for (int i = 0; i < queue.size(); ++i) {
            RenderSection section = queue.getRender(i);
            Direction flow = queue.getDirection(i);
            this.schedulePendingUpdates(section);
            for (Direction dir : DirectionUtil.ALL_DIRECTIONS) {
                RenderSection adj;
                if (this.isCulled(section.getGraphInfo(), flow, dir) || (adj = section.getAdjacent(dir)) == null || !this.isWithinRenderDistance(adj)) continue;
                this.bfsEnqueue(section, adj, DirectionUtil.getOpposite(dir));
            }
        }
    }

    private void schedulePendingUpdates(RenderSection section) {
        if (section.getPendingUpdate() == null || !this.tracker.hasMergedFlags(section.getChunkX(), section.getChunkZ(), 3)) {
            return;
        }
        PriorityQueue<RenderSection> queue = this.rebuildQueues.get((Object)section.getPendingUpdate());
        if (queue.size() >= 32) {
            return;
        }
        queue.enqueue((Object)section);
    }

    private void addChunkToVisible(RenderSection render) {
        this.chunkRenderList.add(render);
        if (render.isTickable()) {
            this.tickableChunks.add((Object)render);
        }
    }

    private void addEntitiesToRenderLists(RenderSection render) {
        Collection<BlockEntity> blockEntities = render.getData().getBlockEntities();
        if (!blockEntities.isEmpty()) {
            this.visibleBlockEntities.addAll(blockEntities);
        }
    }

    private void resetLists() {
        for (PriorityQueue<RenderSection> queue : this.rebuildQueues.values()) {
            queue.clear();
        }
        this.visibleBlockEntities.clear();
        this.chunkRenderList.clear();
        this.tickableChunks.clear();
    }

    public Collection<BlockEntity> getVisibleBlockEntities() {
        return this.visibleBlockEntities;
    }

    public void onChunkAdded(int x, int z) {
        for (int y = this.world.m_151560_(); y < this.world.m_151561_(); ++y) {
            this.needsUpdate |= this.loadSection(x, y, z);
        }
    }

    public void onChunkRemoved(int x, int z) {
        for (int y = this.world.m_151560_(); y < this.world.m_151561_(); ++y) {
            this.needsUpdate |= this.unloadSection(x, y, z);
        }
    }

    private boolean loadSection(int x, int y, int z) {
        RenderRegion region = this.regions.createRegionForChunk(x, y, z);
        RenderSection render = new RenderSection(this.worldRenderer, x, y, z, region);
        region.addChunk(render);
        this.sections.put(SectionPos.m_123209_((int)x, (int)y, (int)z), (Object)render);
        LevelChunk chunk = this.world.m_6325_(x, z);
        LevelChunkSection section = chunk.m_7103_()[this.world.m_151566_(y)];
        if (section.m_188008_()) {
            if (!SodiumClientMod.immersiveLoaded) {
                render.setData(ChunkRenderData.EMPTY);
            } else if (!ImmersiveEmptyChunkChecker.hasWires(SectionPos.m_123173_((int)x, (int)y, (int)z))) {
                render.setData(ChunkRenderData.EMPTY);
            }
        } else {
            render.markForUpdate(ChunkUpdateType.INITIAL_BUILD);
        }
        this.connectNeighborNodes(render);
        return true;
    }

    private boolean unloadSection(int x, int y, int z) {
        RenderSection chunk = (RenderSection)this.sections.remove(SectionPos.m_123209_((int)x, (int)y, (int)z));
        if (chunk == null) {
            throw new IllegalStateException("Chunk is not loaded: " + String.valueOf(SectionPos.m_123173_((int)x, (int)y, (int)z)));
        }
        chunk.delete();
        this.disconnectNeighborNodes(chunk);
        RenderRegion region = chunk.getRegion();
        region.removeChunk(chunk);
        return true;
    }

    public void renderLayer(ChunkRenderMatrices matrices, BlockRenderPass pass, double x, double y, double z) {
        RenderDevice device = RenderDevice.INSTANCE;
        CommandList commandList = device.createCommandList();
        this.chunkRenderer.render(matrices, commandList, this.chunkRenderList, pass, new ChunkCameraContext(x, y, z));
        commandList.flush();
    }

    public void tickVisibleRenders() {
        for (RenderSection render : this.tickableChunks) {
            render.tick();
        }
    }

    public boolean isSectionVisible(int x, int y, int z) {
        RenderSection render = this.getRenderSection(x, y, z);
        if (render == null) {
            return false;
        }
        return render.getGraphInfo().getLastVisibleFrame() == this.currentFrame;
    }

    public void updateChunks() {
        LinkedList blockingFutures = this.submitRebuildTasks(ChunkUpdateType.IMPORTANT_REBUILD);
        this.submitRebuildTasks(ChunkUpdateType.INITIAL_BUILD);
        this.submitRebuildTasks(ChunkUpdateType.REBUILD);
        this.needsUpdate |= this.performPendingUploads();
        if (!blockingFutures.isEmpty()) {
            this.needsUpdate = true;
            this.regions.upload(RenderDevice.INSTANCE.createCommandList(), new WorkStealingFutureDrain<ChunkBuildResult>(blockingFutures, this.builder::stealTask));
        }
        this.regions.cleanup();
    }

    private LinkedList<CompletableFuture<ChunkBuildResult>> submitRebuildTasks(ChunkUpdateType filterType) {
        int budget = filterType.isImportant() ? Integer.MAX_VALUE : this.builder.getSchedulingBudget();
        LinkedList<CompletableFuture<ChunkBuildResult>> immediateFutures = new LinkedList<CompletableFuture<ChunkBuildResult>>();
        PriorityQueue<RenderSection> queue = this.rebuildQueues.get((Object)filterType);
        while (budget > 0 && !queue.isEmpty()) {
            CompletableFuture<Object> future;
            RenderSection section = (RenderSection)queue.dequeue();
            if (section.isDisposed() || section.getPendingUpdate() != filterType) continue;
            ChunkRenderBuildTask task = this.createRebuildTask(section);
            if (filterType.isImportant()) {
                CompletableFuture<ChunkBuildResult> immediateFuture = this.builder.schedule(task);
                immediateFutures.add(immediateFuture);
                future = immediateFuture;
            } else {
                future = this.builder.scheduleDeferred(task);
            }
            section.onBuildSubmitted(future);
            --budget;
        }
        return immediateFutures;
    }

    private boolean performPendingUploads() {
        Iterator<ChunkBuildResult> it = this.builder.createDeferredBuildResultDrain();
        if (!it.hasNext()) {
            return false;
        }
        this.regions.upload(RenderDevice.INSTANCE.createCommandList(), it);
        return true;
    }

    public ChunkRenderBuildTask createRebuildTask(RenderSection render) {
        ChunkRenderContext context = WorldSlice.prepare((Level)this.world, render.getChunkPos(), this.sectionCache);
        int frame = this.currentFrame;
        if (context == null) {
            return SodiumClientMod.immersiveLoaded ? ImmersiveEmptyChunkChecker.makeEmptyRebuildTask(this.sectionCache, render.getChunkPos(), render, this.currentFrame) : new ChunkRenderEmptyBuildTask(render, frame);
        }
        return new ChunkRenderRebuildTask(render, context, frame);
    }

    public void markGraphDirty() {
        this.needsUpdate = true;
    }

    public boolean isGraphDirty() {
        return this.needsUpdate;
    }

    public ChunkBuilder getBuilder() {
        return this.builder;
    }

    public void destroy() {
        this.resetLists();
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            this.regions.delete(commandList);
        }
        this.chunkRenderer.delete();
        this.builder.stopWorkers();
    }

    public int getTotalSections() {
        int sum = 0;
        for (RenderRegion region : this.regions.getLoadedRegions()) {
            sum += region.getChunkCount();
        }
        return sum;
    }

    public int getVisibleChunkCount() {
        return this.chunkRenderList.getCount();
    }

    public void scheduleRebuild(int x, int y, int z, boolean important) {
        this.sectionCache.invalidate(x, y, z);
        RenderSection section = (RenderSection)this.sections.get(SectionPos.m_123209_((int)x, (int)y, (int)z));
        if (section != null && section.isBuilt()) {
            if (!this.alwaysDeferChunkUpdates && (important || this.isChunkPrioritized(section))) {
                section.markForUpdate(ChunkUpdateType.IMPORTANT_REBUILD);
            } else {
                section.markForUpdate(ChunkUpdateType.REBUILD);
            }
        }
        this.needsUpdate = true;
    }

    public boolean isChunkPrioritized(RenderSection render) {
        return render != null ? render.getSquaredDistance(this.cameraX, this.cameraY, this.cameraZ) <= NEARBY_CHUNK_DISTANCE : false;
    }

    public void onChunkRenderUpdates(int x, int y, int z, ChunkRenderData data) {
        RenderSection node = this.getRenderSection(x, y, z);
        if (node != null) {
            node.setOcclusionData(data.getOcclusionData());
        }
    }

    private boolean isWithinRenderDistance(RenderSection adj) {
        int x = Math.abs(adj.getChunkX() - this.centerChunkX);
        int z = Math.abs(adj.getChunkZ() - this.centerChunkZ);
        return x <= this.renderDistance && z <= this.renderDistance;
    }

    private boolean isCulled(ChunkGraphInfo node, Direction from, Direction to) {
        if (node.canCull(to)) {
            return true;
        }
        return this.useOcclusionCulling && from != null && !node.isVisibleThrough(from, to);
    }

    private void initSearch(Camera camera, Frustum frustum, int frame, boolean spectator) {
        this.currentFrame = frame;
        this.frustum = frustum;
        this.useOcclusionCulling = Minecraft.m_91087_().f_90980_;
        this.iterationQueue.clear();
        BlockPos origin = camera.m_90588_();
        int chunkX = origin.m_123341_() >> 4;
        int chunkY = origin.m_123342_() >> 4;
        int chunkZ = origin.m_123343_() >> 4;
        this.centerChunkX = chunkX;
        this.centerChunkZ = chunkZ;
        RenderSection rootRender = this.getRenderSection(chunkX, chunkY, chunkZ);
        if (rootRender != null) {
            ChunkGraphInfo rootInfo = rootRender.getGraphInfo();
            rootInfo.resetCullingState();
            rootInfo.setLastVisibleFrame(frame);
            if (spectator && this.world.m_8055_(origin).m_60804_((BlockGetter)this.world, origin)) {
                this.useOcclusionCulling = false;
            }
            this.addVisible(rootRender, null);
        } else {
            chunkY = Mth.m_14045_((int)(origin.m_123342_() >> 4), (int)this.world.m_151560_(), (int)(this.world.m_151561_() - 1));
            ArrayList<RenderSection> sorted = new ArrayList<RenderSection>();
            for (int x2 = -this.renderDistance; x2 <= this.renderDistance; ++x2) {
                for (int z2 = -this.renderDistance; z2 <= this.renderDistance; ++z2) {
                    ChunkGraphInfo info;
                    RenderSection render = this.getRenderSection(chunkX + x2, chunkY, chunkZ + z2);
                    if (render == null || (info = render.getGraphInfo()).isCulledByFrustum(frustum)) continue;
                    info.resetCullingState();
                    info.setLastVisibleFrame(frame);
                    sorted.add(render);
                }
            }
            sorted.sort(Comparator.comparingDouble(node -> node.getSquaredDistance(origin)));
            for (RenderSection render : sorted) {
                this.addVisible(render, null);
            }
        }
    }

    private void bfsEnqueue(RenderSection parent, RenderSection render, Direction flow) {
        ChunkGraphInfo info = render.getGraphInfo();
        if (info.getLastVisibleFrame() == this.currentFrame) {
            return;
        }
        Frustum.Visibility parentVisibility = parent.getRegion().getVisibility();
        if (parentVisibility == Frustum.Visibility.OUTSIDE) {
            return;
        }
        if (parentVisibility == Frustum.Visibility.INTERSECT && info.isCulledByFrustum(this.frustum)) {
            return;
        }
        info.setLastVisibleFrame(this.currentFrame);
        info.setCullingState(parent.getGraphInfo().getCullingState(), flow);
        this.addVisible(render, flow);
    }

    private void addVisible(RenderSection render, Direction flow) {
        this.iterationQueue.add(render, flow);
        if (this.useFogCulling && render.getSquaredDistanceXZ(this.cameraX, this.cameraZ) >= this.fogRenderCutoff) {
            return;
        }
        if (!render.isEmpty()) {
            this.addChunkToVisible(render);
            this.addEntitiesToRenderLists(render);
        }
    }

    private void connectNeighborNodes(RenderSection render) {
        for (Direction dir : DirectionUtil.ALL_DIRECTIONS) {
            RenderSection adj = this.getRenderSection(render.getChunkX() + dir.m_122429_(), render.getChunkY() + dir.m_122430_(), render.getChunkZ() + dir.m_122431_());
            if (adj == null) continue;
            adj.setAdjacentNode(DirectionUtil.getOpposite(dir), render);
            render.setAdjacentNode(dir, adj);
        }
    }

    private void disconnectNeighborNodes(RenderSection render) {
        for (Direction dir : DirectionUtil.ALL_DIRECTIONS) {
            RenderSection adj = render.getAdjacent(dir);
            if (adj == null) continue;
            adj.setAdjacentNode(DirectionUtil.getOpposite(dir), null);
            render.setAdjacentNode(dir, null);
        }
    }

    private RenderSection getRenderSection(int x, int y, int z) {
        return (RenderSection)this.sections.get(SectionPos.m_123209_((int)x, (int)y, (int)z));
    }

    public Collection<String> getDebugStrings() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = this.regions.getLoadedRegions().stream().map(RenderRegion::getArenas).filter(Objects::nonNull).iterator();
        int count = 0;
        long deviceUsed = 0L;
        long deviceAllocated = 0L;
        while (it.hasNext()) {
            RenderRegion.RenderRegionArenas arena = (RenderRegion.RenderRegionArenas)it.next();
            deviceUsed += arena.getDeviceUsedMemory();
            deviceAllocated += arena.getDeviceAllocatedMemory();
            ++count;
        }
        list.add(String.format("Chunk arena allocator: %s", SodiumClientMod.options().advanced.arenaMemoryAllocator.name()));
        list.add(String.format("Device buffer objects: %d", count));
        list.add(String.format("Device memory: %d/%d MiB", MathUtil.toMib(deviceUsed), MathUtil.toMib(deviceAllocated)));
        list.add(String.format("Staging buffer: %s", this.regions.getStagingBuffer().toString()));
        return list;
    }
}

