/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.particle.cull;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import net.minecraft.client.Camera;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ParticleEngine.class})
public class MixinParticleManager {
    @Shadow
    @Final
    private Map<ParticleRenderType, Queue<Particle>> f_107289_;
    private final Queue<Particle> cachedQueue = new ArrayDeque<Particle>();
    private boolean useCulling;

    @Inject(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider$Immediate;Lnet/minecraft/client/render/LightmapTextureManager;Lnet/minecraft/client/render/Camera;FLnet/minecraft/client/render/Frustum;)V"}, at={@At(value="HEAD")})
    private void preRenderParticles(PoseStack matrixStack, MultiBufferSource.BufferSource immediate, LightTexture lightmapTextureManager, Camera camera, float f, Frustum frustum, CallbackInfo ci) {
        this.useCulling = SodiumClientMod.options().performance.useParticleCulling;
    }

    @Redirect(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider$Immediate;Lnet/minecraft/client/render/LightmapTextureManager;Lnet/minecraft/client/render/Camera;FLnet/minecraft/client/render/Frustum;)V"}, at=@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;"), remap=false)
    private <V> V filterParticleList(Map<ParticleRenderType, Queue<Particle>> map, Object key, PoseStack matrixStack, MultiBufferSource.BufferSource immediate, LightTexture lightmapTextureManager, Camera camera, float f, Frustum frustum) {
        Queue<Particle> queue = this.f_107289_.get(key);
        if (queue == null || queue.isEmpty()) {
            return null;
        }
        SodiumWorldRenderer renderer = SodiumWorldRenderer.instanceNullable();
        if (renderer == null || !this.useCulling) {
            return (V)queue;
        }
        Queue<Particle> filtered = this.cachedQueue;
        filtered.clear();
        for (Particle particle : queue) {
            AABB box = particle.m_107277_();
            if (!renderer.isBoxVisible(box.f_82288_ - 1.0, box.f_82289_ - 1.0, box.f_82290_ - 1.0, box.f_82291_ + 1.0, box.f_82292_ + 1.0, box.f_82293_ + 1.0)) continue;
            filtered.add(particle);
        }
        return (V)filtered;
    }

    @Inject(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider$Immediate;Lnet/minecraft/client/render/LightmapTextureManager;Lnet/minecraft/client/render/Camera;FLnet/minecraft/client/render/Frustum;)V"}, at={@At(value="RETURN")})
    private void postRenderParticles(PoseStack matrixStack, MultiBufferSource.BufferSource immediate, LightTexture lightmapTextureManager, Camera camera, float f, Frustum frustum, CallbackInfo ci) {
        this.cachedQueue.clear();
    }
}

