/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.bracket;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.BracketValidator;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.bracket.ForgeBracketValidators")
@Document(value="forge/api/ForgeBracketValidators")
public final class ForgeBracketValidators {
    private ForgeBracketValidators() {
    }

    @ZenCodeType.StaticExpansionMethod
    @BracketValidator(value="toolaction")
    public static boolean validateToolActionBracket(String tokens) {
        return tokens.chars().allMatch(c -> 97 <= c && c <= 122 || c == 95);
    }

    @ZenCodeType.StaticExpansionMethod
    @BracketValidator(value="fluid")
    public static boolean validateFluidStack(String tokens) {
        ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)tokens);
        if (resourceLocation == null) {
            CraftTweakerAPI.LOGGER.error("Could not get BEP <fluid:{}>. Syntax is <fluid:modid:fluidname>", (Object)tokens);
            return false;
        }
        if (Services.REGISTRY.fluids().containsKey(resourceLocation)) {
            return true;
        }
        CraftTweakerAPI.LOGGER.error("Could not get fluid for <fluid:{}>. Fluid does not appear to exist!", (Object)tokens);
        return false;
    }
}

