/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.command;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.impl.network.message.MessageCopy;
import com.blamejared.crafttweaker.platform.Services;
import java.nio.file.Path;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public final class CommandUtilities {
    private CommandUtilities() {
    }

    public static void sendCopyingAndCopy(MutableComponent component, String toCopy, Player player) {
        CommandUtilities.sendCopying(component, toCopy, player);
        CommandUtilities.copy(player, toCopy);
    }

    public static void sendCopying(MutableComponent component, String toCopy, Player player) {
        CommandUtilities.send(CommandUtilities.copy(component, toCopy), player);
    }

    public static void send(Component component, CommandSourceStack source) {
        source.m_81354_(component, true);
        if (!component.getString().isBlank()) {
            CraftTweakerAPI.LOGGER.info(component.getString());
        }
    }

    public static void send(Component component, Player player) {
        player.m_6352_(component, CraftTweakerConstants.CRAFTTWEAKER_UUID);
        if (!component.m_6111_().isBlank()) {
            CraftTweakerAPI.LOGGER.info(component.m_6111_());
        }
    }

    public static void copy(Player player, String toCopy) {
        if (player instanceof ServerPlayer) {
            Services.NETWORK.sendCopyMessage((ServerPlayer)player, new MessageCopy(toCopy));
        }
    }

    public static void open(Player player, Path path) {
        TranslatableComponent component = new TranslatableComponent("crafttweaker.command.click.open", new Object[]{new TextComponent(path.toString()).m_130940_(ChatFormatting.GOLD)});
        CommandUtilities.send((Component)component.m_130938_(arg_0 -> CommandUtilities.lambda$open$0((MutableComponent)component, path, arg_0)), player);
    }

    public static String stripNewLine(String string) {
        return string.substring(0, string.lastIndexOf("\n"));
    }

    public static String stripNewLine(StringBuilder string) {
        return string.substring(0, string.lastIndexOf("\n"));
    }

    public static Component copy(MutableComponent base, String toCopy) {
        Style style = base.m_7383_();
        style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("crafttweaker.command.click.copy", new Object[]{new TextComponent(toCopy).m_130940_(ChatFormatting.GOLD)})));
        style = style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, toCopy));
        return base.m_6270_(style);
    }

    public static Component open(MutableComponent base, String path) {
        Style style = base.m_7383_();
        style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("crafttweaker.command.click.open", new Object[]{new TextComponent(path).m_130940_(ChatFormatting.GOLD)})));
        style = style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, path));
        return base.m_6270_(style);
    }

    public static Component run(MutableComponent base, String command) {
        Style style = base.m_7383_();
        style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("crafttweaker.command.click.run", new Object[]{new TextComponent(command).m_130940_(ChatFormatting.GOLD)})));
        style = style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command));
        return base.m_6270_(style);
    }

    public static Component openingUrl(MutableComponent base, String url) {
        TranslatableComponent component = new TranslatableComponent("crafttweaker.command.click.goto", new Object[]{new TextComponent(url).m_130940_(ChatFormatting.GOLD)});
        return base.m_130938_(arg_0 -> CommandUtilities.lambda$openingUrl$1((MutableComponent)component, url, arg_0));
    }

    public static Component openingFile(MutableComponent base, String path) {
        TranslatableComponent component = new TranslatableComponent("crafttweaker.command.click.open", new Object[]{new TextComponent(path).m_130940_(ChatFormatting.GOLD)});
        return base.m_130938_(arg_0 -> CommandUtilities.lambda$openingFile$2((MutableComponent)component, path, arg_0));
    }

    public static Component openingLogFile(MutableComponent base) {
        return CommandUtilities.openingFile(base, "logs/crafttweaker.log");
    }

    public static MutableComponent getFormattedLogFile() {
        return new TextComponent("logs/crafttweaker.log").m_130940_(ChatFormatting.AQUA);
    }

    public static MutableComponent makeNoticeable(MutableComponent text) {
        return text.m_130940_(ChatFormatting.YELLOW);
    }

    public static MutableComponent makeNoticeable(String text) {
        return CommandUtilities.makeNoticeable((MutableComponent)new TextComponent(text));
    }

    private static /* synthetic */ Style lambda$openingFile$2(MutableComponent component, String path, Style style) {
        return style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)component)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, path));
    }

    private static /* synthetic */ Style lambda$openingUrl$1(MutableComponent component, String url, Style style) {
        return style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)component)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
    }

    private static /* synthetic */ Style lambda$open$0(MutableComponent component, Path path, Style style) {
        return style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)component.m_6881_())).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, path.toString()));
    }
}

