/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.item;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.base.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.item.ForgeItemStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.item.MCItemStackMutable")
@Document(value="forge/api/item/MCItemStackMutable")
public class MCItemStackMutable
implements ForgeItemStack {
    public static Supplier<MCItemStackMutable> EMPTY = () -> new MCItemStackMutable(ItemStack.f_41583_);
    private final ItemStack internal;

    public MCItemStackMutable(ItemStack internal) {
        this.internal = internal;
    }

    @Override
    public String getCommandString() {
        StringBuilder sb = new StringBuilder("<item:");
        sb.append(this.getInternal().m_41720_().getRegistryName());
        sb.append(">");
        if (this.getInternal().m_41783_() != null) {
            MapData data = (MapData)TagToDataConverter.convert((Tag)this.getInternal().m_41783_()).copyInternal();
            if (this.getInternal().m_41763_()) {
                data.remove("Damage");
            }
            if (!data.isEmpty()) {
                sb.append(".withTag(");
                sb.append(data.asString());
                sb.append(")");
            }
        }
        if (this.getInternal().m_41773_() > 0) {
            sb.append(".withDamage(").append(this.getInternal().m_41773_()).append(")");
        }
        if (!this.isEmpty() && this.getAmount() != 1) {
            sb.append(" * ").append(this.getAmount());
        }
        return sb.toString();
    }

    @Override
    public IItemStack[] getItems() {
        return new IItemStack[]{this};
    }

    @Override
    public IItemStack copy() {
        return new MCItemStackMutable(this.getInternal().m_41777_());
    }

    @Override
    public IItemStack asMutable() {
        return this;
    }

    @Override
    public IItemStack asImmutable() {
        return new MCItemStack(this.getInternal().m_41777_());
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public ItemStack getInternal() {
        return this.internal;
    }

    @Override
    public IItemStack modify(Consumer<ItemStack> stackModifier) {
        stackModifier.accept(this.getInternal());
        return this;
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStack thatStack = ((MCItemStack)o).getInternal();
        ItemStack thisStack = this.getInternal();
        if (thisStack.m_41619_()) {
            return thatStack.m_41619_();
        }
        if (thisStack.m_41613_() != thatStack.m_41613_()) {
            return false;
        }
        if (!Objects.equals(thisStack.m_41720_(), thatStack.m_41720_())) {
            return false;
        }
        if (!Objects.equals(thisStack.m_41783_(), thatStack.m_41783_())) {
            return false;
        }
        return thisStack.areCapsCompatible((CapabilityProvider)thatStack);
    }

    public int hashCode() {
        return Objects.hash(this.getInternal().m_41613_(), this.getInternal().m_41720_(), this.getInternal().m_41783_());
    }
}

