/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.loot.modifier;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.loot.modifier.ILootModifier;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.crafttweaker.natives.item.ExpandItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.loot.modifier.CommonLootModifiers")
@Document(value="vanilla/api/loot/modifier/CommonLootModifiers")
public final class CommonLootModifiers {
    private static final ILootModifier LOOT_CLEARING_MODIFIER = (loot, context) -> new ArrayList();

    @ZenCodeType.Method
    public static ILootModifier add(IItemStack stack) {
        return stack.isEmpty() ? ILootModifier.DEFAULT : CommonLootModifiers.modifying((loot, context) -> loot.add(stack.copy()));
    }

    @ZenCodeType.Method
    public static ILootModifier addAll(IItemStack ... stacks) {
        List<IItemStack> stacksToAdd = CommonLootModifiers.filterEmpty(Arrays.stream(stacks)).toList();
        return CommonLootModifiers.modifying((loot, context) -> stacksToAdd.stream().map(IItemStack::copy).forEach(loot::add));
    }

    @ZenCodeType.Method
    public static ILootModifier addWithChance(Percentaged<IItemStack> stack) {
        return CommonLootModifiers.isInvalidChance(stack) ? ILootModifier.DEFAULT : CommonLootModifiers.modifying((loot, context) -> CommonLootModifiers.chance(context.m_78933_(), stack).ifPresent(loot::add));
    }

    @SafeVarargs
    @ZenCodeType.Method
    public static ILootModifier addAllWithChance(Percentaged<IItemStack> ... stacks) {
        return CommonLootModifiers.chaining(Arrays.stream(stacks).map(CommonLootModifiers::addWithChance));
    }

    @ZenCodeType.Method
    public static ILootModifier addWithOreDropsBonus(Enchantment enchantment, IItemStack stack) {
        return CommonLootModifiers.withBonus(stack, enchantment, DropsFormula.ORE_DROPS);
    }

    @ZenCodeType.Method
    public static ILootModifier addWithBinomialBonus(Enchantment enchantment, int extra, float p, IItemStack stack) {
        return CommonLootModifiers.withBonus(stack, enchantment, DropsFormula.binomial(extra, p));
    }

    @ZenCodeType.Method
    public static ILootModifier addWithUniformBonus(Enchantment enchantment, int multiplier, IItemStack stack) {
        return CommonLootModifiers.withBonus(stack, enchantment, DropsFormula.uniform(multiplier));
    }

    @ZenCodeType.Method
    public static ILootModifier addAllWithOreDropsBonus(Enchantment enchantment, IItemStack ... stacks) {
        return CommonLootModifiers.chaining(CommonLootModifiers.filterEmpty(Arrays.stream(stacks)).map(it -> CommonLootModifiers.addWithOreDropsBonus(enchantment, it)));
    }

    @ZenCodeType.Method
    public static ILootModifier addAllWithBinomialBonus(Enchantment enchantment, int extra, float p, IItemStack ... stacks) {
        return CommonLootModifiers.chaining(CommonLootModifiers.filterEmpty(Arrays.stream(stacks)).map(it -> CommonLootModifiers.addWithBinomialBonus(enchantment, extra, p, it)));
    }

    @ZenCodeType.Method
    public static ILootModifier addAllWithUniformBonus(Enchantment enchantment, int multiplier, IItemStack ... stacks) {
        return CommonLootModifiers.chaining(CommonLootModifiers.filterEmpty(Arrays.stream(stacks)).map(it -> CommonLootModifiers.addWithUniformBonus(enchantment, multiplier, it)));
    }

    @ZenCodeType.Method
    public static ILootModifier addWithRandomAmount(IItemStack stack, int min, int max) {
        return stack.isEmpty() || max < min ? ILootModifier.DEFAULT : CommonLootModifiers.modifying((loot, context) -> loot.add(stack.copy().setAmount(CommonLootModifiers.boundedRandom(context, min, max))));
    }

    @ZenCodeType.Method
    public static ILootModifier replaceWith(IIngredient target, IItemStack replacement) {
        return CommonLootModifiers.streaming((loot, context) -> CommonLootModifiers.replacing(loot, target, replacement));
    }

    @ZenCodeType.Method
    public static ILootModifier replaceAllWith(Map<IIngredient, IItemStack> replacementMap) {
        return CommonLootModifiers.chaining(replacementMap.entrySet().stream().map(it -> CommonLootModifiers.replaceWith((IIngredient)it.getKey(), (IItemStack)it.getValue())));
    }

    @ZenCodeType.Method
    public static ILootModifier replaceStackWith(IItemStack target, IItemStack replacement) {
        return CommonLootModifiers.streaming((loot, context) -> CommonLootModifiers.replacingExactly(loot, target, replacement));
    }

    @ZenCodeType.Method
    public static ILootModifier replaceAllStacksWith(Map<IItemStack, IItemStack> replacementMap) {
        return CommonLootModifiers.chaining(replacementMap.entrySet().stream().map(it -> CommonLootModifiers.replaceStackWith((IItemStack)it.getKey(), (IItemStack)it.getValue())));
    }

    @ZenCodeType.Method
    public static ILootModifier remove(IIngredient target) {
        return CommonLootModifiers.replaceWith(target, ExpandItemStack.asIItemStack(ItemStack.f_41583_));
    }

    @ZenCodeType.Method
    public static ILootModifier removeAll(IIngredient ... targets) {
        return CommonLootModifiers.chaining(Arrays.stream(targets).map(CommonLootModifiers::remove));
    }

    @ZenCodeType.Method
    public static ILootModifier clearLoot() {
        return LOOT_CLEARING_MODIFIER;
    }

    @ZenCodeType.Method
    public static ILootModifier chaining(ILootModifier ... modifiers) {
        return CommonLootModifiers.chaining(Arrays.stream(modifiers));
    }

    @ZenCodeType.Method
    public static ILootModifier clearing(ILootModifier ... modifiers) {
        return CommonLootModifiers.chaining(Stream.concat(Stream.of(CommonLootModifiers.clearLoot()), Arrays.stream(modifiers)));
    }

    private static ILootModifier modifying(BiConsumer<List<IItemStack>, LootContext> consumer) {
        return (loot, context) -> (List)Util.m_137469_((Object)loot, it -> consumer.accept((List<IItemStack>)it, context));
    }

    private static ILootModifier streaming(BiFunction<Stream<IItemStack>, LootContext, Stream<IItemStack>> consumer) {
        return (loot, context) -> ((Stream)consumer.apply(loot.stream(), context)).collect(Collectors.toList());
    }

    private static ILootModifier chaining(Stream<ILootModifier> chain) {
        return chain.reduce(ILootModifier.DEFAULT, (first, second) -> (loot, context) -> second.modify(first.modify(loot, context), context));
    }

    private static Stream<IItemStack> filterEmpty(Stream<IItemStack> stream) {
        return stream.filter(it -> !it.isEmpty());
    }

    private static Stream<IItemStack> replacing(Stream<IItemStack> stream, IIngredient from, IItemStack to) {
        return CommonLootModifiers.filterEmpty(stream.map(it -> from.matches((IItemStack)it) ? to.copy() : it));
    }

    private static Stream<IItemStack> replacingExactly(Stream<IItemStack> stream, IItemStack from, IItemStack to) {
        return stream.flatMap(it -> CommonLootModifiers.filterEmpty((from.matches((IItemStack)it) ? CommonLootModifiers.replacingExactly(it, from, to) : Collections.singleton(it)).stream()));
    }

    private static List<IItemStack> replacingExactly(IItemStack original, IItemStack from, IItemStack to) {
        return List.of(to.copy().setAmount(original.getAmount() / from.getAmount()), original.copy().setAmount(original.getAmount() % from.getAmount()));
    }

    private static ILootModifier withBonus(IItemStack drop, Enchantment enchantment, DropsFormula formula) {
        return drop.isEmpty() ? ILootModifier.DEFAULT : CommonLootModifiers.modifying((loot, context) -> loot.add(CommonLootModifiers.applyWithBonus(drop.copy(), enchantment, context, formula)));
    }

    private static IItemStack applyWithBonus(IItemStack original, Enchantment enchantment, LootContext context, DropsFormula formula) {
        return CommonLootModifiers.ifTool(original, context, (IItemStack tool) -> CommonLootModifiers.withLevel(tool, enchantment, level -> original.setAmount(formula.apply(original.getAmount(), level, context.m_78933_()))));
    }

    private static IItemStack ifTool(IItemStack original, LootContext context, Function<IItemStack, IItemStack> toolConsumer) {
        return CommonLootModifiers.ifTool(original, (IItemStack)null, toolConsumer);
    }

    private static IItemStack ifTool(IItemStack original, IItemStack tool, Function<IItemStack, IItemStack> toolConsumer) {
        return tool != null && tool.getInternal() != null && !tool.isEmpty() ? toolConsumer.apply(tool) : original;
    }

    private static IItemStack withLevel(IItemStack tool, Enchantment enchantment, IntFunction<IItemStack> levelUser) {
        return levelUser.apply(EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)tool.getInternal()));
    }

    private static boolean isInvalidChance(Percentaged<IItemStack> stack) {
        return stack.getData().isEmpty() || stack.getPercentage() <= 0.0;
    }

    private static Optional<IItemStack> chance(Random random, Percentaged<IItemStack> stack) {
        return random.nextDouble() <= stack.getPercentage() ? Optional.of(stack.getData().copy()) : Optional.empty();
    }

    private static int boundedRandom(LootContext context, int min, int max) {
        return context.m_78933_().nextInt(max - min) + min;
    }

    private static interface DropsFormula {
        public static final DropsFormula ORE_DROPS = (amount, level, random) -> level <= 0 ? amount : amount * Math.max(0, random.nextInt(level + 2) - 1) + 1;

        public static DropsFormula binomial(int extra, float p) {
            return (amount, level, random) -> amount + IntStream.range(0, level + extra).filter(ignore -> random.nextFloat() < p).map(it -> 1).sum();
        }

        public static DropsFormula uniform(int multiplier) {
            return (amount, level, random) -> amount + random.nextInt(multiplier * level + 1);
        }

        public int apply(int var1, int var2, Random var3);
    }
}

