/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.util;

import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.platform.Services;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class HandleUtil {
    private static final MethodHandles.Lookup LOOKUP = HandleUtil.findLookup();

    private HandleUtil() {
    }

    public static MethodHandle linkMethod(Class<?> type, String methodName, Class<?> returnType, Class<?> ... arguments) {
        try {
            Method target = Services.PLATFORM.findMethod(type, methodName, returnType, arguments);
            return LOOKUP.unreflect(target);
        }
        catch (IllegalAccessException e) {
            throw new UnableToLinkHandleException("Unable to access method " + StringUtil.quoteAndEscape(methodName), e);
        }
    }

    public static VarHandle linkField(Class<?> owner, String fieldName, String fieldDescription) {
        try {
            Field target = Services.PLATFORM.findField(owner, fieldName, fieldDescription);
            return LOOKUP.unreflectVarHandle(target);
        }
        catch (IllegalAccessException e) {
            throw new UnableToLinkHandleException("Unable to access field " + StringUtil.quoteAndEscape(fieldName), e);
        }
    }

    public static <R> R invoke(MethodHandleInvoker<R> invoker) {
        try {
            return invoker.invoke();
        }
        catch (WrongMethodTypeException e) {
            throw new FailedInvocationException("Unable to invoke target method handle: check your arguments", e);
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException("Invoked method threw an exception", throwable);
        }
    }

    public static void invokeVoid(MethodHandleVoidInvoker invoker) {
        try {
            invoker.invoke();
        }
        catch (WrongMethodTypeException e) {
            throw new FailedInvocationException("Unable to invoke target method handle: check your arguments", e);
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException("Invoked method threw an exception", throwable);
        }
    }

    private static MethodHandles.Lookup findLookup() {
        try {
            Field[] declaredFields;
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            Object unsafe = unsafeField.get(null);
            Method getObject = unsafeClass.getDeclaredMethod("getObject", Object.class, Long.TYPE);
            Method staticFieldBase = unsafeClass.getDeclaredMethod("staticFieldBase", Field.class);
            Method staticFieldOffset = unsafeClass.getDeclaredMethod("staticFieldOffset", Field.class);
            Class<MethodHandles.Lookup> methodHandlesLookupClass = MethodHandles.Lookup.class;
            for (Field declaredField : declaredFields = methodHandlesLookupClass.getDeclaredFields()) {
                if (declaredField.getType() != MethodHandles.Lookup.class) continue;
                Object base = staticFieldBase.invoke(unsafe, declaredField);
                long offset = (Long)staticFieldOffset.invoke(unsafe, declaredField);
                MethodHandles.Lookup lookup = (MethodHandles.Lookup)getObject.invoke(unsafe, base, offset);
                if (lookup.lookupModes() != 127) continue;
                return lookup;
            }
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Unable to find lookup", e);
        }
        throw new IllegalStateException("Unable to find lookup");
    }

    public static final class UnableToLinkHandleException
    extends RuntimeException {
        public UnableToLinkHandleException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface MethodHandleInvoker<R> {
        public R invoke() throws Throwable;
    }

    public static final class FailedInvocationException
    extends RuntimeException {
        private FailedInvocationException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface MethodHandleVoidInvoker {
        public void invoke() throws Throwable;
    }
}

