/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type.script;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.api.zencode.IScriptLoadSource;
import com.blamejared.crafttweaker.api.zencode.IScriptLoader;
import com.blamejared.crafttweaker.api.zencode.scriptrun.ScriptRunConfiguration;
import com.blamejared.crafttweaker.platform.Services;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public final class ScriptCommands {
    private ScriptCommands() {
    }

    public static void registerCommands(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("log", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.log"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandUtilities.open((Player)player, Services.PLATFORM.getRelativePathFromGameDirectory("logs/crafttweaker.log"));
            return 1;
        }));
        handler.registerRootCommand("scripts", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.script"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandUtilities.open((Player)player, Services.PLATFORM.getRelativePathFromGameDirectory("./scripts"));
            return 1;
        }));
        handler.registerRootCommand("syntax", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.syntax"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CraftTweakerAPI.getRegistry().getAllLoaders().stream().peek(loader -> CommandUtilities.send((Component)new TranslatableComponent("crafttweaker.script.load.start", new Object[]{CommandUtilities.makeNoticeable(loader.name())}), (Player)player)).map(it -> new ScriptRunConfiguration((IScriptLoader)it, IScriptLoadSource.find(CraftTweakerConstants.RELOAD_LISTENER_SOURCE_ID), ScriptRunConfiguration.RunKind.SYNTAX_CHECK)).map(it -> CraftTweakerAPI.getScriptRunManager().createScriptRun((ScriptRunConfiguration)it)).forEach(it -> {
                try {
                    it.execute();
                    CommandUtilities.send((Component)new TranslatableComponent("crafttweaker.script.load.end.noerror"), (Player)player);
                }
                catch (Throwable e) {
                    CraftTweakerAPI.LOGGER.error("Unable to check for syntax due to an error", e);
                    CommandUtilities.send((Component)new TranslatableComponent("crafttweaker.script.load.end.error"), (Player)player);
                }
            });
            return 1;
        }));
    }
}

