/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.network;

import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.impl.network.message.ClientMessages;
import com.blamejared.crafttweaker.impl.network.message.IMessage;
import com.blamejared.crafttweaker.platform.Services;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler {
    public static SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)CraftTweakerConstants.rl("main"), Services.NETWORK::getNetworkVersion, Services.NETWORK.getNetworkVersion()::equals, Services.NETWORK.getNetworkVersion()::equals);
    private static int ID = 0;

    public static void init() {
        for (ClientMessages msg : ClientMessages.values()) {
            PacketHandler.registerMessage(msg.getMessageClass(), msg.getMessageFactory(), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        }
    }

    private static <MSG extends IMessage<MSG>> void registerMessage(Class<MSG> messageType, Function<FriendlyByteBuf, MSG> decoder, Optional<NetworkDirection> direction) {
        PacketHandler.registerMessage(messageType, decoder, (messageCopy, contextSupplier) -> PacketHandler.andHandling(contextSupplier, messageCopy::handle), direction);
    }

    private static <MSG extends IMessage<MSG>> void registerMessage(Class<MSG> messageType, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer, Optional<NetworkDirection> direction) {
        CHANNEL.registerMessage(ID++, messageType, IMessage::serialize, decoder, messageConsumer, direction);
    }

    private static void andHandling(Supplier<NetworkEvent.Context> contextSupplier, Runnable enqueuedWork) {
        contextSupplier.get().enqueueWork(enqueuedWork);
        contextSupplier.get().setPacketHandled(true);
    }
}

