/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.registry.zencode;

import com.blamejared.crafttweaker.api.command.type.IBracketDumperInfo;
import com.blamejared.crafttweaker.api.plugin.IBracketParserRegistrationHandler;
import com.blamejared.crafttweaker.api.zencode.IScriptLoader;
import com.blamejared.crafttweaker.impl.registry.zencode.BracketDumperInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openzen.zenscript.parser.BracketExpressionParser;

public final class BracketResolverRegistry {
    private final Map<IScriptLoader, BracketData> brackets = new HashMap<IScriptLoader, BracketData>();

    public void registerBracket(IScriptLoader loader, String name, BracketExpressionParser bracketParser, IBracketParserRegistrationHandler.DumperData dumperData) {
        BracketData data = this.brackets.computeIfAbsent(loader, it -> {
            throw new IllegalStateException("No data for loader " + loader + ": this cannot happen");
        });
        Map<String, BracketHandle> loaderBrackets = data.brackets();
        if (loaderBrackets.containsKey(name)) {
            throw new IllegalArgumentException("A bracket handler with the name '" + name + "' is already registered in loader '" + loader + "'");
        }
        BracketDumperInfo info = dumperData == null ? null : new BracketDumperInfo(name, dumperData);
        loaderBrackets.put(name, new BracketHandle(bracketParser, info));
    }

    public void fillLoaderData(Collection<IScriptLoader> loader) {
        loader.forEach(it -> this.brackets.put((IScriptLoader)it, new BracketData()));
    }

    public void applyInheritanceRules() {
        Map<IScriptLoader, BracketData> snapshot = this.createSnapshot();
        Map<IScriptLoader, BracketData> inherited = this.applyInheritanceRules(snapshot);
        this.brackets.clear();
        this.brackets.putAll(inherited);
    }

    public Map<String, IBracketDumperInfo> getBracketDumpers(IScriptLoader loader) {
        return this.brackets.getOrDefault(loader, new BracketData()).brackets().entrySet().stream().filter(it -> ((BracketHandle)it.getValue()).dumperInfo() != null).collect(Collectors.toMap(Map.Entry::getKey, it -> ((BracketHandle)it.getValue()).dumperInfo()));
    }

    public Map<String, BracketExpressionParser> getBracketResolvers(IScriptLoader loader) {
        return this.brackets.getOrDefault(loader, new BracketData()).brackets().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> ((BracketHandle)it.getValue()).parser()));
    }

    private Map<IScriptLoader, BracketData> createSnapshot() {
        return this.brackets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> new BracketData(new HashMap<String, BracketHandle>(((BracketData)it.getValue()).brackets()))));
    }

    private Map<IScriptLoader, BracketData> applyInheritanceRules(Map<IScriptLoader, BracketData> snapshot) {
        return snapshot.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> this.applyInheritanceRules((IScriptLoader)it.getKey(), snapshot)));
    }

    private BracketData applyInheritanceRules(IScriptLoader loader, Map<IScriptLoader, BracketData> snapshot) {
        HashMap<String, BracketHandle> inheritedData = new HashMap<String, BracketHandle>();
        Collection<Map<String, BracketHandle>> inheritanceData = this.computeInheritanceData(loader, snapshot);
        inheritanceData.forEach(it -> {
            try {
                this.tryMerge((Map<String, BracketHandle>)inheritedData, (Map<String, BracketHandle>)it);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to apply inheritance rules for " + loader.name(), e);
            }
        });
        return new BracketData(inheritedData);
    }

    private Collection<Map<String, BracketHandle>> computeInheritanceData(IScriptLoader loader, Map<IScriptLoader, BracketData> snapshot) {
        return Stream.concat(loader.allInheritedLoaders().stream(), Stream.of(loader)).map(snapshot::get).filter(Objects::nonNull).map(BracketData::brackets).toList();
    }

    private void tryMerge(Map<String, BracketHandle> loaderData, Map<String, BracketHandle> inheritedData) {
        inheritedData.forEach((name, handle) -> {
            if (loaderData.containsKey(name)) {
                throw new IllegalStateException("A bracket handler with the name " + name + " is already registered");
            }
            loaderData.put((String)name, (BracketHandle)handle);
        });
    }

    private record BracketData(Map<String, BracketHandle> brackets) {
        BracketData() {
            this(new HashMap<String, BracketHandle>());
        }
    }

    private record BracketHandle(BracketExpressionParser parser, IBracketDumperInfo dumperInfo) {
    }
}

