/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.entity.type.player;

import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker.platform.helper.inventory.IInventoryWrapper;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.util.OptionalInt;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/entity/type/player/Player")
@NativeTypeRegistration(value=Player.class, zenCodeName="crafttweaker.api.entity.type.player.Player")
public class ExpandPlayer {
    @ZenCodeType.Method
    @ZenCodeType.Getter(value="abilities")
    public static Abilities getAbilities(Player internal) {
        return internal.m_150110_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isSecondaryUseActive")
    public static boolean isSecondaryUseActive(Player internal) {
        return internal.m_36341_();
    }

    @ZenCodeType.Method
    public static void playNotifySound(Player internal, SoundEvent event, SoundSource source, float volume, float pitch) {
        internal.m_6330_(event, source, volume, pitch);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="score")
    public static int getScore(Player internal) {
        return internal.m_36344_();
    }

    @ZenCodeType.Method
    public static void setScore(Player internal, int score) {
        internal.m_36397_(score);
    }

    @ZenCodeType.Method
    public static void increaseScore(Player internal, int score) {
        internal.m_36401_(score);
    }

    @ZenCodeType.Method
    public static @ZenCodeType.Nullable ItemEntity drop(Player internal, ItemStack stack, boolean traceItem) {
        return internal.m_36176_(stack, traceItem);
    }

    @ZenCodeType.Method
    public static float getDestroySpeed(Player internal, BlockState state) {
        return internal.m_36281_(state);
    }

    @ZenCodeType.Method
    public static boolean hasCorrectToolForDrops(Player internal, BlockState state) {
        return internal.m_36298_(state);
    }

    @ZenCodeType.Method
    public static boolean canHarmPlayer(Player internal, Player player) {
        return internal.m_7099_(player);
    }

    @ZenCodeType.Method
    public static void attack(Player internal, Entity entity) {
        internal.m_5706_(entity);
    }

    @ZenCodeType.Method
    public static void disableShield(Player internal, boolean usingAxe) {
        internal.m_36384_(usingAxe);
    }

    @ZenCodeType.Method
    public static void crit(Player internal, Entity entity) {
        internal.m_5704_(entity);
    }

    @ZenCodeType.Method
    public static void magicCrit(Player internal, Entity entity) {
        internal.m_5700_(entity);
    }

    @ZenCodeType.Method
    public static void sweepAttack(Player internal) {
        internal.m_36346_();
    }

    @ZenCodeType.Method
    public static void respawn(Player internal) {
        internal.m_7583_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isLocalPlayer")
    public static boolean isLocalPlayer(Player internal) {
        return internal.m_7578_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="inventory")
    public static Inventory getInventory(Player internal) {
        return internal.m_150109_();
    }

    @ZenCodeType.Method
    public static void stopSleeping(Player internal) {
        internal.m_5796_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isSleepingLongEnough")
    public static boolean isSleepingLongEnough(Player internal) {
        return internal.m_36317_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="sleepTimer")
    public static int getSleepTimer(Player internal) {
        return internal.m_36318_();
    }

    @ZenCodeType.Method
    public static void displayClientMessage(Player internal, Component component, boolean actionBar) {
        internal.m_5661_(component, actionBar);
    }

    @ZenCodeType.Method
    public static void awardStat(Player internal, ResourceLocation stat) {
        internal.m_36220_(stat);
    }

    @ZenCodeType.Method
    public static void awardStat(Player internal, ResourceLocation stat, int amount) {
        internal.m_36222_(stat, amount);
    }

    @ZenCodeType.Method
    public static void jumpFromGround(Player internal) {
        internal.m_6135_();
    }

    @ZenCodeType.Method
    public static void giveExperiencePoints(Player internal, int amount) {
        internal.m_6756_(amount);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="enchantmentSeed")
    public static int getEnchantmentSeed(Player internal) {
        return internal.m_36322_();
    }

    @ZenCodeType.Method
    public static void giveExperienceLevels(Player internal, int levels) {
        internal.m_6749_(levels);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="xpNeededForNextLevel")
    public static int getXpNeededForNextLevel(Player internal) {
        return internal.m_36323_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="experienceLevel")
    public static int getExperienceLevel(Player internal) {
        return internal.f_36078_;
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="experienceLevel")
    public static void setExperienceLevel(Player internal, int level) {
        internal.f_36078_ = level;
    }

    @ZenCodeType.Method
    public static void causeFoodExhaustion(Player internal, float exhaustion) {
        internal.m_36399_(exhaustion);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="foodData")
    public static FoodData getFoodData(Player internal) {
        return internal.m_36324_();
    }

    @ZenCodeType.Method
    public static boolean canEat(Player internal, boolean ignoreHunger) {
        return internal.m_36391_(ignoreHunger);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isHurt")
    public static boolean isHurt(Player internal) {
        return internal.m_36325_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="mayBuild")
    public static boolean mayBuild(Player internal) {
        return internal.m_36326_();
    }

    @ZenCodeType.Method
    public static boolean addItem(Player internal, ItemStack stack) {
        return internal.m_36356_(stack);
    }

    @ZenCodeType.Method
    public static boolean setEntityOnShoulder(Player internal, MapData entityData) {
        return internal.m_36360_(entityData.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isCreative")
    public static boolean isCreative(Player internal) {
        return internal.m_7500_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isReducedDebugInfo")
    public static boolean isReducedDebugInfo(Player internal) {
        return internal.m_36330_();
    }

    @ZenCodeType.Method
    public static void setReducedDebugInfo(Player internal, boolean reducedDebugInfo) {
        internal.m_36393_(reducedDebugInfo);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="mainArm")
    public static HumanoidArm getMainArm(Player internal) {
        return internal.m_5737_();
    }

    @ZenCodeType.Method
    public static void setMainArm(Player internal, HumanoidArm arm) {
        internal.m_36163_(arm);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="shoulderEntityLeft")
    public static MapData getShoulderEntityLeft(Player internal) {
        return new MapData(internal.m_36331_());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="shoulderEntityRight")
    public static MapData getShoulderEntityRight(Player internal) {
        return new MapData(internal.m_36332_());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="currentItemAttackStrengthDelay")
    public static float getCurrentItemAttackStrengthDelay(Player internal) {
        return internal.m_36333_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="cooldowns")
    public static ItemCooldowns getCooldowns(Player internal) {
        return internal.m_36335_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="luck")
    public static float getLuck(Player internal) {
        return internal.m_36336_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="canUseGameMasterBlocks")
    public static boolean canUseGameMasterBlocks(Player internal) {
        return internal.m_36337_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isScoping")
    public static boolean isScoping(Player internal) {
        return internal.m_150108_();
    }

    @ZenCodeType.Method
    public static void give(Player internal, IItemStack stack, @ZenCodeType.OptionalInt(value=-1) int slot) {
        ItemEntity itemEntity;
        if (stack.isEmpty()) {
            return;
        }
        IInventoryWrapper inventory = Services.PLATFORM.getPlayerInventory(internal);
        Level level = internal.f_19853_;
        ItemStack leftOvers = inventory.insertItem(slot, stack.getInternal(), false);
        OptionalInt availableSlot = inventory.getSlotFor(leftOvers);
        while (availableSlot.isPresent() && !leftOvers.m_41619_()) {
            leftOvers = inventory.insertItem(availableSlot.getAsInt(), leftOvers, false);
            availableSlot = inventory.getSlotFor(leftOvers);
        }
        if (leftOvers.m_41619_() || leftOvers.m_41613_() != stack.getInternal().m_41613_()) {
            level.m_6263_(null, internal.m_20185_(), internal.m_20186_(), internal.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((level.f_46441_.nextFloat() - level.f_46441_.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        if (!leftOvers.m_41619_() && !level.m_5776_() && (itemEntity = internal.m_7197_(leftOvers, true, true)) != null) {
            itemEntity.m_32061_();
        }
    }

    @ZenCodeType.Method
    public static void sendMessage(Player internal, Component text) {
        internal.m_6352_(text, CraftTweakerConstants.CRAFTTWEAKER_UUID);
    }
}

