/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.world.biome;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.mixin.common.access.world.biome.AccessBiome;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.blamejared.crafttweaker_annotations.annotations.TaggableElement;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/world/biome/Biome")
@NativeTypeRegistration(value=Biome.class, zenCodeName="crafttweaker.api.world.biome.Biome")
@TaggableElement(value="minecraft:worldgen/biome")
public class ExpandBiome {
    @ZenCodeType.Getter(value="waterColor")
    public static int getWaterFloat(Biome internal) {
        return internal.m_47560_();
    }

    @ZenCodeType.Getter(value="waterFogColor")
    public static int getWaterFogColor(Biome internal) {
        return internal.m_47561_();
    }

    @ZenCodeType.Getter(value="downfall")
    public static float getDownFall(Biome internal) {
        return internal.m_47548_();
    }

    @ZenCodeType.Getter(value="isHumid")
    public static boolean isHumid(Biome internal) {
        return internal.m_47533_();
    }

    @ZenCodeType.Getter(value="biomeCategory")
    public static String getBiomeCategory(Biome internal) {
        return ((AccessBiome)internal).crafttweaker$callGetBiomeCategory().m_47645_().toLowerCase();
    }

    @ZenCodeType.Getter(value="doesRain")
    public static boolean doesRain(Biome internal) {
        return internal.m_47530_() == Biome.Precipitation.RAIN;
    }

    @ZenCodeType.Getter(value="doesSnow")
    public static boolean doesSnow(Biome internal) {
        return internal.m_47530_() == Biome.Precipitation.SNOW;
    }

    @ZenCodeType.Getter(value="rainType")
    public static String getRainType(Biome internal) {
        return internal.m_47530_().m_47731_();
    }

    @ZenCodeType.Method
    public static boolean shouldFreeze(Biome internal, Level world, BlockPos pos) {
        return internal.m_47477_((LevelReader)world, pos);
    }

    @ZenCodeType.Method
    public static boolean shouldFreeze(Biome internal, Level world, BlockPos pos, boolean mustBeAtEdge) {
        return internal.m_47480_((LevelReader)world, pos, mustBeAtEdge);
    }

    @ZenCodeType.Method
    public static boolean shouldSnow(Biome internal, Level world, BlockPos pos) {
        return internal.m_47519_((LevelReader)world, pos);
    }

    @ZenCodeType.Getter(value="registryName")
    public static ResourceLocation getRegistryName(Biome internal) {
        return Services.REGISTRY.getRegistryKey(internal);
    }

    @ZenCodeType.Getter(value="commandString")
    public static String getCommandString(Biome internal) {
        return "<biome:" + ExpandBiome.getRegistryName(internal) + ">";
    }
}

