/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.vaulthunters.jewelsorting.ae2.mixin;

import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.stacks.AEKey;
import appeng.client.gui.me.common.Repo;
import appeng.menu.me.common.GridInventoryEntry;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.data.InscriptionData;
import java.util.Comparator;
import lv.id.bonne.vaulthunters.jewelsorting.VaultJewelSorting;
import lv.id.bonne.vaulthunters.jewelsorting.utils.CustomVaultGearData;
import lv.id.bonne.vaulthunters.jewelsorting.utils.SortingHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Repo.class})
public abstract class MixinRepo {
    @Inject(method={"getComparator"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    public final void comparator(SortOrder sortOrder, SortDir sortDir, CallbackInfoReturnable<Comparator<GridInventoryEntry>> cir) {
        if (Screen.m_96638_()) {
            return;
        }
        boolean ascending = sortDir == SortDir.ASCENDING;
        cir.setReturnValue(((Comparator)cir.getReturnValue()).thenComparing((left, right) -> {
            AEKey leftWhat = left.getWhat();
            AEKey rightWhat = right.getWhat();
            if (leftWhat == null || rightWhat == null) {
                return leftWhat == null ? 1 : -1;
            }
            String leftName = leftWhat.getDisplayName().getString();
            String rightName = rightWhat.getDisplayName().getString();
            if (!leftWhat.getModId().equals(rightWhat.getModId())) {
                return String.CASE_INSENSITIVE_ORDER.compare(leftWhat.getModId(), rightWhat.getModId());
            }
            int registryOrder = SortingHelper.compareRegistryNames(leftWhat.getId(), rightWhat.getId(), ascending);
            if (registryOrder != 0 || !MixinRepo.isSortable(leftWhat.getId())) {
                return registryOrder;
            }
            if (leftWhat.getId() == ModItems.JEWEL.getRegistryName()) {
                CompoundTag leftTag = leftWhat.toTag().m_128469_("tag");
                CompoundTag rightTag = rightWhat.toTag().m_128469_("tag");
                if (!(leftTag.m_128441_("clientCache") && leftTag.m_128469_("clientCache").m_128441_("extra_attribute_index") && leftTag.m_128469_("clientCache").m_128441_("extra_attribute_value") && leftTag.m_128469_("clientCache").m_128441_("extra_gear_level") && leftTag.m_128469_("clientCache").m_128441_("extra_jewel_size") && rightTag.m_128441_("clientCache") && rightTag.m_128469_("clientCache").m_128441_("extra_attribute_index") && rightTag.m_128469_("clientCache").m_128441_("extra_attribute_value") && rightTag.m_128469_("clientCache").m_128441_("extra_gear_level") && rightTag.m_128469_("clientCache").m_128441_("extra_jewel_size"))) {
                    VaultGearData leftData = CustomVaultGearData.read(leftTag);
                    VaultGearData rightData = CustomVaultGearData.read(rightTag);
                    return switch (sortOrder) {
                        default -> throw new IncompatibleClassChangeError();
                        case SortOrder.NAME -> SortingHelper.compareJewels(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getJewelSortingByName(), ascending);
                        case SortOrder.AMOUNT -> SortingHelper.compareJewels(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getJewelSortingByAmount(), ascending);
                        case SortOrder.MOD -> SortingHelper.compareJewels(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getJewelSortingByMod(), ascending);
                    };
                }
                return switch (sortOrder) {
                    default -> throw new IncompatibleClassChangeError();
                    case SortOrder.NAME -> SortingHelper.compareJewels(leftName, leftTag.m_128469_("clientCache"), rightName, rightTag.m_128469_("clientCache"), VaultJewelSorting.CONFIGURATION.getJewelSortingByName(), ascending);
                    case SortOrder.AMOUNT -> SortingHelper.compareJewels(leftName, leftTag.m_128469_("clientCache"), rightName, rightTag.m_128469_("clientCache"), VaultJewelSorting.CONFIGURATION.getJewelSortingByAmount(), ascending);
                    case SortOrder.MOD -> SortingHelper.compareJewels(leftName, leftTag.m_128469_("clientCache"), rightName, rightTag.m_128469_("clientCache"), VaultJewelSorting.CONFIGURATION.getJewelSortingByMod(), ascending);
                };
            }
            if (leftWhat.getId() == ModItems.INSCRIPTION.getRegistryName()) {
                InscriptionData leftData = InscriptionData.empty();
                leftData.deserializeNBT(leftWhat.toTag().m_128469_("tag").m_128469_("data"));
                InscriptionData rightData = InscriptionData.empty();
                rightData.deserializeNBT(rightWhat.toTag().m_128469_("tag").m_128469_("data"));
                return switch (sortOrder) {
                    default -> throw new IncompatibleClassChangeError();
                    case SortOrder.NAME -> SortingHelper.compareInscriptions(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getInscriptionSortingByName(), ascending);
                    case SortOrder.AMOUNT -> SortingHelper.compareInscriptions(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getInscriptionSortingByAmount(), ascending);
                    case SortOrder.MOD -> SortingHelper.compareInscriptions(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getInscriptionSortingByMod(), ascending);
                };
            }
            if (leftWhat.getId() == ModItems.VAULT_CRYSTAL.getRegistryName()) {
                CrystalData leftData = CrystalData.empty();
                leftData.deserializeNBT((Tag)leftWhat.toTag().m_128469_("tag").m_128469_("CrystalData"));
                CrystalData rightData = CrystalData.empty();
                rightData.deserializeNBT((Tag)rightWhat.toTag().m_128469_("tag").m_128469_("CrystalData"));
                return switch (sortOrder) {
                    default -> throw new IncompatibleClassChangeError();
                    case SortOrder.NAME -> SortingHelper.compareVaultCrystals(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByName(), ascending);
                    case SortOrder.AMOUNT -> SortingHelper.compareVaultCrystals(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByAmount(), ascending);
                    case SortOrder.MOD -> SortingHelper.compareVaultCrystals(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByMod(), ascending);
                };
            }
            if (leftWhat.getId() == ModItems.TRINKET.getRegistryName()) {
                VaultGearData leftData = CustomVaultGearData.read(leftWhat.toTag().m_128469_("tag"));
                VaultGearData rightData = CustomVaultGearData.read(rightWhat.toTag().m_128469_("tag"));
                return switch (sortOrder) {
                    default -> throw new IncompatibleClassChangeError();
                    case SortOrder.NAME -> SortingHelper.compareTrinkets(leftName, (AttributeGearData)leftData, leftWhat.toTag().m_128469_("tag"), rightName, (AttributeGearData)rightData, rightWhat.toTag().m_128469_("tag"), VaultJewelSorting.CONFIGURATION.getTrinketSortingByName(), ascending);
                    case SortOrder.AMOUNT -> SortingHelper.compareTrinkets(leftName, (AttributeGearData)leftData, leftWhat.toTag().m_128469_("tag"), rightName, (AttributeGearData)rightData, rightWhat.toTag().m_128469_("tag"), VaultJewelSorting.CONFIGURATION.getTrinketSortingByAmount(), ascending);
                    case SortOrder.MOD -> SortingHelper.compareTrinkets(leftName, (AttributeGearData)leftData, leftWhat.toTag().m_128469_("tag"), rightName, (AttributeGearData)rightData, rightWhat.toTag().m_128469_("tag"), VaultJewelSorting.CONFIGURATION.getTrinketSortingByMod(), ascending);
                };
            }
            if (SortingHelper.VAULT_CHARMS.contains(leftWhat.getId())) {
                VaultGearData leftData = CustomVaultGearData.read(leftWhat.toTag().m_128469_("tag"));
                VaultGearData rightData = CustomVaultGearData.read(rightWhat.toTag().m_128469_("tag"));
                return switch (sortOrder) {
                    default -> throw new IncompatibleClassChangeError();
                    case SortOrder.NAME -> SortingHelper.compareCharms(leftName, (AttributeGearData)leftData, leftWhat.toTag().m_128469_("tag"), rightName, (AttributeGearData)rightData, rightWhat.toTag().m_128469_("tag"), VaultJewelSorting.CONFIGURATION.getCharmSortingByName(), ascending);
                    case SortOrder.AMOUNT -> SortingHelper.compareCharms(leftName, (AttributeGearData)leftData, leftWhat.toTag().m_128469_("tag"), rightName, (AttributeGearData)rightData, rightWhat.toTag().m_128469_("tag"), VaultJewelSorting.CONFIGURATION.getCharmSortingByAmount(), ascending);
                    case SortOrder.MOD -> SortingHelper.compareCharms(leftName, (AttributeGearData)leftData, leftWhat.toTag().m_128469_("tag"), rightName, (AttributeGearData)rightData, rightWhat.toTag().m_128469_("tag"), VaultJewelSorting.CONFIGURATION.getCharmSortingByMod(), ascending);
                };
            }
            if (leftWhat.getId() == ModItems.VAULT_DOLL.getRegistryName()) {
                return switch (sortOrder) {
                    default -> throw new IncompatibleClassChangeError();
                    case SortOrder.NAME -> SortingHelper.compareVaultDolls(leftName, leftWhat.toTag().m_128469_("tag"), rightName, rightWhat.toTag().m_128469_("tag"), VaultJewelSorting.CONFIGURATION.getDollSortingByName(), ascending);
                    case SortOrder.AMOUNT -> SortingHelper.compareVaultDolls(leftName, leftWhat.toTag().m_128469_("tag"), rightName, rightWhat.toTag().m_128469_("tag"), VaultJewelSorting.CONFIGURATION.getDollSortingByAmount(), ascending);
                    case SortOrder.MOD -> SortingHelper.compareVaultDolls(leftName, leftWhat.toTag().m_128469_("tag"), rightName, rightWhat.toTag().m_128469_("tag"), VaultJewelSorting.CONFIGURATION.getDollSortingByMod(), ascending);
                };
            }
            VaultGearData leftData = CustomVaultGearData.read(leftWhat.toTag().m_128469_("tag"));
            VaultGearData rightData = CustomVaultGearData.read(rightWhat.toTag().m_128469_("tag"));
            return switch (sortOrder) {
                default -> throw new IncompatibleClassChangeError();
                case SortOrder.NAME -> SortingHelper.compareVaultGear(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getGearSortingByName(), ascending);
                case SortOrder.AMOUNT -> SortingHelper.compareVaultGear(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getGearSortingByAmount(), ascending);
                case SortOrder.MOD -> SortingHelper.compareVaultGear(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getGearSortingByMod(), ascending);
            };
        }));
    }

    @Unique
    private static boolean isSortable(ResourceLocation id) {
        return id.equals((Object)ModItems.JEWEL.getRegistryName()) || id.equals((Object)ModItems.INSCRIPTION.getRegistryName()) || id.equals((Object)ModItems.VAULT_CRYSTAL.getRegistryName()) || id.equals((Object)ModItems.TRINKET.getRegistryName()) || SortingHelper.VAULT_CHARMS.contains(id) || SortingHelper.VAULT_GEAR_SET.contains(id) || id.equals((Object)ModItems.VAULT_DOLL.getRegistryName());
    }
}

