/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.vaulthunters.jewelsorting.quark.mixin;

import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.item.InscriptionItem;
import iskallia.vault.item.VaultDollItem;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.VaultCrystalItem;
import iskallia.vault.item.data.InscriptionData;
import iskallia.vault.item.gear.CharmItem;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.item.tool.JewelItem;
import iskallia.vault.item.tool.ToolItem;
import lv.id.bonne.vaulthunters.jewelsorting.VaultJewelSorting;
import lv.id.bonne.vaulthunters.jewelsorting.utils.SortingHelper;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.quark.base.handler.SortingHandler;

@Mixin(value={SortingHandler.class})
public class MixinSortingHandler {
    @Inject(method={"stackCompare(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)I"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private static void stackCompare(ItemStack stack1, ItemStack stack2, CallbackInfoReturnable<Integer> callbackInfoReturnable) {
        if (!(stack1 != stack2 && MixinSortingHandler.hasCustomComparison(stack1) && MixinSortingHandler.hasCustomComparison(stack2) && stack1.m_41720_().equals(stack2.m_41720_()))) {
            return;
        }
        if (stack1.m_41720_() instanceof JewelItem && stack2.m_41720_() instanceof JewelItem) {
            if (!VaultJewelSorting.CONFIGURATION.getJewelSortingByName().isEmpty()) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareJewels(stack1.m_41611_().getString(), VaultGearData.read((ItemStack)stack1), stack2.m_41611_().getString(), VaultGearData.read((ItemStack)stack2), VaultJewelSorting.CONFIGURATION.getJewelSortingByName(), true));
                callbackInfoReturnable.cancel();
            }
        } else if (!(stack1.m_41720_() instanceof ToolItem) || !(stack2.m_41720_() instanceof ToolItem)) {
            if (stack1.m_41720_() instanceof VaultGearItem && stack2.m_41720_() instanceof VaultGearItem) {
                if (!VaultJewelSorting.CONFIGURATION.getGearSortingByName().isEmpty()) {
                    callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareVaultGear(stack1.m_41611_().getString(), VaultGearData.read((ItemStack)stack1), stack2.m_41611_().getString(), VaultGearData.read((ItemStack)stack2), VaultJewelSorting.CONFIGURATION.getGearSortingByName(), true));
                    callbackInfoReturnable.cancel();
                }
            } else if (stack1.m_41720_() instanceof InscriptionItem && stack2.m_41720_() instanceof InscriptionItem) {
                if (!VaultJewelSorting.CONFIGURATION.getInscriptionSortingByName().isEmpty()) {
                    callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareInscriptions(stack1.m_41611_().getString(), InscriptionData.from((ItemStack)stack1), stack2.m_41611_().getString(), InscriptionData.from((ItemStack)stack2), VaultJewelSorting.CONFIGURATION.getInscriptionSortingByName(), true));
                    callbackInfoReturnable.cancel();
                }
            } else if (stack1.m_41720_() instanceof VaultCrystalItem && stack2.m_41720_() instanceof VaultCrystalItem) {
                if (!VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByName().isEmpty()) {
                    callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareVaultCrystals(stack1.m_41611_().getString(), CrystalData.read((ItemStack)stack1), stack2.m_41611_().getString(), CrystalData.read((ItemStack)stack2), VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByName(), true));
                    callbackInfoReturnable.cancel();
                }
            } else if (stack1.m_41720_() instanceof TrinketItem && stack2.m_41720_() instanceof TrinketItem) {
                if (!VaultJewelSorting.CONFIGURATION.getTrinketSortingByName().isEmpty()) {
                    callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareTrinkets(stack1.m_41611_().getString(), AttributeGearData.read((ItemStack)stack1), stack1.m_41783_(), stack2.m_41611_().getString(), AttributeGearData.read((ItemStack)stack2), stack2.m_41783_(), VaultJewelSorting.CONFIGURATION.getTrinketSortingByName(), true));
                    callbackInfoReturnable.cancel();
                }
            } else if (stack1.m_41720_() instanceof CharmItem && stack2.m_41720_() instanceof CharmItem) {
                if (!VaultJewelSorting.CONFIGURATION.getCharmSortingByName().isEmpty()) {
                    callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareCharms(stack1.m_41611_().getString(), AttributeGearData.read((ItemStack)stack1), stack1.m_41783_(), stack2.m_41611_().getString(), AttributeGearData.read((ItemStack)stack2), stack2.m_41783_(), VaultJewelSorting.CONFIGURATION.getCharmSortingByName(), true));
                    callbackInfoReturnable.cancel();
                }
            } else if (stack1.m_41720_() instanceof VaultDollItem && stack2.m_41720_() instanceof VaultDollItem && !VaultJewelSorting.CONFIGURATION.getDollSortingByName().isEmpty()) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareVaultDolls(stack1.m_41611_().getString(), stack1.m_41783_(), stack2.m_41611_().getString(), stack2.m_41783_(), VaultJewelSorting.CONFIGURATION.getDollSortingByName(), true));
                callbackInfoReturnable.cancel();
            }
        }
    }

    @Unique
    private static boolean hasCustomComparison(ItemStack stack) {
        return stack.m_41720_() instanceof VaultGearItem || stack.m_41720_() instanceof InscriptionItem || stack.m_41720_() instanceof VaultCrystalItem || stack.m_41720_() instanceof TrinketItem || stack.m_41720_() instanceof VaultDollItem;
    }
}

