/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.vaulthunters.jewelsorting.storagenetwork.mixin;

import com.lothrazar.storagenetwork.api.EnumSortType;
import com.lothrazar.storagenetwork.api.IGuiNetwork;
import com.lothrazar.storagenetwork.gui.NetworkWidget;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.item.InscriptionItem;
import iskallia.vault.item.VaultDollItem;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.VaultCrystalItem;
import iskallia.vault.item.data.InscriptionData;
import iskallia.vault.item.gear.CharmItem;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.item.tool.JewelItem;
import iskallia.vault.item.tool.ToolItem;
import java.util.Comparator;
import lv.id.bonne.vaulthunters.jewelsorting.VaultJewelSorting;
import lv.id.bonne.vaulthunters.jewelsorting.utils.SortingHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(value={NetworkWidget.class}, remap=false)
public class MixinNetworkWidget {
    @Shadow
    @Final
    private IGuiNetwork gui;

    @ModifyArg(method={"sortStackWrappers"}, at=@At(value="INVOKE", target="Ljava/util/Collections;sort(Ljava/util/List;Ljava/util/Comparator;)V"), index=1)
    private Comparator<ItemStack> sortStackWrappersJewelCompare(Comparator<ItemStack> original) {
        return original.thenComparing((first, second) -> {
            if (Screen.m_96638_()) {
                return 0;
            }
            int registryOrder = SortingHelper.compareRegistryNames(first.m_41720_().getRegistryName(), second.m_41720_().getRegistryName(), this.gui.getDownwards());
            if (registryOrder != 0) {
                return registryOrder;
            }
            if (first.m_41720_() instanceof JewelItem && second.m_41720_() instanceof JewelItem) {
                String leftName = first.m_41611_().getString();
                String rightName = second.m_41611_().getString();
                VaultGearData leftData = VaultGearData.read((ItemStack)first);
                VaultGearData rightData = VaultGearData.read((ItemStack)second);
                return switch (this.gui.getSort()) {
                    default -> throw new IncompatibleClassChangeError();
                    case EnumSortType.NAME -> SortingHelper.compareJewels(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getJewelSortingByName(), this.gui.getDownwards());
                    case EnumSortType.AMOUNT -> SortingHelper.compareJewels(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getJewelSortingByAmount(), this.gui.getDownwards());
                    case EnumSortType.MOD -> SortingHelper.compareJewels(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getJewelSortingByMod(), this.gui.getDownwards());
                };
            }
            if (!(first.m_41720_() instanceof ToolItem) || !(second.m_41720_() instanceof ToolItem)) {
                if (first.m_41720_() instanceof VaultGearItem && second.m_41720_() instanceof VaultGearItem) {
                    String leftName = first.m_41611_().getString();
                    String rightName = second.m_41611_().getString();
                    VaultGearData leftData = VaultGearData.read((ItemStack)first);
                    VaultGearData rightData = VaultGearData.read((ItemStack)second);
                    return switch (this.gui.getSort()) {
                        default -> throw new IncompatibleClassChangeError();
                        case EnumSortType.NAME -> SortingHelper.compareVaultGear(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getGearSortingByName(), this.gui.getDownwards());
                        case EnumSortType.AMOUNT -> SortingHelper.compareVaultGear(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getGearSortingByAmount(), this.gui.getDownwards());
                        case EnumSortType.MOD -> SortingHelper.compareVaultGear(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getGearSortingByMod(), this.gui.getDownwards());
                    };
                }
                if (first.m_41720_() instanceof InscriptionItem && second.m_41720_() instanceof InscriptionItem) {
                    String leftName = first.m_41611_().getString();
                    String rightName = second.m_41611_().getString();
                    InscriptionData leftData = InscriptionData.from((ItemStack)first);
                    InscriptionData rightData = InscriptionData.from((ItemStack)second);
                    return switch (this.gui.getSort()) {
                        default -> throw new IncompatibleClassChangeError();
                        case EnumSortType.NAME -> SortingHelper.compareInscriptions(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getInscriptionSortingByName(), true);
                        case EnumSortType.AMOUNT -> SortingHelper.compareInscriptions(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getInscriptionSortingByAmount(), true);
                        case EnumSortType.MOD -> SortingHelper.compareInscriptions(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getInscriptionSortingByMod(), true);
                    };
                }
                if (first.m_41720_() instanceof VaultCrystalItem && second.m_41720_() instanceof VaultCrystalItem) {
                    String leftName = first.m_41611_().getString();
                    String rightName = second.m_41611_().getString();
                    CrystalData leftData = CrystalData.read((ItemStack)first);
                    CrystalData rightData = CrystalData.read((ItemStack)second);
                    return switch (this.gui.getSort()) {
                        default -> throw new IncompatibleClassChangeError();
                        case EnumSortType.NAME -> SortingHelper.compareVaultCrystals(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByName(), true);
                        case EnumSortType.AMOUNT -> SortingHelper.compareVaultCrystals(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByAmount(), true);
                        case EnumSortType.MOD -> SortingHelper.compareVaultCrystals(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByMod(), true);
                    };
                }
                if (first.m_41720_() instanceof TrinketItem && second.m_41720_() instanceof TrinketItem) {
                    return switch (this.gui.getSort()) {
                        default -> throw new IncompatibleClassChangeError();
                        case EnumSortType.NAME -> SortingHelper.compareTrinkets(first.m_41611_().getString(), AttributeGearData.read((ItemStack)first), first.m_41783_(), second.m_41611_().getString(), AttributeGearData.read((ItemStack)second), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getTrinketSortingByName(), true);
                        case EnumSortType.AMOUNT -> SortingHelper.compareTrinkets(first.m_41611_().getString(), AttributeGearData.read((ItemStack)first), first.m_41783_(), second.m_41611_().getString(), AttributeGearData.read((ItemStack)second), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getTrinketSortingByAmount(), true);
                        case EnumSortType.MOD -> SortingHelper.compareTrinkets(first.m_41611_().getString(), AttributeGearData.read((ItemStack)first), first.m_41783_(), second.m_41611_().getString(), AttributeGearData.read((ItemStack)second), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getTrinketSortingByMod(), true);
                    };
                }
                if (first.m_41720_() instanceof CharmItem && second.m_41720_() instanceof CharmItem) {
                    return switch (this.gui.getSort()) {
                        default -> throw new IncompatibleClassChangeError();
                        case EnumSortType.NAME -> SortingHelper.compareCharms(first.m_41611_().getString(), AttributeGearData.read((ItemStack)first), first.m_41783_(), second.m_41611_().getString(), AttributeGearData.read((ItemStack)second), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getCharmSortingByName(), true);
                        case EnumSortType.AMOUNT -> SortingHelper.compareCharms(first.m_41611_().getString(), AttributeGearData.read((ItemStack)first), first.m_41783_(), second.m_41611_().getString(), AttributeGearData.read((ItemStack)second), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getCharmSortingByAmount(), true);
                        case EnumSortType.MOD -> SortingHelper.compareCharms(first.m_41611_().getString(), AttributeGearData.read((ItemStack)first), first.m_41783_(), second.m_41611_().getString(), AttributeGearData.read((ItemStack)second), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getCharmSortingByMod(), true);
                    };
                }
                if (first.m_41720_() instanceof VaultDollItem && second.m_41720_() instanceof VaultDollItem) {
                    return switch (this.gui.getSort()) {
                        default -> throw new IncompatibleClassChangeError();
                        case EnumSortType.NAME -> SortingHelper.compareVaultDolls(first.m_41611_().getString(), first.m_41783_(), second.m_41611_().getString(), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getDollSortingByName(), true);
                        case EnumSortType.AMOUNT -> SortingHelper.compareVaultDolls(first.m_41611_().getString(), first.m_41783_(), second.m_41611_().getString(), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getDollSortingByAmount(), true);
                        case EnumSortType.MOD -> SortingHelper.compareVaultDolls(first.m_41611_().getString(), first.m_41783_(), second.m_41611_().getString(), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getDollSortingByMod(), true);
                    };
                }
            }
            return 0;
        });
    }
}

