/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.vaulthunters.jewelsorting.utils;

import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.init.ModGearAttributes;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lv.id.bonne.vaulthunters.jewelsorting.VaultJewelSorting;
import net.minecraftforge.event.RegistryEvent;

public class AttributeHelper {
    private static final List<VaultGearAttribute<?>> MOD_GEAR_ATTRIBUTE = new ArrayList();
    private static final Set<VaultGearAttribute<?>> FLOAT_ATTRIBUTE = new HashSet();
    private static final Set<VaultGearAttribute<?>> INTEGER_ATTRIBUTE = new HashSet();
    private static final Set<VaultGearAttribute<?>> DOUBLE_ATTRIBUTE = new HashSet();

    public static void registerAttributes(RegistryEvent.Register<VaultGearAttribute<?>> event) {
        MOD_GEAR_ATTRIBUTE.clear();
        MOD_GEAR_ATTRIBUTE.addAll(event.getRegistry().getValues());
    }

    public static void registerAttributes() {
        MOD_GEAR_ATTRIBUTE.clear();
        FLOAT_ATTRIBUTE.clear();
        INTEGER_ATTRIBUTE.clear();
        DOUBLE_ATTRIBUTE.clear();
        for (Field field : ModGearAttributes.class.getDeclaredFields()) {
            try {
                Object fieldObject = field.get(ModGearAttributes.class);
                if (!(fieldObject instanceof VaultGearAttribute)) continue;
                VaultGearAttribute attribute = (VaultGearAttribute)fieldObject;
                MOD_GEAR_ATTRIBUTE.add(attribute);
                if (field.getGenericType().getTypeName().endsWith("<java.lang.Integer>")) {
                    INTEGER_ATTRIBUTE.add(attribute);
                    continue;
                }
                if (field.getGenericType().getTypeName().endsWith("<java.lang.Float>")) {
                    FLOAT_ATTRIBUTE.add(attribute);
                    continue;
                }
                if (!field.getGenericType().getTypeName().endsWith("<java.lang.Double>")) continue;
                DOUBLE_ATTRIBUTE.add(attribute);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static boolean isFloatAttribute(VaultGearAttribute<?> attribute) {
        return attribute != null && FLOAT_ATTRIBUTE.contains(attribute);
    }

    public static boolean isIntegerAttribute(VaultGearAttribute<?> attribute) {
        return attribute != null && INTEGER_ATTRIBUTE.contains(attribute);
    }

    public static boolean isDoubleAttribute(VaultGearAttribute<?> attribute) {
        return attribute != null && DOUBLE_ATTRIBUTE.contains(attribute);
    }

    public static int getAttributeIndex(VaultGearAttribute<?> attribute) {
        return attribute == null ? -1 : MOD_GEAR_ATTRIBUTE.indexOf(attribute);
    }

    public static int getRollIndex(String name) {
        return VaultJewelSorting.CONFIGURATION.getRarityOrder().indexOf(name);
    }
}

