/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.vaulthunters.jewelsorting.utils;

import iskallia.vault.VaultMod;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.GearDataCache;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.data.InscriptionData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lv.id.bonne.vaulthunters.jewelsorting.utils.AttributeHelper;
import lv.id.bonne.vaulthunters.jewelsorting.utils.IExtraGearDataCache;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class SortingHelper {
    public static final String EXTRA_ATTRIBUTE_INDEX = "extra_attribute_index";
    public static final String EXTRA_ATTRIBUTE_VALUE = "extra_attribute_value";
    public static final String EXTRA_JEWEL_SIZE = "extra_jewel_size";
    public static final String EXTRA_GEAR_LEVEL = "extra_gear_level";
    public static final Set<ResourceLocation> VAULT_GEAR_SET = new HashSet<ResourceLocation>();
    public static final Set<ResourceLocation> VAULT_CHARMS = new HashSet<ResourceLocation>();

    public static int compareRegistryNames(ResourceLocation leftReg, ResourceLocation rightReg, boolean ascending) {
        String leftName;
        String string = VAULT_GEAR_SET.contains(leftReg) ? VaultMod.sId((String)"gear") : (leftName = VAULT_CHARMS.contains(leftReg) ? VaultMod.sId((String)"charm") : leftReg.toString());
        String rightName = VAULT_GEAR_SET.contains(rightReg) ? VaultMod.sId((String)"gear") : (VAULT_CHARMS.contains(rightReg) ? VaultMod.sId((String)"charm") : rightReg.toString());
        return ascending ? SortingHelper.compareString(leftName, rightName) : SortingHelper.compareString(rightName, leftName);
    }

    public static int compareJewels(String leftName, VaultGearData leftData, String rightName, VaultGearData rightData, List<JewelOptions> sortingOrder, boolean ascending) {
        ArrayList leftAffixes = new ArrayList();
        leftAffixes.addAll(leftData.getModifiers(VaultGearModifier.AffixType.PREFIX));
        leftAffixes.addAll(leftData.getModifiers(VaultGearModifier.AffixType.SUFFIX));
        ArrayList rightAffixes = new ArrayList();
        rightAffixes.addAll(rightData.getModifiers(VaultGearModifier.AffixType.PREFIX));
        rightAffixes.addAll(rightData.getModifiers(VaultGearModifier.AffixType.SUFFIX));
        int returnValue = 0;
        VaultGearAttribute leftAttribute = leftAffixes.size() == 1 ? ((VaultGearModifier)leftAffixes.get(0)).getAttribute() : null;
        VaultGearAttribute rightAttribute = rightAffixes.size() == 1 ? ((VaultGearModifier)rightAffixes.get(0)).getAttribute() : null;
        int sortingOrderSize = sortingOrder.size();
        for (int i = 0; returnValue == 0 && i < sortingOrderSize; ++i) {
            JewelOptions sortOptions = sortingOrder.get(i);
            returnValue = switch (sortOptions) {
                default -> throw new IncompatibleClassChangeError();
                case JewelOptions.NAME -> SortingHelper.compareString(leftName, rightName);
                case JewelOptions.ATTRIBUTE -> SortingHelper.compareAttribute(leftAttribute, rightAttribute);
                case JewelOptions.ATTRIBUTE_VALUE -> SortingHelper.compareAttributeValue(leftData, leftAttribute, rightData, rightAttribute);
                case JewelOptions.SIZE -> SortingHelper.compareSizeAttribute(leftData, rightData);
                case JewelOptions.ATTRIBUTE_WEIGHT -> SortingHelper.compareAttributeValueWeight(leftData, leftAttribute, rightData, rightAttribute);
                case JewelOptions.LEVEL -> SortingHelper.compareLevel(leftData, rightData);
            };
        }
        return ascending ? returnValue : -returnValue;
    }

    public static int compareJewels(String leftName, GearDataCache leftData, String rightName, GearDataCache rightData, List<JewelOptions> sortingOrder, boolean ascending) {
        int returnValue = 0;
        IExtraGearDataCache leftExtraCache = (IExtraGearDataCache)leftData;
        IExtraGearDataCache rightExtraCache = (IExtraGearDataCache)rightData;
        int sortingOrderSize = sortingOrder.size();
        for (int i = 0; returnValue == 0 && i < sortingOrderSize; ++i) {
            JewelOptions sortOptions = sortingOrder.get(i);
            returnValue = switch (sortOptions) {
                default -> throw new IncompatibleClassChangeError();
                case JewelOptions.NAME -> SortingHelper.compareString(leftName, rightName);
                case JewelOptions.ATTRIBUTE -> SortingHelper.compareIntegerValue(leftExtraCache.getExtraFirstAttributeIndex(), rightExtraCache.getExtraFirstAttributeIndex());
                case JewelOptions.ATTRIBUTE_VALUE -> SortingHelper.compareDoubleValue(leftExtraCache.getExtraFirstAttributeValue(), rightExtraCache.getExtraFirstAttributeValue());
                case JewelOptions.SIZE -> SortingHelper.compareIntegerValue(leftExtraCache.getExtraJewelSize(), rightExtraCache.getExtraJewelSize());
                case JewelOptions.ATTRIBUTE_WEIGHT -> SortingHelper.compareAttributeValueWeight(leftExtraCache, rightExtraCache);
                case JewelOptions.LEVEL -> SortingHelper.compareIntegerValue(leftExtraCache.getExtraGearLevel(), rightExtraCache.getExtraGearLevel());
            };
        }
        return ascending ? returnValue : -returnValue;
    }

    public static int compareJewels(String leftName, CompoundTag leftData, String rightName, CompoundTag rightData, List<JewelOptions> sortingOrder, boolean ascending) {
        int returnValue = 0;
        int sortingOrderSize = sortingOrder.size();
        for (int i = 0; returnValue == 0 && i < sortingOrderSize; ++i) {
            JewelOptions sortOptions = sortingOrder.get(i);
            returnValue = switch (sortOptions) {
                default -> throw new IncompatibleClassChangeError();
                case JewelOptions.NAME -> SortingHelper.compareString(leftName, rightName);
                case JewelOptions.ATTRIBUTE -> SortingHelper.compareIntegerValue(leftData.m_128451_(EXTRA_ATTRIBUTE_INDEX), rightData.m_128451_(EXTRA_ATTRIBUTE_INDEX));
                case JewelOptions.ATTRIBUTE_VALUE -> SortingHelper.compareDoubleValue(leftData.m_128459_(EXTRA_ATTRIBUTE_VALUE), rightData.m_128459_(EXTRA_ATTRIBUTE_VALUE));
                case JewelOptions.SIZE -> SortingHelper.compareIntegerValue(leftData.m_128451_(EXTRA_JEWEL_SIZE), rightData.m_128451_(EXTRA_JEWEL_SIZE));
                case JewelOptions.ATTRIBUTE_WEIGHT -> {
                    double leftWeight = leftData.m_128459_(EXTRA_ATTRIBUTE_VALUE) / (double)leftData.m_128451_(EXTRA_JEWEL_SIZE);
                    double rightWeight = rightData.m_128459_(EXTRA_ATTRIBUTE_VALUE) / (double)rightData.m_128451_(EXTRA_JEWEL_SIZE);
                    yield SortingHelper.compareDoubleValue(leftWeight, rightWeight);
                }
                case JewelOptions.LEVEL -> SortingHelper.compareIntegerValue(leftData.m_128451_(EXTRA_GEAR_LEVEL), rightData.m_128451_(EXTRA_GEAR_LEVEL));
            };
        }
        return ascending ? returnValue : -returnValue;
    }

    public static int compareVaultGear(String leftName, VaultGearData leftData, String rightName, VaultGearData rightData, List<GearOptions> sortingOrder, boolean ascending) {
        int returnValue = 0;
        int sortingOrderSize = sortingOrder.size();
        for (int i = 0; returnValue == 0 && i < sortingOrderSize; ++i) {
            GearOptions sortOptions = sortingOrder.get(i);
            returnValue = switch (sortOptions) {
                default -> throw new IncompatibleClassChangeError();
                case GearOptions.NAME -> SortingHelper.compareString(leftName, rightName);
                case GearOptions.STATE -> SortingHelper.compareState(leftData, rightData);
                case GearOptions.RARITY -> SortingHelper.compareRarity(leftData, rightData);
                case GearOptions.LEVEL -> SortingHelper.compareLevel(leftData, rightData);
                case GearOptions.MODEL -> SortingHelper.compareModel(leftData, rightData);
            };
        }
        return ascending ? returnValue : -returnValue;
    }

    public static int compareInscriptions(String leftName, InscriptionData leftData, String rightName, InscriptionData rightData, List<InscriptionOptions> sortingOrder, boolean ascending) {
        int returnValue = 0;
        CompoundTag leftTag = leftData.serializeNBT();
        CompoundTag rightTag = rightData.serializeNBT();
        int sortingOrderSize = sortingOrder.size();
        for (int i = 0; returnValue == 0 && i < sortingOrderSize; ++i) {
            InscriptionOptions sortOptions = sortingOrder.get(i);
            returnValue = switch (sortOptions) {
                default -> throw new IncompatibleClassChangeError();
                case InscriptionOptions.NAME -> SortingHelper.compareString(leftName, rightName);
                case InscriptionOptions.INSTABILITY -> SortingHelper.compareInstability(leftTag, rightTag);
                case InscriptionOptions.COMPLETION -> SortingHelper.compareCompletion(leftTag, rightTag);
                case InscriptionOptions.TIME -> SortingHelper.compareTime(leftTag, rightTag);
                case InscriptionOptions.ROOMS -> SortingHelper.compareRooms(leftData, rightData);
            };
        }
        return ascending ? returnValue : -returnValue;
    }

    public static int compareVaultCrystals(String leftName, CrystalData leftData, String rightName, CrystalData rightData, List<CrystalOptions> sortingOrder, boolean ascending) {
        int returnValue = 0;
        int sortingOrderSize = sortingOrder.size();
        for (int i = 0; returnValue == 0 && i < sortingOrderSize; ++i) {
            CrystalOptions sortOptions = sortingOrder.get(i);
            returnValue = switch (sortOptions) {
                default -> throw new IncompatibleClassChangeError();
                case CrystalOptions.NAME -> SortingHelper.compareString(leftName, rightName);
                case CrystalOptions.LEVEL -> Integer.compare(leftData.getLevel(), rightData.getLevel());
                case CrystalOptions.TYPE -> SortingHelper.compareString(leftData.getObjective().getClass().getName(), rightData.getObjective().getClass().getName());
            };
        }
        return ascending ? returnValue : -returnValue;
    }

    public static int compareTrinkets(String leftName, AttributeGearData leftData, CompoundTag leftTag, String rightName, AttributeGearData rightData, CompoundTag rightTag, List<TrinketOptions> sortingOrder, boolean ascending) {
        int returnValue = Boolean.compare(SortingHelper.isIdentified(leftData), SortingHelper.isIdentified(rightData));
        if (!SortingHelper.isIdentified(leftData) && returnValue == 0) {
            return 0;
        }
        int sortingOrderSize = sortingOrder.size();
        for (int i = 0; returnValue == 0 && i < sortingOrderSize; ++i) {
            TrinketOptions sortOptions = sortingOrder.get(i);
            returnValue = switch (sortOptions) {
                default -> throw new IncompatibleClassChangeError();
                case TrinketOptions.NAME -> SortingHelper.compareString(leftName, rightName);
                case TrinketOptions.USES -> Integer.compare(SortingHelper.getRemainingUses(leftTag), SortingHelper.getRemainingUses(rightTag));
                case TrinketOptions.TYPE -> {
                    Optional leftValue = leftData.getFirstValue(ModGearAttributes.TRINKET_EFFECT);
                    Optional rightValue = rightData.getFirstValue(ModGearAttributes.TRINKET_EFFECT);
                    if (leftValue.isPresent() && rightValue.isPresent()) {
                        yield SortingHelper.compareString(((TrinketEffect)leftValue.get()).getTrinketConfig().getName(), ((TrinketEffect)rightValue.get()).getTrinketConfig().getName());
                    }
                    yield Boolean.compare(leftValue.isPresent(), rightValue.isPresent());
                }
                case TrinketOptions.SLOT -> {
                    Optional leftValue = leftData.getFirstValue(ModGearAttributes.TRINKET_EFFECT);
                    Optional rightValue = rightData.getFirstValue(ModGearAttributes.TRINKET_EFFECT);
                    if (leftValue.isPresent() && rightValue.isPresent()) {
                        if (((TrinketEffect)leftValue.get()).getConfig().hasCuriosSlot() && ((TrinketEffect)rightValue.get()).getConfig().hasCuriosSlot()) {
                            yield SortingHelper.compareString(((TrinketEffect)leftValue.get()).getConfig().getCuriosSlot(), ((TrinketEffect)rightValue.get()).getConfig().getCuriosSlot());
                        }
                        yield Boolean.compare(((TrinketEffect)leftValue.get()).getConfig().hasCuriosSlot(), ((TrinketEffect)rightValue.get()).getConfig().hasCuriosSlot());
                    }
                    yield Boolean.compare(leftValue.isPresent(), rightValue.isPresent());
                }
            };
        }
        return ascending ? returnValue : -returnValue;
    }

    public static int compareVaultDolls(String leftName, CompoundTag leftTag, String rightName, CompoundTag rightTag, List<DollOptions> sortingOrder, boolean ascending) {
        int returnValue = 0;
        int sortingOrderSize = sortingOrder.size();
        for (int i = 0; returnValue == 0 && i < sortingOrderSize; ++i) {
            DollOptions sortOptions = sortingOrder.get(i);
            returnValue = switch (sortOptions) {
                default -> throw new IncompatibleClassChangeError();
                case DollOptions.NAME -> SortingHelper.compareString(leftName, rightName);
                case DollOptions.OWNER -> SortingHelper.compareString(SortingHelper.getDollName(leftTag), SortingHelper.getDollName(rightTag));
                case DollOptions.XP -> Double.compare(SortingHelper.getDollXP(leftTag), SortingHelper.getDollXP(rightTag));
                case DollOptions.LOOT -> Double.compare(SortingHelper.getDollLoot(leftTag), SortingHelper.getDollLoot(rightTag));
                case DollOptions.COMPLETED -> Boolean.compare(SortingHelper.getDollCompletion(leftTag), SortingHelper.getDollCompletion(rightTag));
            };
        }
        return ascending ? returnValue : -returnValue;
    }

    public static int compareCharms(String leftName, AttributeGearData leftData, CompoundTag leftTag, String rightName, AttributeGearData rightData, CompoundTag rightTag, List<CharmOptions> sortingOrder, boolean ascending) {
        int returnValue = Boolean.compare(SortingHelper.isIdentified(leftData), SortingHelper.isIdentified(rightData));
        if (!SortingHelper.isIdentified(leftData) && returnValue == 0) {
            return 0;
        }
        int sortingOrderSize = sortingOrder.size();
        for (int i = 0; returnValue == 0 && i < sortingOrderSize; ++i) {
            CharmOptions sortOptions = sortingOrder.get(i);
            returnValue = switch (sortOptions) {
                default -> throw new IncompatibleClassChangeError();
                case CharmOptions.NAME -> SortingHelper.compareString(leftName, rightName);
                case CharmOptions.USES -> Integer.compare(SortingHelper.getRemainingUses(leftTag), SortingHelper.getRemainingUses(rightTag));
                case CharmOptions.VALUE -> Float.compare(SortingHelper.getCharmValue(leftTag), SortingHelper.getCharmValue(rightTag));
            };
        }
        return ascending ? returnValue : -returnValue;
    }

    private static int compareString(String leftName, String rightName) {
        return leftName.compareTo(rightName);
    }

    private static int compareAttribute(VaultGearAttribute<?> leftAttribute, VaultGearAttribute<?> rightAttribute) {
        return Integer.compare(AttributeHelper.getAttributeIndex(leftAttribute), AttributeHelper.getAttributeIndex(rightAttribute));
    }

    private static int compareAttributeValue(VaultGearData leftData, VaultGearAttribute<?> leftAttribute, VaultGearData rightData, VaultGearAttribute<?> rightAttribute) {
        if (SortingHelper.compareAttribute(leftAttribute, rightAttribute) != 0 || leftAttribute == null) {
            return 0;
        }
        if (AttributeHelper.isFloatAttribute(leftAttribute)) {
            Optional leftValue = leftData.getFirstValue(leftAttribute);
            Optional rightValue = rightData.getFirstValue(leftAttribute);
            return leftValue.orElse(Float.valueOf(0.0f)).compareTo(rightValue.orElse(Float.valueOf(0.0f)));
        }
        if (AttributeHelper.isIntegerAttribute(leftAttribute)) {
            Optional leftValue = leftData.getFirstValue(leftAttribute);
            Optional rightValue = rightData.getFirstValue(leftAttribute);
            return leftValue.orElse(0).compareTo(rightValue.orElse(0));
        }
        if (AttributeHelper.isDoubleAttribute(leftAttribute)) {
            Optional leftValue = leftData.getFirstValue(leftAttribute);
            Optional rightValue = rightData.getFirstValue(leftAttribute);
            return leftValue.orElse(0.0).compareTo(rightValue.orElse(0.0));
        }
        return 0;
    }

    private static int compareAttributeValueWeight(VaultGearData leftData, VaultGearAttribute<?> leftAttribute, VaultGearData rightData, VaultGearAttribute<?> rightAttribute) {
        if (SortingHelper.compareAttribute(leftAttribute, rightAttribute) != 0 || leftAttribute == null) {
            return 0;
        }
        int leftSize = leftData.getFirstValue(ModGearAttributes.JEWEL_SIZE).orElse(0);
        int rightSize = rightData.getFirstValue(ModGearAttributes.JEWEL_SIZE).orElse(0);
        if (leftSize == 0 && rightSize == 0) {
            return 0;
        }
        if (leftSize == 0) {
            return -1;
        }
        if (rightSize == 0) {
            return 1;
        }
        if (AttributeHelper.isFloatAttribute(leftAttribute)) {
            float leftValue = leftData.getFirstValue(leftAttribute).orElse(Float.valueOf(0.0f)).floatValue();
            float rightValue = rightData.getFirstValue(leftAttribute).orElse(Float.valueOf(0.0f)).floatValue();
            return Float.compare(leftValue / (float)leftSize, rightValue / (float)rightSize);
        }
        if (AttributeHelper.isIntegerAttribute(leftAttribute)) {
            int leftValue = leftData.getFirstValue(leftAttribute).orElse(0);
            int rightValue = rightData.getFirstValue(leftAttribute).orElse(0);
            return Integer.compare(leftValue / leftSize, rightValue / rightSize);
        }
        if (AttributeHelper.isDoubleAttribute(leftAttribute)) {
            double leftValue = leftData.getFirstValue(leftAttribute).orElse(0.0);
            double rightValue = rightData.getFirstValue(leftAttribute).orElse(0.0);
            return Double.compare(leftValue / (double)leftSize, rightValue / (double)rightSize);
        }
        return 0;
    }

    private static int compareSizeAttribute(VaultGearData leftData, VaultGearData rightData) {
        Optional leftSize = leftData.getFirstValue(ModGearAttributes.JEWEL_SIZE);
        Optional rightSize = rightData.getFirstValue(ModGearAttributes.JEWEL_SIZE);
        return leftSize.orElse(0).compareTo(rightSize.orElse(0));
    }

    private static int compareLevel(VaultGearData leftData, VaultGearData rightData) {
        return Integer.compare(leftData.getItemLevel(), rightData.getItemLevel());
    }

    private static int compareState(VaultGearData leftData, VaultGearData rightData) {
        return leftData.getState().compareTo((Enum)rightData.getState());
    }

    private static int compareRarity(VaultGearData leftData, VaultGearData rightData) {
        String rightRoll;
        String leftRoll;
        if (leftData.getState() != rightData.getState()) {
            return SortingHelper.compareState(leftData, rightData);
        }
        if (leftData.getState().equals((Object)VaultGearState.IDENTIFIED)) {
            return leftData.getRarity().compareTo((Enum)rightData.getRarity());
        }
        Optional leftValue = leftData.getFirstValue(ModGearAttributes.GEAR_ROLL_TYPE);
        Optional rightValue = rightData.getFirstValue(ModGearAttributes.GEAR_ROLL_TYPE);
        if (leftValue.isPresent() && rightValue.isPresent() && !(leftRoll = (String)leftValue.get()).equals(rightRoll = (String)rightValue.get())) {
            int rightIndex;
            int leftIndex = AttributeHelper.getRollIndex((String)leftValue.get());
            if (leftIndex == (rightIndex = AttributeHelper.getRollIndex((String)rightValue.get()))) {
                return SortingHelper.compareString(leftRoll, rightRoll);
            }
            return Integer.compare(leftIndex, rightIndex);
        }
        return 0;
    }

    private static int compareModel(VaultGearData leftData, VaultGearData rightData) {
        if (leftData.getState() != rightData.getState()) {
            return SortingHelper.compareState(leftData, rightData);
        }
        if (leftData.getState().equals((Object)VaultGearState.IDENTIFIED)) {
            Optional leftValue = leftData.getFirstValue(ModGearAttributes.GEAR_MODEL);
            Optional rightValue = rightData.getFirstValue(ModGearAttributes.GEAR_MODEL);
            if (leftValue.isPresent() && rightValue.isPresent()) {
                return ((ResourceLocation)leftValue.get()).compareTo((ResourceLocation)rightValue.get());
            }
        }
        return 0;
    }

    private static int compareInstability(CompoundTag leftData, CompoundTag rightData) {
        return leftData.m_128441_("instability") && rightData.m_128441_("instability") ? Integer.compare(leftData.m_128451_("instability"), rightData.m_128451_("instability")) : 0;
    }

    private static int compareCompletion(CompoundTag leftData, CompoundTag rightData) {
        return leftData.m_128441_("completion") && rightData.m_128441_("completion") ? Float.compare(leftData.m_128457_("completion"), rightData.m_128457_("completion")) : 0;
    }

    private static int compareTime(CompoundTag leftData, CompoundTag rightData) {
        return leftData.m_128441_("time") && rightData.m_128441_("time") ? Integer.compare(leftData.m_128451_("time"), rightData.m_128451_("time")) : 0;
    }

    private static int compareRooms(InscriptionData leftData, InscriptionData rightData) {
        int rightRooms;
        int leftRooms = leftData.getEntries().size();
        if (leftRooms != (rightRooms = rightData.getEntries().size())) {
            return Integer.compare(leftRooms, rightRooms);
        }
        if (leftRooms == 1) {
            InscriptionData.Entry leftEntry = (InscriptionData.Entry)leftData.getEntries().get(0);
            InscriptionData.Entry rightEntry = (InscriptionData.Entry)rightData.getEntries().get(0);
            String leftRoomName = leftEntry.toRoomEntry().getName().getString();
            String rightRoomName = rightEntry.toRoomEntry().getName().getString();
            return leftRoomName.compareTo(rightRoomName);
        }
        return 0;
    }

    private static int compareIntegerValue(Integer leftValue, Integer rightValue) {
        if (leftValue == null && rightValue != null) {
            return -1;
        }
        if (leftValue != null && rightValue == null) {
            return 1;
        }
        if (leftValue == null) {
            return 0;
        }
        return Integer.compare(leftValue, rightValue);
    }

    private static int compareDoubleValue(Double leftValue, Double rightValue) {
        if (leftValue == null && rightValue != null) {
            return -1;
        }
        if (leftValue != null && rightValue == null) {
            return 1;
        }
        if (leftValue == null) {
            return 0;
        }
        return Double.compare(leftValue, rightValue);
    }

    private static int compareAttributeValueWeight(IExtraGearDataCache leftValue, IExtraGearDataCache rightValue) {
        Integer leftSize = leftValue.getExtraJewelSize();
        Integer rightSize = rightValue.getExtraJewelSize();
        if (leftSize == null && rightSize == null) {
            return 0;
        }
        if (leftSize == null || leftSize == 0) {
            return -1;
        }
        if (rightSize == null || rightSize == 0) {
            return 1;
        }
        Double leftAttributeValue = leftValue.getExtraFirstAttributeValue();
        Double rightAttributeValue = rightValue.getExtraFirstAttributeValue();
        if (leftAttributeValue == null && rightAttributeValue == null) {
            return 0;
        }
        if (leftAttributeValue == null) {
            return -1;
        }
        if (rightAttributeValue == null) {
            return 1;
        }
        return Double.compare(leftAttributeValue / (double)leftSize.intValue(), rightAttributeValue / (double)rightSize.intValue());
    }

    private static int getRemainingUses(CompoundTag tag) {
        return Math.max(SortingHelper.getVaultUses(tag) - SortingHelper.getUsedVaults(tag), 0);
    }

    private static int getVaultUses(CompoundTag tag) {
        return tag.m_128441_("vaultUses") ? tag.m_128451_("vaultUses") : 0;
    }

    private static int getUsedVaults(CompoundTag tag) {
        return tag.m_128441_("usedVaults") ? tag.m_128437_("usedVaults", 10).size() : 0;
    }

    private static String getDollName(CompoundTag tag) {
        return tag.m_128441_("playerProfile") && tag.m_128469_("playerProfile").m_128441_("Name") ? tag.m_128469_("playerProfile").m_128461_("Name") : "";
    }

    private static float getDollXP(CompoundTag tag) {
        return tag.m_128441_("xpPercent") ? tag.m_128457_("xpPercent") : 0.0f;
    }

    private static float getDollLoot(CompoundTag tag) {
        return tag.m_128441_("lootPercent") ? tag.m_128457_("lootPercent") : 0.0f;
    }

    private static boolean getDollCompletion(CompoundTag tag) {
        return tag.m_128441_("vaultUUID");
    }

    private static float getCharmValue(CompoundTag tag) {
        return tag.m_128441_("charmValue") ? tag.m_128457_("charmValue") : 0.0f;
    }

    private static boolean isIdentified(AttributeGearData data) {
        return data.getFirstValue(ModGearAttributes.STATE).orElse(VaultGearState.UNIDENTIFIED) == VaultGearState.IDENTIFIED;
    }

    static {
        VAULT_GEAR_SET.add(ModItems.HELMET.getRegistryName());
        VAULT_GEAR_SET.add(ModItems.CHESTPLATE.getRegistryName());
        VAULT_GEAR_SET.add(ModItems.LEGGINGS.getRegistryName());
        VAULT_GEAR_SET.add(ModItems.BOOTS.getRegistryName());
        VAULT_GEAR_SET.add(ModItems.SWORD.getRegistryName());
        VAULT_GEAR_SET.add(ModItems.AXE.getRegistryName());
        VAULT_GEAR_SET.add(ModItems.WAND.getRegistryName());
        VAULT_GEAR_SET.add(ModItems.SHIELD.getRegistryName());
        VAULT_GEAR_SET.add(ModItems.MAGNET.getRegistryName());
        VAULT_GEAR_SET.add(ModItems.IDOL_BENEVOLENT.getRegistryName());
        VAULT_GEAR_SET.add(ModItems.IDOL_OMNISCIENT.getRegistryName());
        VAULT_GEAR_SET.add(ModItems.IDOL_TIMEKEEPER.getRegistryName());
        VAULT_GEAR_SET.add(ModItems.IDOL_MALEVOLENCE.getRegistryName());
        VAULT_GEAR_SET.add(ModItems.FOCUS.getRegistryName());
        VAULT_CHARMS.add(ModItems.SMALL_CHARM.getRegistryName());
        VAULT_CHARMS.add(ModItems.LARGE_CHARM.getRegistryName());
        VAULT_CHARMS.add(ModItems.GRAND_CHARM.getRegistryName());
        VAULT_CHARMS.add(ModItems.MAJESTIC_CHARM.getRegistryName());
    }

    public static enum JewelOptions {
        NAME,
        ATTRIBUTE,
        ATTRIBUTE_VALUE,
        SIZE,
        ATTRIBUTE_WEIGHT,
        LEVEL;

    }

    public static enum GearOptions {
        NAME,
        LEVEL,
        RARITY,
        STATE,
        MODEL;

    }

    public static enum InscriptionOptions {
        NAME,
        COMPLETION,
        TIME,
        INSTABILITY,
        ROOMS;

    }

    public static enum CrystalOptions {
        NAME,
        LEVEL,
        TYPE;

    }

    public static enum TrinketOptions {
        NAME,
        TYPE,
        SLOT,
        USES;

    }

    public static enum DollOptions {
        NAME,
        OWNER,
        COMPLETED,
        XP,
        LOOT;

    }

    public static enum CharmOptions {
        NAME,
        VALUE,
        USES;

    }
}

