/*
 * Decompiled with CFR 0.152.
 */
package iskallia.auxiliaryblocks.block;

import iskallia.auxiliaryblocks.AuxiliaryBlocks;
import iskallia.auxiliaryblocks.init.ModRegistries;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class BlockRegistryData<T extends Block> {
    private Supplier<T> block;
    private final ResourceLocation id;
    private CreativeModeTab category;
    private boolean hasBlockItem;

    private BlockRegistryData(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean hasBlockItem() {
        return this.hasBlockItem;
    }

    public Supplier<T> getBlock() {
        return this.block;
    }

    public CreativeModeTab getCategory() {
        return this.category;
    }

    public static class Builder<T extends Block> {
        private final ResourceLocation id;
        private CreativeModeTab category = ModRegistries.AUX_GROUP;
        private Supplier<T> block = () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_));
        private boolean hasBlockItem = true;

        public Builder(ResourceLocation id) {
            this.id = id;
        }

        public static <T extends Block> Builder<T> create(String id) {
            return new Builder<T>(AuxiliaryBlocks.id(id));
        }

        public Builder<T> withBlock(Supplier<T> block) {
            this.block = block;
            return this;
        }

        public Builder<T> withCategory(CreativeModeTab category) {
            this.category = category;
            return this;
        }

        public Builder<T> noBlockItem() {
            this.hasBlockItem = false;
            return this;
        }

        public BlockRegistryData<T> build() {
            BlockRegistryData data = new BlockRegistryData(this.id);
            data.block = this.block;
            data.category = this.category;
            data.hasBlockItem = this.hasBlockItem;
            return data;
        }
    }
}

