/*
 * Decompiled with CFR 0.152.
 */
package iskallia.auxiliaryblocks.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Random;

public abstract class Config {
    protected static final Random rand = new Random();
    private static final Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();
    protected String root = "config/auxiliaryblocks/";
    protected String extension = ".json";

    public void generateConfig() {
        this.reset();
        try {
            this.writeConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getConfigFile() {
        String parent = this.root + this.getFolder();
        String child = this.getName() + this.extension;
        return new File(parent, child);
    }

    public abstract String getName();

    public abstract String getFolder();

    public <T extends Config> T readConfig() {
        try {
            return (T)((Config)GSON.fromJson((Reader)new FileReader(this.getConfigFile()), this.getClass()));
        }
        catch (FileNotFoundException e) {
            this.generateConfig();
            return (T)this;
        }
    }

    protected abstract void reset();

    public void writeConfig() throws IOException {
        File dir = new File(this.root + this.getFolder());
        if (!dir.exists() && !dir.mkdirs()) {
            return;
        }
        if (!this.getConfigFile().exists() && !this.getConfigFile().createNewFile()) {
            return;
        }
        FileWriter writer = new FileWriter(this.getConfigFile());
        GSON.toJson((Object)this, (Appendable)writer);
        writer.flush();
        writer.close();
    }
}

