/*
 * Decompiled with CFR 0.152.
 */
package iskallia.auxiliaryblocks.mixin;

import iskallia.auxiliaryblocks.mixin.plugin.WaterloggingHelper;
import iskallia.auxiliaryblocks.util.FluidStateHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BaseRailBlock.class})
public class BaseRailBlockMixin {
    @Inject(method={"getStateForPlacement"}, at={@At(value="RETURN")}, cancellable=true)
    public void getStateForPlacement(BlockPlaceContext context, CallbackInfoReturnable<BlockState> cir) {
        WaterloggingHelper.applyWaterColorState(context, cir);
    }

    @Inject(method={"getFluidState"}, at={@At(value="RETURN")}, cancellable=true)
    public void getFluidState(BlockState state, CallbackInfoReturnable<FluidState> cir) {
        cir.setReturnValue((Object)FluidStateHelper.getFluidState(state));
    }

    @Redirect(method={"updateShape"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/LevelAccessor;scheduleTick(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/material/Fluid;I)V"))
    public void updateShape(LevelAccessor level, BlockPos currentPos, Fluid fluid, int tickDelay) {
        level.m_186469_(currentPos, fluid, fluid.m_6718_((LevelReader)level));
    }
}

