/*
 * Decompiled with CFR 0.152.
 */
package iskallia.auxiliaryblocks.mixin;

import iskallia.auxiliaryblocks.mixin.plugin.WaterloggingHelper;
import iskallia.auxiliaryblocks.tags.ModTags;
import iskallia.auxiliaryblocks.util.FluidStateHelper;
import iskallia.auxiliaryblocks.util.ModBlockStateProperties;
import iskallia.auxiliaryblocks.util.WaterColor;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SmallDripleafBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SmallDripleafBlock.class})
public class SmallDripleafBlockMixin {
    @Shadow
    @Final
    private static BooleanProperty f_154580_;

    @Inject(method={"createBlockStateDefinition"}, at={@At(value="RETURN")})
    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder, CallbackInfo ci) {
        builder.m_61104_(new Property[]{ModBlockStateProperties.WATER_COLOR});
    }

    @Inject(method={"getStateForPlacement"}, at={@At(value="RETURN")}, cancellable=true)
    public void getStateForPlacement(BlockPlaceContext context, CallbackInfoReturnable<BlockState> cir) {
        WaterloggingHelper.applyWaterColorState(context, cir);
    }

    @Inject(method={"getFluidState"}, at={@At(value="RETURN")}, cancellable=true)
    public void getFluidState(BlockState state, CallbackInfoReturnable<FluidState> cir) {
        cir.setReturnValue((Object)FluidStateHelper.getFluidState(state));
    }

    @Redirect(method={"updateShape"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/LevelAccessor;scheduleTick(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/material/Fluid;I)V"))
    public void updateShape(LevelAccessor level, BlockPos currentPos, Fluid fluid, int tickDelay) {
        BlockState state = level.m_8055_(currentPos);
        FluidStateHelper.getFluidState(state);
        level.m_186469_(currentPos, fluid, fluid.m_6718_((LevelReader)level));
    }

    @Inject(method={"mayPlaceOn"}, at={@At(value="RETURN")}, cancellable=true)
    protected void mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (level.m_6425_(pos.m_7494_()).m_205070_(ModTags.COLORED_WATER_SOURCE)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Redirect(method={"setPlacedBy"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/DoublePlantBlock;copyWaterloggedFrom(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/state/BlockState;"))
    public BlockState setPlacedBy(LevelReader level, BlockPos pos, BlockState state) {
        FluidState fluidState = level.m_6425_(pos);
        if (state.m_61138_((Property)f_154580_) && fluidState.m_205070_(FluidTags.f_13131_)) {
            return (BlockState)((BlockState)state.m_61124_((Property)f_154580_, (Comparable)Boolean.valueOf(true))).m_61124_(ModBlockStateProperties.WATER_COLOR, (Comparable)((Object)WaterColor.valueOf(fluidState.m_76152_().getAttributes().getColor())));
        }
        return state;
    }
}

