/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization;

import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.konkrete.Konkrete;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSerializer;
import de.keksuccino.konkrete.properties.PropertiesSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.versions.mcp.MCPVersion;

public class CustomizationPropertiesHandler {
    private static List<PropertiesSet> properties = new ArrayList<PropertiesSet>();
    private static List<PropertiesSet> disabled = new ArrayList<PropertiesSet>();

    public static void loadProperties() {
        File f = DrippyLoadingScreen.CUSTOMIZATION_DIR;
        properties = CustomizationPropertiesHandler.parsePropertiesFromDir(f);
        File f3 = new File(DrippyLoadingScreen.CUSTOMIZATION_DIR.getPath() + "/.disabled");
        disabled = CustomizationPropertiesHandler.parsePropertiesFromDir(f3);
    }

    public static List<PropertiesSet> parsePropertiesFromDir(File dir) {
        ArrayList<PropertiesSet> props = new ArrayList<PropertiesSet>();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        for (File f2 : dir.listFiles()) {
            List l;
            PropertiesSet s;
            if (!f2.getPath().toLowerCase().endsWith(".dllayout") || (s = PropertiesSerializer.getProperties((String)f2.getAbsolutePath())) == null || !s.getPropertiesType().equalsIgnoreCase("hud") || (l = s.getPropertiesOfType("customization-meta")).isEmpty()) continue;
            String s3 = ((PropertiesSection)l.get(0)).getEntryValue("requiredmods");
            String s4 = ((PropertiesSection)l.get(0)).getEntryValue("minimumfhversion");
            String s5 = ((PropertiesSection)l.get(0)).getEntryValue("maximumfhversion");
            String s6 = ((PropertiesSection)l.get(0)).getEntryValue("minimummcversion");
            String s7 = ((PropertiesSection)l.get(0)).getEntryValue("maximummcversion");
            if (!CustomizationPropertiesHandler.isVersionCompatible(s4, s5, "1.6.6") || !CustomizationPropertiesHandler.isVersionCompatible(s6, s7, MCPVersion.getMCVersion()) || !CustomizationPropertiesHandler.allRequiredModsLoaded(s3)) continue;
            ((PropertiesSection)l.get(0)).addEntry("path", f2.getPath());
            props.add(s);
        }
        return props;
    }

    private static String fillUpToLength(String s, String fillWith, int length) {
        Object out = s;
        int add = length - s.length();
        for (int i = 1; i <= add; ++i) {
            out = (String)out + fillWith;
        }
        return out;
    }

    private static boolean isVersionCompatible(String minimum, String maximum, String version) {
        if (version == null) {
            return true;
        }
        String versionRaw = CustomizationPropertiesHandler.fillUpToLength(StringUtils.replaceAllExceptOf((String)version, (String)"", (String[])new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"}), "0", 9);
        if (MathUtils.isInteger((String)versionRaw)) {
            String maxRaw;
            int max;
            String maxShort;
            String minRaw;
            int min;
            String minShort;
            int ver = Integer.parseInt(versionRaw);
            if (minimum != null && (minShort = StringUtils.replaceAllExceptOf((String)minimum, (String)"", (String[])new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"})).length() > 0 && MathUtils.isInteger((String)minShort) && ver < (min = Integer.parseInt(minRaw = CustomizationPropertiesHandler.fillUpToLength(minShort, "0", 9)))) {
                return false;
            }
            if (maximum != null && (maxShort = StringUtils.replaceAllExceptOf((String)maximum, (String)"", (String[])new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"})).length() > 0 && MathUtils.isInteger((String)maxShort) && ver > (max = Integer.parseInt(maxRaw = CustomizationPropertiesHandler.fillUpToLength(maxShort, "0", 9)))) {
                return false;
            }
        }
        return true;
    }

    private static boolean allRequiredModsLoaded(String requiredMods) {
        if (requiredMods == null || requiredMods.replace(" ", "").length() == 0) {
            return true;
        }
        ArrayList<Object> mods = new ArrayList<Object>();
        if (requiredMods.contains(",")) {
            for (String s : requiredMods.replace(" ", "").split("[,]")) {
                if (s.length() <= 0) continue;
                mods.add(s);
            }
        } else {
            mods.add(requiredMods.replace(" ", ""));
        }
        for (String string : mods) {
            if (!(string.equals("optifine") ? !Konkrete.isOptifineLoaded : !ModList.get().isLoaded(string))) continue;
            return false;
        }
        return true;
    }

    public static List<PropertiesSet> getProperties() {
        return properties;
    }

    public static List<PropertiesSet> getDisabledProperties() {
        return disabled;
    }

    public static List<PropertiesSet> getPropertiesWithIdentifier(String identifier) {
        ArrayList<PropertiesSet> l = new ArrayList<PropertiesSet>();
        for (PropertiesSet s : CustomizationPropertiesHandler.getProperties()) {
            String s2;
            List l2 = s.getPropertiesOfType("customization-meta");
            if (l2.isEmpty() || !(s2 = ((PropertiesSection)l2.get(0)).getEntryValue("identifier")).equalsIgnoreCase(identifier)) continue;
            l.add(s);
        }
        return l;
    }

    public static List<PropertiesSet> getDisabledPropertiesWithIdentifier(String identifier) {
        ArrayList<PropertiesSet> l = new ArrayList<PropertiesSet>();
        for (PropertiesSet s : CustomizationPropertiesHandler.getDisabledProperties()) {
            String s2;
            List l2 = s.getPropertiesOfType("customization-meta");
            if (l2.isEmpty() || !(s2 = ((PropertiesSection)l2.get(0)).getEntryValue("identifier")).equalsIgnoreCase(identifier)) continue;
            l.add(s);
        }
        return l;
    }
}

