/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.helper.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.content.FHContextMenu;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.input.MouseInput;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;

public class UIBase
extends GuiComponent {
    protected static Color idleButtonColor;
    protected static Color hoveredButtonColor;
    protected static Color idleButtonBorderColor;
    protected static Color hoveredButtonBorderColor;
    protected static float buttonBorderWidth;
    protected static float baseUIScale;

    protected static void initButtonColors() {
        if (idleButtonColor == null) {
            idleButtonColor = new Color(71, 71, 71);
            hoveredButtonColor = new Color(83, 156, 212);
            idleButtonBorderColor = new Color(209, 194, 209);
            hoveredButtonBorderColor = new Color(227, 211, 227);
        }
    }

    public static void colorizeButton(AdvancedButton button) {
        UIBase.initButtonColors();
        button.setBackgroundColor(idleButtonColor, hoveredButtonColor, idleButtonBorderColor, hoveredButtonBorderColor, buttonBorderWidth);
    }

    public static Color getButtonIdleColor() {
        UIBase.initButtonColors();
        return idleButtonColor;
    }

    public static Color getButtonBorderIdleColor() {
        UIBase.initButtonColors();
        return idleButtonBorderColor;
    }

    public static Color getButtonHoverColor() {
        UIBase.initButtonColors();
        return hoveredButtonColor;
    }

    public static Color getButtonBorderHoverColor() {
        UIBase.initButtonColors();
        return hoveredButtonBorderColor;
    }

    public static float getUIScale() {
        float uiScale = ((Float)DrippyLoadingScreen.config.getOrDefault("uiscale", (Object)Float.valueOf(1.0f))).floatValue();
        double mcScale = Minecraft.m_91087_().m_91268_().m_85449_();
        return (float)((double)baseUIScale * ((double)baseUIScale / mcScale) * (double)uiScale);
    }

    public static void openScaledContextMenuAt(FHContextMenu menu, int x, int y) {
        Screen s = Minecraft.m_91087_().f_91080_;
        if (s != null) {
            menu.openMenuAt((int)((float)x / UIBase.getUIScale()), (int)((float)y / UIBase.getUIScale()), (int)((float)s.f_96543_ / UIBase.getUIScale()), (int)((float)s.f_96544_ / UIBase.getUIScale()));
        }
    }

    public static void openScaledContextMenuAtMouse(FHContextMenu menu) {
        UIBase.openScaledContextMenuAt(menu, MouseInput.getMouseX(), MouseInput.getMouseY());
    }

    public static void renderScaledContextMenu(PoseStack matrix, FHContextMenu menu) {
        Screen s = Minecraft.m_91087_().f_91080_;
        if (s != null && menu != null) {
            matrix.m_85836_();
            matrix.m_85841_(UIBase.getUIScale(), UIBase.getUIScale(), UIBase.getUIScale());
            MouseInput.setRenderScale((float)UIBase.getUIScale());
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            MouseInput.resetRenderScale();
            menu.render(matrix, mouseX, mouseY, (int)((float)s.f_96543_ / UIBase.getUIScale()), (int)((float)s.f_96544_ / UIBase.getUIScale()));
            matrix.m_85849_();
        }
    }

    static {
        buttonBorderWidth = 1.0f;
        baseUIScale = 1.0f;
    }
}

