/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.helper.ui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.UIBase;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class ScrollableScreen
extends Screen {
    protected static final Color ENTRY_BACKGROUND_COLOR = new Color(92, 92, 92);
    protected static final Color SCREEN_BACKGROUND_COLOR = new Color(54, 54, 54);
    protected static final Color HEADER_FOOTER_COLOR = new Color(33, 33, 33);
    protected ScrollArea scrollArea;
    protected Screen parent;
    protected String f_96539_;

    public ScrollableScreen(Screen parent, String title) {
        super((Component)new TextComponent(""));
        this.parent = parent;
        this.f_96539_ = title;
        this.scrollArea = new ScrollArea(0, 50, 300, 0);
        this.scrollArea.backgroundColor = ENTRY_BACKGROUND_COLOR;
    }

    protected void m_7856_() {
        this.scrollArea.x = this.f_96543_ / 2 - 150;
        this.scrollArea.height = this.f_96544_ - 100;
    }

    public void m_7379_() {
        if (!PopupHandler.isPopupActive()) {
            Minecraft.m_91087_().m_91152_(this.parent);
        }
    }

    public boolean m_6913_() {
        return true;
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_69478_();
        ScrollableScreen.m_93172_((PoseStack)matrix, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)SCREEN_BACKGROUND_COLOR.getRGB());
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            if (!(e instanceof ScrollAreaEntryBase)) continue;
            ((ScrollAreaEntryBase)e).isOverlayButtonHovered = this.isOverlayButtonHovered();
        }
        this.scrollArea.render(matrix);
        ScrollableScreen.m_93172_((PoseStack)matrix, (int)0, (int)0, (int)this.f_96543_, (int)50, (int)HEADER_FOOTER_COLOR.getRGB());
        ScrollableScreen.m_93208_((PoseStack)matrix, (Font)this.f_96547_, (String)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)-1);
        ScrollableScreen.m_93172_((PoseStack)matrix, (int)0, (int)(this.f_96544_ - 50), (int)this.f_96543_, (int)this.f_96544_, (int)HEADER_FOOTER_COLOR.getRGB());
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            if (!(e instanceof ScrollAreaEntryBase) || !((ScrollAreaEntryBase)e).isOverlayButtonHoveredAndOverlapsArea() || ((ScrollAreaEntryBase)e).description == null) continue;
            ScrollableScreen.renderDescription(matrix, ((ScrollAreaEntryBase)e).description, MouseInput.getMouseX(), MouseInput.getMouseY());
            break;
        }
    }

    protected static void renderDescription(PoseStack matrix, List<String> desc, int mouseX, int mouseY) {
        if (desc != null) {
            int width = 10;
            int height = 10;
            for (String s : desc) {
                int i = Minecraft.m_91087_().f_91062_.m_92895_(s) + 10;
                if (i > width) {
                    width = i;
                }
                height += 10;
            }
            mouseY += 5;
            if (Minecraft.m_91087_().f_91080_.f_96543_ < (mouseX += 5) + width) {
                mouseX -= width + 10;
            }
            if (Minecraft.m_91087_().f_91080_.f_96544_ < mouseY + height) {
                mouseY -= height + 10;
            }
            RenderUtils.setZLevelPre((PoseStack)matrix, (int)600);
            ScrollableScreen.renderDescriptionBackground(matrix, mouseX, mouseY, width, height);
            RenderSystem.m_69478_();
            int i2 = 5;
            for (String s : desc) {
                ScrollableScreen.m_93236_((PoseStack)matrix, (Font)Minecraft.m_91087_().f_91062_, (String)s, (int)(mouseX + 5), (int)(mouseY + i2), (int)Color.WHITE.getRGB());
                i2 += 10;
            }
            RenderUtils.setZLevelPost((PoseStack)matrix);
            RenderSystem.m_69461_();
        }
    }

    protected static void renderDescriptionBackground(PoseStack matrix, int x, int y, int width, int height) {
        Gui.m_93172_((PoseStack)matrix, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)new Color(26, 26, 26, 250).getRGB());
    }

    public boolean isOverlayButtonHovered() {
        return false;
    }

    public static class ScrollAreaEntryBase
    extends ScrollAreaEntry {
        protected int entryHeight = 25;
        protected List<String> description = null;
        protected Consumer<EntryRenderCallback> renderBody;
        protected boolean isOverlayButtonHovered = false;

        public ScrollAreaEntryBase(ScrollArea parent, Consumer<EntryRenderCallback> renderBody) {
            super(parent);
            this.renderBody = renderBody;
        }

        public void renderEntry(PoseStack matrix) {
            EntryRenderCallback c = new EntryRenderCallback();
            c.entry = this;
            c.matrix = matrix;
            this.renderBody.accept(c);
        }

        public int getHeight() {
            return this.entryHeight;
        }

        public void setHeight(int height) {
            this.entryHeight = height;
        }

        public List<String> getDescription() {
            return this.description;
        }

        public boolean isOverlayButtonHoveredAndOverlapsArea() {
            return this.isOverlayButtonHovered && this.isHoveredOrFocused();
        }

        public void setDescription(List<String> desc) {
            this.description = desc;
        }

        public void setDescription(String[] desc) {
            this.description = Arrays.asList(desc);
        }

        public static class EntryRenderCallback {
            public ScrollAreaEntryBase entry;
            public PoseStack matrix;
        }
    }

    public static class EmptySpaceEntry
    extends ScrollAreaEntryBase {
        public EmptySpaceEntry(ScrollArea parent, int height) {
            super(parent, null);
            this.renderBody = render -> {};
            this.setHeight(height);
        }
    }

    public static class TextEntry
    extends ScrollAreaEntryBase {
        public String text;
        public boolean bold;

        public TextEntry(ScrollArea parent, String text, boolean bold) {
            super(parent, null);
            this.text = text;
            this.bold = bold;
            this.renderBody = render -> {
                if (this.text != null) {
                    Font font = Minecraft.m_91087_().f_91062_;
                    int xCenter = render.entry.x + render.entry.getWidth() / 2;
                    int yCenter = render.entry.y + render.entry.getHeight() / 2;
                    Object s = this.text;
                    if (this.bold) {
                        s = "\u00a7l" + this.text;
                    }
                    PoseStack poseStack = render.matrix;
                    Objects.requireNonNull(font);
                    TextEntry.m_93208_((PoseStack)poseStack, (Font)font, (String)s, (int)xCenter, (int)(yCenter - 9 / 2), (int)-1);
                }
            };
            this.setHeight(18);
        }
    }

    public static class TextFieldEntry
    extends ScrollAreaEntryBase {
        public AdvancedTextField textField;

        public TextFieldEntry(ScrollArea parent, AdvancedTextField textField) {
            super(parent, null);
            this.textField = textField;
            this.textField.m_94199_(10000);
            this.renderBody = render -> {
                int xCenter = render.entry.x + render.entry.getWidth() / 2;
                this.textField.f_93623_ = !this.isOverlayButtonHoveredAndOverlapsArea();
                this.textField.m_93674_(200);
                this.textField.setHeight(20);
                this.textField.m_94214_(xCenter - this.textField.m_5711_() / 2);
                this.textField.setY(render.entry.y + 2);
                this.textField.m_6305_(render.matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.m_91087_().m_91297_());
            };
            this.setHeight(24);
        }
    }

    public static class ButtonEntry
    extends ScrollAreaEntryBase {
        public AdvancedButton button;

        public ButtonEntry(ScrollArea parent, AdvancedButton button) {
            super(parent, null);
            this.button = button;
            this.renderBody = render -> {
                int xCenter = render.entry.x + render.entry.getWidth() / 2;
                UIBase.colorizeButton(this.button);
                this.button.f_93623_ = !this.isOverlayButtonHoveredAndOverlapsArea();
                this.button.m_93674_(200);
                this.button.setHeight(20);
                this.button.setX(xCenter - this.button.m_5711_() / 2);
                this.button.setY(render.entry.y + 2);
                this.button.m_6305_(render.matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.m_91087_().m_91297_());
            };
            this.setHeight(24);
        }
    }
}

